/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.feedback;

import com.example.vibe.core.feedback.FeedbackType;
import com.example.vibe.core.feedback.IFeedbackService;
import com.example.vibe.core.internal.VibeCorePlugin;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class FeedbackService
implements IFeedbackService {
    private static FeedbackService instance;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "Vibe-Feedback");
        t.setDaemon(true);
        return t;
    });
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<String, FeedbackRecord> feedbackHistory = new ConcurrentHashMap<String, FeedbackRecord>();
    private static final int MAX_HISTORY_SIZE = 1000;

    private FeedbackService() {
    }

    public static synchronized FeedbackService getInstance() {
        if (instance == null) {
            instance = new FeedbackService();
        }
        return instance;
    }

    @Override
    public CompletableFuture<Void> completionAccepted(String sessionId, String acceptedCode, int cursorOffsetBefore, int cursorOffsetAfter) {
        return CompletableFuture.runAsync(() -> {
            JsonObject data = new JsonObject();
            data.addProperty("type", FeedbackType.COMPLETION_ACCEPTED.getId());
            data.addProperty("sessionId", sessionId);
            data.addProperty("codeLength", (Number)(acceptedCode != null ? acceptedCode.length() : 0));
            data.addProperty("cursorBefore", (Number)cursorOffsetBefore);
            data.addProperty("cursorAfter", (Number)cursorOffsetAfter);
            this.recordFeedback(sessionId, FeedbackType.COMPLETION_ACCEPTED, data);
            VibeCorePlugin.logInfo("Feedback: completion accepted, session=" + sessionId + ", codeLen=" + (acceptedCode != null ? acceptedCode.length() : 0));
        }, this.executor);
    }

    @Override
    public CompletableFuture<Void> completionDismissed(String sessionId, String dismissedCode, String reason) {
        return CompletableFuture.runAsync(() -> {
            JsonObject data = new JsonObject();
            data.addProperty("type", FeedbackType.COMPLETION_DISMISSED.getId());
            data.addProperty("sessionId", sessionId);
            data.addProperty("codeLength", (Number)(dismissedCode != null ? dismissedCode.length() : 0));
            if (reason != null) {
                data.addProperty("reason", reason);
            }
            this.recordFeedback(sessionId, FeedbackType.COMPLETION_DISMISSED, data);
            VibeCorePlugin.logInfo("Feedback: completion dismissed, session=" + sessionId);
        }, this.executor);
    }

    @Override
    public CompletableFuture<Void> codeFinalized(String sessionId, String finalCode) {
        return CompletableFuture.runAsync(() -> {
            JsonObject data = new JsonObject();
            data.addProperty("type", FeedbackType.CODE_FINALIZED.getId());
            data.addProperty("sessionId", sessionId);
            data.addProperty("codeLength", (Number)(finalCode != null ? finalCode.length() : 0));
            this.recordFeedback(sessionId, FeedbackType.CODE_FINALIZED, data);
            VibeCorePlugin.logInfo("Feedback: code finalized, session=" + sessionId);
        }, this.executor);
    }

    @Override
    public CompletableFuture<Void> codeModified(String sessionId, String originalCode, String modifiedCode) {
        return CompletableFuture.runAsync(() -> {
            JsonObject data = new JsonObject();
            data.addProperty("type", FeedbackType.CODE_MODIFIED.getId());
            data.addProperty("sessionId", sessionId);
            data.addProperty("originalLength", (Number)(originalCode != null ? originalCode.length() : 0));
            data.addProperty("modifiedLength", (Number)(modifiedCode != null ? modifiedCode.length() : 0));
            boolean significantChange = originalCode != null && modifiedCode != null && Math.abs(originalCode.length() - modifiedCode.length()) > originalCode.length() / 2;
            data.addProperty("significantChange", Boolean.valueOf(significantChange));
            this.recordFeedback(sessionId, FeedbackType.CODE_MODIFIED, data);
            VibeCorePlugin.logInfo("Feedback: code modified, session=" + sessionId + ", significant=" + significantChange);
        }, this.executor);
    }

    @Override
    public CompletableFuture<Void> reportIssue(String sessionId, IFeedbackService.IssueType issueType, String description, String context) {
        return CompletableFuture.runAsync(() -> {
            JsonObject data = new JsonObject();
            data.addProperty("type", FeedbackType.ISSUE_REPORTED.getId());
            data.addProperty("sessionId", sessionId);
            data.addProperty("issueType", issueType.getId());
            if (description != null) {
                data.addProperty("description", description);
            }
            if (context != null) {
                data.addProperty("contextLength", (Number)context.length());
            }
            this.recordFeedback(sessionId, FeedbackType.ISSUE_REPORTED, data);
            VibeCorePlugin.logInfo("Feedback: issue reported, session=" + sessionId + ", type=" + issueType.getId());
        }, this.executor);
    }

    @Override
    public CompletableFuture<Void> sendFeedback(String sessionId, FeedbackType type, String metadata) {
        return CompletableFuture.runAsync(() -> {
            JsonObject data = new JsonObject();
            data.addProperty("type", type.getId());
            data.addProperty("sessionId", sessionId);
            if (metadata != null) {
                data.addProperty("metadata", metadata);
            }
            this.recordFeedback(sessionId, type, data);
            VibeCorePlugin.logInfo("Feedback: " + type.getId() + ", session=" + sessionId);
        }, this.executor);
    }

    private void recordFeedback(String sessionId, FeedbackType type, JsonObject data) {
        if (this.feedbackHistory.size() >= 1000) {
            this.feedbackHistory.keySet().stream().limit(100L).forEach(this.feedbackHistory::remove);
        }
        String key = sessionId + "_" + type.getId() + "_" + System.currentTimeMillis();
        this.feedbackHistory.put(key, new FeedbackRecord(sessionId, type, Instant.now(), data));
    }

    public Map<FeedbackType, Long> getStatistics() {
        ConcurrentHashMap<FeedbackType, Long> stats = new ConcurrentHashMap<FeedbackType, Long>();
        FeedbackType[] feedbackTypeArray = FeedbackType.values();
        int n = feedbackTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeedbackType type = feedbackTypeArray[n2];
            stats.put(type, 0L);
            ++n2;
        }
        this.feedbackHistory.values().forEach(record -> {
            Long l = stats.merge(record.type, 1L, Long::sum);
        });
        return stats;
    }

    public double getAcceptanceRate() {
        long dismissed;
        long accepted = this.feedbackHistory.values().stream().filter(r -> r.type == FeedbackType.COMPLETION_ACCEPTED).count();
        long total = accepted + (dismissed = this.feedbackHistory.values().stream().filter(r -> r.type == FeedbackType.COMPLETION_DISMISSED).count());
        return total > 0L ? (double)accepted / (double)total : -1.0;
    }

    public void clearHistory() {
        this.feedbackHistory.clear();
    }

    public void dispose() {
        this.executor.shutdown();
        this.feedbackHistory.clear();
    }

    private static class FeedbackRecord {
        final String sessionId;
        final FeedbackType type;
        final Instant timestamp;
        final JsonObject data;

        FeedbackRecord(String sessionId, FeedbackType type, Instant timestamp, JsonObject data) {
            this.sessionId = sessionId;
            this.type = type;
            this.timestamp = timestamp;
            this.data = data;
        }
    }
}

