/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.edit;

import com.example.vibe.core.edit.EditBlock;
import com.example.vibe.core.logging.VibeLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchReplaceFormat {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(SearchReplaceFormat.class);
    private static final Pattern SEARCH_REPLACE_PATTERN = Pattern.compile("<<<<<<<?\\s*SEARCH\\s*\\n(.*?)\\n?=======\\n?(.*?)\\n?>>>>>>?>?\\s*REPLACE", 34);
    private static final Pattern CODE_FENCE_PATTERN = Pattern.compile("```[a-zA-Z0-9]*\\s*\\n?(.*?)\\n?```", 32);

    public List<EditBlock> parse(String llmResponse) {
        if (llmResponse == null || llmResponse.isEmpty()) {
            return Collections.emptyList();
        }
        String normalized = llmResponse.replace("\r\n", "\n").replace("\r", "\n");
        String content = this.unwrapCodeFences(normalized);
        ArrayList<EditBlock> blocks = new ArrayList<EditBlock>();
        Matcher matcher = SEARCH_REPLACE_PATTERN.matcher(content);
        int blockIndex = 0;
        while (matcher.find()) {
            String searchText = matcher.group(1);
            String replaceText = matcher.group(2);
            searchText = this.normalizeBlockContent(searchText);
            replaceText = this.normalizeBlockContent(replaceText);
            blocks.add(new EditBlock(searchText, replaceText, blockIndex++));
            LOG.debug("Parsed EditBlock %d: search=%d chars, replace=%d chars", blockIndex - 1, searchText.length(), replaceText.length());
        }
        LOG.info("SearchReplaceFormat: parsed %d blocks from response", blocks.size());
        return blocks;
    }

    public boolean hasBlocks(String llmResponse) {
        if (llmResponse == null || llmResponse.isEmpty()) {
            return false;
        }
        String content = this.unwrapCodeFences(llmResponse);
        return SEARCH_REPLACE_PATTERN.matcher(content).find();
    }

    public String extractFilePath(String llmResponse) {
        if (llmResponse == null || llmResponse.isEmpty()) {
            return null;
        }
        Pattern filePathPattern = Pattern.compile("(?:^|\\n)(?:#\\s*|File:\\s*|path:\\s*)?([\\w/.\\-]+\\.[a-zA-Z]+)\\s*(?:\\n|$)", 8);
        Matcher matcher = filePathPattern.matcher(llmResponse);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public List<String> validate(List<EditBlock> blocks) {
        ArrayList<String> errors = new ArrayList<String>();
        if (blocks.isEmpty()) {
            errors.add("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e SEARCH/REPLACE \u0431\u043b\u043e\u043a\u043e\u0432");
            return errors;
        }
        int i = 0;
        while (i < blocks.size()) {
            EditBlock block = blocks.get(i);
            if (block.getSearchText().isEmpty() && !block.isInsertion()) {
                errors.add(String.format("\u0411\u043b\u043e\u043a %d: \u043f\u0443\u0441\u0442\u043e\u0439 SEARCH \u0442\u0435\u043a\u0441\u0442", i + 1));
            }
            if (block.getSearchText().length() > 0 && block.getSearchText().length() < 10) {
                LOG.warn("\u0411\u043b\u043e\u043a %d: \u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0439 SEARCH \u0442\u0435\u043a\u0441\u0442 (%d \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432) \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0432\u043f\u0430\u0441\u0442\u044c \u0432 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 \u043c\u0435\u0441\u0442\u0430\u0445", i + 1, block.getSearchText().length());
            }
            if (block.getSearchText().contains("<<<<<<") || block.getSearchText().contains(">>>>>>>")) {
                errors.add(String.format("\u0411\u043b\u043e\u043a %d: SEARCH \u0442\u0435\u043a\u0441\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043c\u0430\u0440\u043a\u0435\u0440\u044b \u0431\u043b\u043e\u043a\u043e\u0432", i + 1));
            }
            ++i;
        }
        return errors;
    }

    public String format(List<EditBlock> blocks) {
        StringBuilder sb = new StringBuilder();
        for (EditBlock block : blocks) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append("<<<<<<< SEARCH\n");
            sb.append(block.getSearchText());
            if (!block.getSearchText().endsWith("\n")) {
                sb.append("\n");
            }
            sb.append("=======\n");
            sb.append(block.getReplaceText());
            if (!block.getReplaceText().endsWith("\n")) {
                sb.append("\n");
            }
            sb.append(">>>>>>> REPLACE");
        }
        return sb.toString();
    }

    public static String createBlock(String oldText, String newText) {
        StringBuilder sb = new StringBuilder();
        sb.append("<<<<<<< SEARCH\n");
        sb.append(oldText);
        if (!oldText.endsWith("\n")) {
            sb.append("\n");
        }
        sb.append("=======\n");
        sb.append(newText);
        if (!newText.endsWith("\n")) {
            sb.append("\n");
        }
        sb.append(">>>>>>> REPLACE");
        return sb.toString();
    }

    private String unwrapCodeFences(String content) {
        Matcher fenceMatcher = CODE_FENCE_PATTERN.matcher(content);
        StringBuilder result = new StringBuilder();
        int lastEnd = 0;
        while (fenceMatcher.find()) {
            result.append(content.substring(lastEnd, fenceMatcher.start()));
            result.append(fenceMatcher.group(1));
            lastEnd = fenceMatcher.end();
        }
        result.append(content.substring(lastEnd));
        String unwrapped = result.toString();
        return unwrapped.isEmpty() ? content : unwrapped;
    }

    private String normalizeBlockContent(String content) {
        if (content == null) {
            return "";
        }
        String result = content;
        if (result.startsWith("\n")) {
            result = result.substring(1);
        }
        if (result.endsWith("\n")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

