/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.edit;

import com.example.vibe.core.edit.MatchLocation;
import com.example.vibe.core.edit.MatchResult;
import com.example.vibe.core.edit.MatchStrategy;
import com.example.vibe.core.logging.VibeLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class FuzzyMatcher {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(FuzzyMatcher.class);
    private static final double DEFAULT_SIMILARITY_THRESHOLD = 0.75;
    private static final int MAX_CANDIDATES = 5;
    private final double similarityThreshold;

    public FuzzyMatcher() {
        this(0.75);
    }

    public FuzzyMatcher(double similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
    }

    public MatchResult findMatch(String searchText, String documentContent) {
        if (searchText == null || searchText.isEmpty()) {
            return MatchResult.failure("\u041f\u043e\u0438\u0441\u043a\u043e\u0432\u044b\u0439 \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c");
        }
        if (documentContent == null || documentContent.isEmpty()) {
            return MatchResult.failure("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043f\u0443\u0441\u0442");
        }
        LOG.debug("FuzzyMatcher: \u0438\u0449\u0435\u043c \u0442\u0435\u043a\u0441\u0442 \u0434\u043b\u0438\u043d\u043e\u0439 %d \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435 \u0434\u043b\u0438\u043d\u043e\u0439 %d", searchText.length(), documentContent.length());
        MatchStrategy[] matchStrategyArray = MatchStrategy.values();
        int n = matchStrategyArray.length;
        int n2 = 0;
        while (n2 < n) {
            MatchStrategy strategy = matchStrategyArray[n2];
            MatchResult result = this.tryStrategy(searchText, documentContent, strategy);
            if (result.isSuccess()) {
                LOG.debug("FuzzyMatcher: \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u0441\u0442\u0440\u0430\u0442\u0435\u0433\u0438\u0435\u0439 %s", new Object[]{strategy});
                return result;
            }
            ++n2;
        }
        LOG.debug("FuzzyMatcher: \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e, \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c feedback");
        return this.generateFailureFeedback(searchText, documentContent);
    }

    private MatchResult tryStrategy(String searchText, String documentContent, MatchStrategy strategy) {
        return switch (strategy) {
            case MatchStrategy.EXACT -> this.tryExactMatch(searchText, documentContent);
            case MatchStrategy.NORMALIZE_WHITESPACE -> this.tryWhitespaceNormalizedMatch(searchText, documentContent);
            case MatchStrategy.NORMALIZE_INDENTATION -> this.tryIndentationNormalizedMatch(searchText, documentContent);
            case MatchStrategy.SIMILARITY -> this.trySimilarityMatch(searchText, documentContent);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private MatchResult tryExactMatch(String searchText, String documentContent) {
        int index = documentContent.indexOf(searchText);
        if (index >= 0) {
            int secondIndex = documentContent.indexOf(searchText, index + 1);
            if (secondIndex >= 0) {
                List<MatchResult.SimilarMatch> candidates = this.findAllOccurrences(searchText, documentContent);
                return MatchResult.ambiguous(candidates);
            }
            return this.createSuccessResult(index, searchText.length(), documentContent, MatchStrategy.EXACT, 1.0);
        }
        return MatchResult.failure("\u0422\u043e\u0447\u043d\u043e\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e");
    }

    private MatchResult tryWhitespaceNormalizedMatch(String searchText, String documentContent) {
        String normalizedSearch = this.normalizeWhitespace(searchText);
        String normalizedDoc = this.normalizeWhitespace(documentContent);
        int normalizedIndex = normalizedDoc.indexOf(normalizedSearch);
        if (normalizedIndex < 0) {
            return MatchResult.failure("\u0421\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u043e\u0441\u043b\u0435 \u043d\u043e\u0440\u043c\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432");
        }
        int originalStart = this.mapNormalizedToOriginal(documentContent, normalizedDoc, normalizedIndex);
        int originalEnd = this.findOriginalEnd(documentContent, originalStart, searchText, normalizedSearch.length());
        int secondIndex = normalizedDoc.indexOf(normalizedSearch, normalizedIndex + 1);
        if (secondIndex >= 0) {
            ArrayList<MatchResult.SimilarMatch> candidates = new ArrayList<MatchResult.SimilarMatch>();
            candidates.add(this.extractCandidate(documentContent, originalStart, originalEnd));
            int secondOriginalStart = this.mapNormalizedToOriginal(documentContent, normalizedDoc, secondIndex);
            int secondOriginalEnd = this.findOriginalEnd(documentContent, secondOriginalStart, searchText, normalizedSearch.length());
            candidates.add(this.extractCandidate(documentContent, secondOriginalStart, secondOriginalEnd));
            return MatchResult.ambiguous(candidates);
        }
        return this.createSuccessResult(originalStart, originalEnd - originalStart, documentContent, MatchStrategy.NORMALIZE_WHITESPACE, 0.95);
    }

    private MatchResult tryIndentationNormalizedMatch(String searchText, String documentContent) {
        String[] searchLines = searchText.split("\n", -1);
        String[] docLines = documentContent.split("\n", -1);
        String[] strippedSearch = new String[searchLines.length];
        int i = 0;
        while (i < searchLines.length) {
            strippedSearch[i] = searchLines[i].stripLeading();
            ++i;
        }
        int matchStart = -1;
        int matchEnd = -1;
        int docStart = 0;
        while (docStart <= docLines.length - searchLines.length) {
            boolean match = true;
            int i2 = 0;
            while (i2 < searchLines.length) {
                String strippedDoc = docLines[docStart + i2].stripLeading();
                if (!strippedSearch[i2].equals(strippedDoc)) {
                    match = false;
                    break;
                }
                ++i2;
            }
            if (match) {
                if (matchStart >= 0) {
                    return MatchResult.failure("\u041d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0439 \u043f\u043e\u0441\u043b\u0435 \u043d\u043e\u0440\u043c\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043e\u0442\u0441\u0442\u0443\u043f\u043e\u0432. \u0414\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0431\u043e\u043b\u044c\u0448\u0435 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430.");
                }
                matchStart = docStart;
                matchEnd = docStart + searchLines.length;
            }
            ++docStart;
        }
        if (matchStart >= 0) {
            int startOffset = this.getLineOffset(documentContent, matchStart);
            int endOffset = this.getLineEndOffset(documentContent, matchEnd - 1);
            return this.createSuccessResult(startOffset, endOffset - startOffset, documentContent, MatchStrategy.NORMALIZE_INDENTATION, 0.9);
        }
        return MatchResult.failure("\u0421\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u043e\u0441\u043b\u0435 \u043d\u043e\u0440\u043c\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043e\u0442\u0441\u0442\u0443\u043f\u043e\u0432");
    }

    private MatchResult trySimilarityMatch(String searchText, String documentContent) {
        String[] searchLines = searchText.split("\n", -1);
        String[] docLines = documentContent.split("\n", -1);
        if (searchLines.length == 0 || docLines.length == 0) {
            return MatchResult.failure("\u041f\u0443\u0441\u0442\u043e\u0439 \u0442\u0435\u043a\u0441\u0442 \u0434\u043b\u044f \u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u044f");
        }
        double bestSimilarity = 0.0;
        int bestStart = -1;
        int bestEnd = -1;
        ArrayList<MatchResult.SimilarMatch> candidates = new ArrayList<MatchResult.SimilarMatch>();
        int windowSize = searchLines.length;
        int docStart = 0;
        while (docStart <= docLines.length - windowSize) {
            StringBuilder windowBuilder = new StringBuilder();
            int i = 0;
            while (i < windowSize) {
                if (i > 0) {
                    windowBuilder.append("\n");
                }
                windowBuilder.append(docLines[docStart + i]);
                ++i;
            }
            String windowText = windowBuilder.toString();
            double similarity = this.calculateSimilarity(searchText, windowText);
            if (similarity >= this.similarityThreshold) {
                int startOffset = this.getLineOffset(documentContent, docStart);
                int endOffset = this.getLineEndOffset(documentContent, docStart + windowSize - 1);
                String matchedText = documentContent.substring(startOffset, endOffset);
                candidates.add(new MatchResult.SimilarMatch(matchedText, docStart + 1, docStart + windowSize, similarity));
                if (similarity > bestSimilarity) {
                    bestSimilarity = similarity;
                    bestStart = startOffset;
                    bestEnd = endOffset;
                }
            }
            ++docStart;
        }
        if (bestStart >= 0) {
            candidates.sort(Comparator.comparingDouble(MatchResult.SimilarMatch::similarity).reversed());
            if (candidates.size() > 1 && ((MatchResult.SimilarMatch)candidates.get(1)).similarity() > this.similarityThreshold + 0.1) {
                return MatchResult.ambiguous(candidates.subList(0, Math.min(candidates.size(), 5)));
            }
            return this.createSuccessResult(bestStart, bestEnd - bestStart, documentContent, MatchStrategy.SIMILARITY, bestSimilarity);
        }
        return MatchResult.failure("\u041f\u043e\u0445\u043e\u0436\u0438\u0439 \u0442\u0435\u043a\u0441\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d (\u043f\u043e\u0440\u043e\u0433 \u0441\u0445\u043e\u0434\u0441\u0442\u0432\u0430: " + String.format("%.0f%%", this.similarityThreshold * 100.0) + ")");
    }

    private MatchResult generateFailureFeedback(String searchText, String documentContent) {
        List<MatchResult.SimilarMatch> candidates = this.findSimilarCandidates(searchText, documentContent);
        if (candidates.isEmpty()) {
            return MatchResult.failure("\u0422\u0435\u043a\u0441\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0444\u0430\u0439\u043b\u0435. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435, \u0447\u0442\u043e \u0444\u0430\u0439\u043b \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0438\u0441\u043a\u043e\u043c\u044b\u0439 \u0444\u0440\u0430\u0433\u043c\u0435\u043d\u0442.");
        }
        return MatchResult.failure("\u0422\u043e\u0447\u043d\u043e\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e, \u043d\u043e \u0435\u0441\u0442\u044c \u043f\u043e\u0445\u043e\u0436\u0438\u0435 \u0444\u0440\u0430\u0433\u043c\u0435\u043d\u0442\u044b.", candidates);
    }

    private List<MatchResult.SimilarMatch> findSimilarCandidates(String searchText, String documentContent) {
        String[] searchLines = searchText.split("\n", -1);
        String[] docLines = documentContent.split("\n", -1);
        ArrayList<MatchResult.SimilarMatch> candidates = new ArrayList<MatchResult.SimilarMatch>();
        int windowSize = Math.max(1, searchLines.length);
        double candidateThreshold = this.similarityThreshold * 0.5;
        int docStart = 0;
        while (docStart <= docLines.length - windowSize) {
            StringBuilder windowBuilder = new StringBuilder();
            int i = 0;
            while (i < windowSize) {
                if (i > 0) {
                    windowBuilder.append("\n");
                }
                windowBuilder.append(docLines[docStart + i]);
                ++i;
            }
            String windowText = windowBuilder.toString();
            double similarity = this.calculateSimilarity(searchText, windowText);
            if (similarity >= candidateThreshold) {
                candidates.add(new MatchResult.SimilarMatch(windowText, docStart + 1, docStart + windowSize, similarity));
            }
            ++docStart;
        }
        candidates.sort(Comparator.comparingDouble(MatchResult.SimilarMatch::similarity).reversed());
        return candidates.subList(0, Math.min(candidates.size(), 5));
    }

    private List<MatchResult.SimilarMatch> findAllOccurrences(String text, String documentContent) {
        ArrayList<MatchResult.SimilarMatch> occurrences = new ArrayList<MatchResult.SimilarMatch>();
        int index = 0;
        while ((index = documentContent.indexOf(text, index)) >= 0) {
            int startLine = this.countLines(documentContent.substring(0, index)) + 1;
            int endLine = startLine + this.countLines(text);
            occurrences.add(new MatchResult.SimilarMatch(text, startLine, endLine, 1.0));
            index += text.length();
        }
        return occurrences;
    }

    private MatchResult createSuccessResult(int startOffset, int length, String documentContent, MatchStrategy strategy, double similarity) {
        int endOffset = startOffset + length;
        String matchedText = documentContent.substring(startOffset, endOffset);
        int startLine = this.countLines(documentContent.substring(0, startOffset)) + 1;
        int endLine = startLine + this.countLines(matchedText);
        MatchLocation location = new MatchLocation(startOffset, endOffset, startLine, endLine, matchedText);
        return MatchResult.success(location, strategy, similarity);
    }

    private String normalizeWhitespace(String text) {
        String normalized = text.replace("\r\n", "\n").replace("\r", "\n");
        String[] lines = normalized.split("\n", -1);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(lines[i].stripTrailing());
            ++i;
        }
        return sb.toString();
    }

    private int mapNormalizedToOriginal(String original, String normalized, int normalizedIndex) {
        int originalIndex = 0;
        int normalizedPos = 0;
        String normalizedOriginal = this.normalizeWhitespace(original);
        while (normalizedPos < normalizedIndex && originalIndex < original.length()) {
            char normChar;
            char origChar = original.charAt(originalIndex);
            if (normalizedPos < normalizedOriginal.length() && (origChar == (normChar = normalizedOriginal.charAt(normalizedPos)) || origChar == '\r' && normChar == '\n')) {
                ++normalizedPos;
            }
            ++originalIndex;
        }
        return originalIndex;
    }

    private int findOriginalEnd(String documentContent, int originalStart, String searchText, int normalizedLength) {
        String[] searchLines = searchText.split("\n", -1);
        int lineCount = searchLines.length;
        int currentLine = 0;
        int pos = originalStart;
        while (pos < documentContent.length() && currentLine < lineCount) {
            int nextNewline = documentContent.indexOf(10, pos);
            if (nextNewline < 0) {
                pos = documentContent.length();
                break;
            }
            ++currentLine;
            pos = nextNewline + 1;
        }
        if (currentLine < lineCount && pos < documentContent.length()) {
            pos = documentContent.length();
        }
        return Math.min(pos, documentContent.length());
    }

    private MatchResult.SimilarMatch extractCandidate(String documentContent, int start, int end) {
        String text = documentContent.substring(start, end);
        int startLine = this.countLines(documentContent.substring(0, start)) + 1;
        int endLine = startLine + this.countLines(text);
        return new MatchResult.SimilarMatch(text, startLine, endLine, 1.0);
    }

    private int getLineOffset(String text, int lineIndex) {
        if (lineIndex == 0) {
            return 0;
        }
        int line = 0;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\n' && ++line == lineIndex) {
                return i + 1;
            }
            ++i;
        }
        return text.length();
    }

    private int getLineEndOffset(String text, int lineIndex) {
        int line = 0;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\n') {
                if (line == lineIndex) {
                    return i;
                }
                ++line;
            }
            ++i;
        }
        return text.length();
    }

    private int countLines(String text) {
        int count = 0;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\n') {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private double calculateSimilarity(String s1, String s2) {
        if (s1.isEmpty() || s2.isEmpty()) {
            return s1.equals(s2) ? 1.0 : 0.0;
        }
        int lcsLength = this.longestCommonSubsequenceLength(s1, s2);
        int maxLength = Math.max(s1.length(), s2.length());
        return (double)lcsLength / (double)maxLength;
    }

    private int longestCommonSubsequenceLength(String s1, String s2) {
        if (s1.length() > 1000 || s2.length() > 1000) {
            return this.longestCommonSubsequenceLengthByLines(s1, s2);
        }
        int m = s1.length();
        int n = s2.length();
        int[] prev = new int[n + 1];
        int[] curr = new int[n + 1];
        int i = 1;
        while (i <= m) {
            int j = 1;
            while (j <= n) {
                curr[j] = s1.charAt(i - 1) == s2.charAt(j - 1) ? prev[j - 1] + 1 : Math.max(prev[j], curr[j - 1]);
                ++j;
            }
            int[] temp = prev;
            prev = curr;
            curr = temp;
            Arrays.fill(curr, 0);
            ++i;
        }
        return prev[n];
    }

    private int longestCommonSubsequenceLengthByLines(String s1, String s2) {
        String[] lines1 = s1.split("\n", -1);
        String[] lines2 = s2.split("\n", -1);
        int m = lines1.length;
        int n = lines2.length;
        int[] prev = new int[n + 1];
        int[] curr = new int[n + 1];
        int i = 1;
        while (i <= m) {
            int j = 1;
            while (j <= n) {
                curr[j] = lines1[i - 1].equals(lines2[j - 1]) ? prev[j - 1] + 1 : Math.max(prev[j], curr[j - 1]);
                ++j;
            }
            int[] temp = prev;
            prev = curr;
            curr = temp;
            Arrays.fill(curr, 0);
            ++i;
        }
        int matchedLines = prev[n];
        int avgLineLength = (s1.length() + s2.length()) / (m + n + 1);
        return matchedLines * avgLineLength;
    }
}

