/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.edit;

import java.util.Objects;

public final class EditBlock {
    private final String searchText;
    private final String replaceText;
    private final int blockIndex;

    public EditBlock(String searchText, String replaceText, int blockIndex) {
        this.searchText = Objects.requireNonNull(searchText, "searchText must not be null");
        this.replaceText = Objects.requireNonNull(replaceText, "replaceText must not be null");
        this.blockIndex = blockIndex;
    }

    public EditBlock(String searchText, String replaceText) {
        this(searchText, replaceText, 0);
    }

    public String getSearchText() {
        return this.searchText;
    }

    public String getReplaceText() {
        return this.replaceText;
    }

    public int getBlockIndex() {
        return this.blockIndex;
    }

    public boolean isDeletion() {
        return this.replaceText.isEmpty() && !this.searchText.isEmpty();
    }

    public boolean isInsertion() {
        return this.searchText.isEmpty() && !this.replaceText.isEmpty();
    }

    public String getSummary() {
        int searchLines = this.searchText.split("\n", -1).length;
        int replaceLines = this.replaceText.split("\n", -1).length;
        if (this.isDeletion()) {
            return String.format("\u0423\u0434\u0430\u043b\u0438\u0442\u044c %d \u0441\u0442\u0440\u043e\u043a", searchLines);
        }
        if (this.isInsertion()) {
            return String.format("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c %d \u0441\u0442\u0440\u043e\u043a", replaceLines);
        }
        int delta = replaceLines - searchLines;
        if (delta > 0) {
            return String.format("\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c %d \u0441\u0442\u0440\u043e\u043a (+%d)", searchLines, delta);
        }
        if (delta < 0) {
            return String.format("\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c %d \u0441\u0442\u0440\u043e\u043a (%d)", searchLines, delta);
        }
        return String.format("\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c %d \u0441\u0442\u0440\u043e\u043a", searchLines);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditBlock editBlock = (EditBlock)o;
        return this.searchText.equals(editBlock.searchText) && this.replaceText.equals(editBlock.replaceText);
    }

    public int hashCode() {
        return Objects.hash(this.searchText, this.replaceText);
    }

    public String toString() {
        return String.format("EditBlock[search=%d chars, replace=%d chars, idx=%d]", this.searchText.length(), this.replaceText.length(), this.blockIndex);
    }
}

