/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.context;

import com.example.vibe.core.context.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeContextAnalyzer {
    private static final String ID = "[\\p{L}\\p{N}_]+";
    private static final Pattern METHOD_PATTERN = Pattern.compile("(?iu)^\\s*(\u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430|procedure|\u0444\u0443\u043d\u043a\u0446\u0438\u044f|function)\\s+([\\p{L}\\p{N}_]+)\\s*\\(", 8);
    private static final Pattern METHOD_END_PATTERN = Pattern.compile("(?iu)^\\s*(\u043a\u043e\u043d\u0435\u0446\u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b|endprocedure|\u043a\u043e\u043d\u0435\u0446\u0444\u0443\u043d\u043a\u0446\u0438\u0438|endfunction)", 8);
    private static final Pattern QUERY_PATTERN = Pattern.compile("(?iu)(\u0412\u042b\u0411\u0420\u0410\u0422\u042c|SELECT|\u0412\u042b\u0411\u0420\u0410\u0422\u042c\\s+\u0420\u0410\u0417\u041b\u0418\u0427\u041d\u042b\u0415|SELECT\\s+DISTINCT)", 8);
    private static final Pattern QUERY_CONSTRUCTOR_PATTERN = Pattern.compile("(?iu)\u043d\u043e\u0432\u044b\u0439\\s+\u0437\u0430\u043f\u0440\u043e\u0441|new\\s+query", 8);
    private static final Pattern FORM_HANDLER_PATTERN = Pattern.compile("(?iu)&(\u043d\u0430\u043a\u043b\u0438\u0435\u043d\u0442\u0435|\u043d\u0430\u0441\u0435\u0440\u0432\u0435\u0440\u0435|\u043d\u0430\u0441\u0435\u0440\u0432\u0435\u0440\u0435\u0431\u0435\u0437\u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430|atclient|atserver|atservernocontext)", 8);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("(?iu)^\\s*(\u043f\u0435\u0440\u0435\u043c|var)\\s+([\\p{L}\\p{N}_]+)", 8);
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("(?iu)(\u0437\u043d\u0430\u0447|val)?\\s*([\\p{L}\\p{N}_]+)\\s*=", 8);
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^\\s*//.*$", 8);
    private static final Pattern MULTILINE_COMMENT_PATTERN = Pattern.compile("(?s)/\\*.*?\\*/");
    private static final Pattern REGION_PATTERN = Pattern.compile("(?iu)#(\u043e\u0431\u043b\u0430\u0441\u0442\u044c|region)\\s+([\\p{L}\\p{N}_]+)", 8);
    private static final String CMD_EXPLAIN = "com.example.vibe.ui.commands.ExplainCode";
    private static final String CMD_FIX = "com.example.vibe.ui.commands.FixCode";
    private static final String CMD_REVIEW = "com.example.vibe.ui.commands.CriticiseCode";
    private static final String CMD_DOC = "com.example.vibe.ui.commands.GenerateDocComments";
    private static final String CMD_ADD = "com.example.vibe.ui.commands.AddCode";
    private static final String CMD_GENERATE = "com.example.vibe.ui.commands.GenerateCode";
    private static final String CMD_CHAT = "com.example.vibe.ui.commands.OpenChat";
    private static final String CMD_FIND_SIMILAR = "com.example.vibe.ui.commands.FindSimilarCode";
    private static final String CMD_OPTIMIZE_QUERY = "com.example.vibe.ui.commands.OptimizeQuery";

    public AnalysisResult analyze(String selectedText, String fullModuleText, String metadataPath) {
        if (selectedText == null || selectedText.trim().isEmpty()) {
            return AnalysisResult.builder().type(CodeType.NONE).suggestedActions(this.getDefaultActions()).build();
        }
        String text = selectedText.trim();
        AnalysisResult.Builder builder = AnalysisResult.builder().selectedText(text).metadataPath(metadataPath != null ? metadataPath : "");
        boolean hasQuery = this.containsQuery(text);
        builder.hasQuery(hasQuery);
        CodeType type = this.detectCodeType(text);
        builder.type(type);
        String symbolName = this.extractSymbolName(text, type);
        builder.symbolName(symbolName);
        if (type == CodeType.METHOD || type == CodeType.FORM_HANDLER) {
            builder.isExportMethod(text.toLowerCase().contains("\u044d\u043a\u0441\u043f\u043e\u0440\u0442") || text.toLowerCase().contains("export"));
        }
        List<SuggestedAction> actions = this.buildSuggestedActions(type, hasQuery, symbolName);
        builder.suggestedActions(actions);
        return builder.build();
    }

    private CodeType detectCodeType(String text) {
        if (METHOD_PATTERN.matcher(text).find()) {
            if (FORM_HANDLER_PATTERN.matcher(text).find()) {
                return CodeType.FORM_HANDLER;
            }
            return CodeType.METHOD;
        }
        if (this.isStandaloneQuery(text)) {
            return CodeType.QUERY;
        }
        if (VARIABLE_PATTERN.matcher(text).find()) {
            return CodeType.VARIABLE;
        }
        if (this.isCommentOnly(text)) {
            return CodeType.COMMENT;
        }
        if (REGION_PATTERN.matcher(text).find()) {
            return CodeType.REGION;
        }
        int lineCount = text.split("\n").length;
        if (lineCount > 50) {
            return CodeType.MODULE;
        }
        return CodeType.CODE_BLOCK;
    }

    private boolean containsQuery(String text) {
        return QUERY_PATTERN.matcher(text).find() || QUERY_CONSTRUCTOR_PATTERN.matcher(text).find();
    }

    private boolean isStandaloneQuery(String text) {
        String trimmed = text.trim();
        if (trimmed.startsWith("\"") || trimmed.startsWith("'")) {
            trimmed = trimmed.substring(1);
        }
        return trimmed.toUpperCase().startsWith("\u0412\u042b\u0411\u0420\u0410\u0422\u042c") || trimmed.toUpperCase().startsWith("SELECT");
    }

    private boolean isCommentOnly(String text) {
        String[] lines;
        String withoutMultiline = MULTILINE_COMMENT_PATTERN.matcher(text).replaceAll("");
        String[] stringArray = lines = withoutMultiline.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String trimmed = line.trim();
            if (!trimmed.isEmpty() && !trimmed.startsWith("//")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private String extractSymbolName(String text, CodeType type) {
        switch (type) {
            case METHOD: 
            case FORM_HANDLER: {
                Matcher methodMatcher = METHOD_PATTERN.matcher(text);
                if (!methodMatcher.find()) break;
                return methodMatcher.group(2);
            }
            case VARIABLE: {
                Matcher varMatcher = VARIABLE_PATTERN.matcher(text);
                if (!varMatcher.find()) break;
                return varMatcher.group(2);
            }
            case REGION: {
                Matcher regionMatcher = REGION_PATTERN.matcher(text);
                if (!regionMatcher.find()) break;
                return regionMatcher.group(2);
            }
        }
        return "";
    }

    private List<SuggestedAction> buildSuggestedActions(CodeType type, boolean hasQuery, String symbolName) {
        ArrayList<SuggestedAction> actions = new ArrayList<SuggestedAction>();
        actions.add(new SuggestedAction("explain", this.getExplainLabel(type, symbolName), CMD_EXPLAIN, ActionCategory.QUICK_ACTION, 10));
        if (hasQuery || type == CodeType.QUERY) {
            actions.add(new SuggestedAction("optimizeQuery", Messages.Action_OptimizeQuery, CMD_OPTIMIZE_QUERY, ActionCategory.QUICK_ACTION, 15));
        }
        actions.add(new SuggestedAction("findSimilar", Messages.Action_FindSimilar, CMD_FIND_SIMILAR, ActionCategory.QUICK_ACTION, 20));
        actions.add(new SuggestedAction("review", Messages.Action_Review, CMD_REVIEW, ActionCategory.EDIT_ACTION, 30));
        actions.add(new SuggestedAction("fix", Messages.Action_Fix, CMD_FIX, ActionCategory.EDIT_ACTION, 40));
        if (type == CodeType.METHOD || type == CodeType.FORM_HANDLER) {
            actions.add(new SuggestedAction("doc", Messages.Action_GenerateDoc, CMD_DOC, ActionCategory.EDIT_ACTION, 50));
        }
        actions.add(new SuggestedAction("addCode", Messages.Action_AddCode, CMD_ADD, ActionCategory.EDIT_ACTION, 60));
        actions.add(new SuggestedAction("chat", Messages.Action_OpenChat, CMD_CHAT, ActionCategory.CHAT_ACTION, 100));
        return actions;
    }

    private String getExplainLabel(CodeType type, String symbolName) {
        switch (type) {
            case METHOD: 
            case FORM_HANDLER: {
                if (!symbolName.isEmpty()) {
                    return String.format(Messages.Action_ExplainMethod, symbolName);
                }
                return Messages.Action_ExplainCode;
            }
            case QUERY: {
                return Messages.Action_ExplainQuery;
            }
            case VARIABLE: {
                return Messages.Action_ExplainVariable;
            }
        }
        return Messages.Action_ExplainCode;
    }

    private List<SuggestedAction> getDefaultActions() {
        ArrayList<SuggestedAction> actions = new ArrayList<SuggestedAction>();
        actions.add(new SuggestedAction("generate", Messages.Action_GenerateCode, CMD_GENERATE, ActionCategory.EDIT_ACTION, 10));
        actions.add(new SuggestedAction("chat", Messages.Action_OpenChat, CMD_CHAT, ActionCategory.CHAT_ACTION, 100));
        return actions;
    }

    public static enum ActionCategory {
        QUICK_ACTION,
        EDIT_ACTION,
        CHAT_ACTION,
        SETTINGS;

    }

    public static class AnalysisResult {
        private final CodeType type;
        private final String symbolName;
        private final String metadataPath;
        private final List<SuggestedAction> suggestedActions;
        private final String selectedText;
        private final boolean hasQuery;
        private final boolean isExportMethod;

        private AnalysisResult(Builder builder) {
            this.type = builder.type;
            this.symbolName = builder.symbolName;
            this.metadataPath = builder.metadataPath;
            this.suggestedActions = Collections.unmodifiableList(builder.suggestedActions);
            this.selectedText = builder.selectedText;
            this.hasQuery = builder.hasQuery;
            this.isExportMethod = builder.isExportMethod;
        }

        public CodeType getType() {
            return this.type;
        }

        public String getSymbolName() {
            return this.symbolName;
        }

        public String getMetadataPath() {
            return this.metadataPath;
        }

        public List<SuggestedAction> getSuggestedActions() {
            return this.suggestedActions;
        }

        public String getSelectedText() {
            return this.selectedText;
        }

        public boolean hasQuery() {
            return this.hasQuery;
        }

        public boolean isExportMethod() {
            return this.isExportMethod;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private CodeType type = CodeType.NONE;
            private String symbolName = "";
            private String metadataPath = "";
            private List<SuggestedAction> suggestedActions = new ArrayList<SuggestedAction>();
            private String selectedText = "";
            private boolean hasQuery = false;
            private boolean isExportMethod = false;

            public Builder type(CodeType type) {
                this.type = type;
                return this;
            }

            public Builder symbolName(String symbolName) {
                this.symbolName = symbolName;
                return this;
            }

            public Builder metadataPath(String metadataPath) {
                this.metadataPath = metadataPath;
                return this;
            }

            public Builder suggestedActions(List<SuggestedAction> actions) {
                this.suggestedActions = new ArrayList<SuggestedAction>(actions);
                return this;
            }

            public Builder addSuggestedAction(SuggestedAction action) {
                this.suggestedActions.add(action);
                return this;
            }

            public Builder selectedText(String text) {
                this.selectedText = text;
                return this;
            }

            public Builder hasQuery(boolean hasQuery) {
                this.hasQuery = hasQuery;
                return this;
            }

            public Builder isExportMethod(boolean isExport) {
                this.isExportMethod = isExport;
                return this;
            }

            public AnalysisResult build() {
                return new AnalysisResult(this);
            }
        }
    }

    public static enum CodeType {
        METHOD,
        QUERY,
        FORM_HANDLER,
        VARIABLE,
        COMMENT,
        REGION,
        MODULE,
        CODE_BLOCK,
        NONE;

    }

    public static class SuggestedAction {
        private final String id;
        private final String label;
        private final String commandId;
        private final ActionCategory category;
        private final int priority;

        public SuggestedAction(String id, String label, String commandId, ActionCategory category, int priority) {
            this.id = id;
            this.label = label;
            this.commandId = commandId;
            this.category = category;
            this.priority = priority;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String getCommandId() {
            return this.commandId;
        }

        public ActionCategory getCategory() {
            return this.category;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

