/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.backend;

public class RegistrationResult {
    private boolean success;
    private String apiKey;
    private String userId;
    private String email;
    private String error;
    private String errorCode;
    private long retryAfterSeconds;
    private double maxBudget;

    public static RegistrationResult success(String apiKey, String userId, double maxBudget) {
        return RegistrationResult.success(apiKey, userId, null, maxBudget);
    }

    public static RegistrationResult success(String apiKey, String userId, String email, double maxBudget) {
        RegistrationResult result = new RegistrationResult();
        result.success = true;
        result.apiKey = apiKey;
        result.userId = userId;
        result.email = email;
        result.maxBudget = maxBudget;
        return result;
    }

    public static RegistrationResult failure(String error) {
        return RegistrationResult.failure(error, null, 0L);
    }

    public static RegistrationResult failure(String error, String errorCode, long retryAfterSeconds) {
        RegistrationResult result = new RegistrationResult();
        result.success = false;
        result.error = error;
        result.errorCode = errorCode;
        result.retryAfterSeconds = retryAfterSeconds;
        return result;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public long getRetryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    public void setRetryAfterSeconds(long retryAfterSeconds) {
        this.retryAfterSeconds = retryAfterSeconds;
    }

    public double getMaxBudget() {
        return this.maxBudget;
    }

    public void setMaxBudget(double maxBudget) {
        this.maxBudget = maxBudget;
    }

    public String toString() {
        if (this.success) {
            return String.format("RegistrationResult[success, userId=%s, email=%s, budget=%.2f]", this.userId, this.email, this.maxBudget);
        }
        return String.format("RegistrationResult[failure, code=%s, error=%s]", this.errorCode, this.error);
    }
}

