/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.core.agent.profiles;

import com.example.vibe.core.agent.AgentConfig;
import com.example.vibe.core.agent.profiles.AgentProfile;
import com.example.vibe.core.agent.profiles.BuildAgentProfile;
import com.example.vibe.core.agent.profiles.ExploreAgentProfile;
import com.example.vibe.core.agent.profiles.PlanAgentProfile;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class AgentProfileRegistry {
    private static AgentProfileRegistry instance;
    private final Map<String, AgentProfile> profiles = new LinkedHashMap<String, AgentProfile>();
    private String defaultProfileId = "build";

    public static synchronized AgentProfileRegistry getInstance() {
        if (instance == null) {
            instance = new AgentProfileRegistry();
            instance.registerDefaultProfiles();
        }
        return instance;
    }

    private void registerDefaultProfiles() {
        this.register(new BuildAgentProfile());
        this.register(new PlanAgentProfile());
        this.register(new ExploreAgentProfile());
    }

    public void register(AgentProfile profile) {
        if (profile != null) {
            this.profiles.put(profile.getId(), profile);
        }
    }

    public boolean unregister(String profileId) {
        return this.profiles.remove(profileId) != null;
    }

    public Optional<AgentProfile> getProfile(String profileId) {
        return Optional.ofNullable(this.profiles.get(profileId));
    }

    public Collection<AgentProfile> getAllProfiles() {
        return Collections.unmodifiableCollection(this.profiles.values());
    }

    public AgentProfile getDefaultProfile() {
        return this.profiles.getOrDefault(this.defaultProfileId, new BuildAgentProfile());
    }

    public void setDefaultProfileId(String profileId) {
        if (this.profiles.containsKey(profileId)) {
            this.defaultProfileId = profileId;
        }
    }

    public AgentConfig createConfig(AgentProfile profile) {
        AgentConfig.Builder builder = AgentConfig.builder().maxSteps(profile.getMaxSteps()).timeoutMs(profile.getTimeoutMs()).systemPromptAddition(profile.getSystemPromptAddition()).profileName(profile.getId());
        for (String tool : profile.getAllowedTools()) {
            builder.enableTool(tool);
        }
        return builder.build();
    }

    public AgentConfig createConfig(String profileId) {
        AgentProfile profile = this.getProfile(profileId).orElse(this.getDefaultProfile());
        return this.createConfig(profile);
    }

    public AgentProfile getBuildProfile() {
        return this.profiles.get("build");
    }

    public AgentProfile getPlanProfile() {
        return this.profiles.get("plan");
    }

    public AgentProfile getExploreProfile() {
        return this.profiles.get("explore");
    }
}

