/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.bsl.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BslMethodParser {
    private static final Pattern METHOD_START_PATTERN = Pattern.compile("^\\s*(\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430|Procedure|\u0424\u0443\u043d\u043a\u0446\u0438\u044f|Function)\\s+([\\w\u0410-\u042f\u0430-\u044f\u0401\u0451]+)\\s*\\(", 2);
    private static final Pattern METHOD_END_PATTERN = Pattern.compile("^\\s*(\u041a\u043e\u043d\u0435\u0446\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b|EndProcedure|\u041a\u043e\u043d\u0435\u0446\u0424\u0443\u043d\u043a\u0446\u0438\u0438|EndFunction)", 2);
    private static final Pattern DIRECTIVE_PATTERN = Pattern.compile("^\\s*&(\u041d\u0430\u041a\u043b\u0438\u0435\u043d\u0442\u0435|\u041d\u0430\u0421\u0435\u0440\u0432\u0435\u0440\u0435|\u041d\u0430\u0421\u0435\u0440\u0432\u0435\u0440\u0435\u0411\u0435\u0437\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430|\u041d\u0430\u041a\u043b\u0438\u0435\u043d\u0442\u0435\u041d\u0430\u0421\u0435\u0440\u0432\u0435\u0440\u0435\u0411\u0435\u0437\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430|\u041d\u0430\u041a\u043b\u0438\u0435\u043d\u0442\u0435\u041d\u0430\u0421\u0435\u0440\u0432\u0435\u0440\u0435|\u0412\u043c\u0435\u0441\u0442\u043e|\u041f\u0435\u0440\u0435\u0434|\u041f\u043e\u0441\u043b\u0435|AtClient|AtServer|AtServerNoContext|AtClientAtServerNoContext|AtClientAtServer|Instead|Before|After)", 2);
    private static final Pattern MODULE_VAR_PATTERN = Pattern.compile("^\\s*\u041f\u0435\u0440\u0435\u043c\\s+([\\w\u0410-\u042f\u0430-\u044f\u0401\u0451]+)|^\\s*Var\\s+([\\w\u0410-\u042f\u0430-\u044f\u0401\u0451]+)", 2);
    private static final Pattern REGION_PATTERN = Pattern.compile("^\\s*#(\u041e\u0431\u043b\u0430\u0441\u0442\u044c|Region)\\s+(.+)", 2);
    private static final Pattern METHOD_CALL_PATTERN = Pattern.compile("([\\w\u0410-\u042f\u0430-\u044f\u0401\u0451]+)\\s*\\(", 2);

    public ModuleContext getModuleContext(String content, int cursorLine) {
        String[] lines = content.split("\n", -1);
        ArrayList<String> moduleVars = new ArrayList<String>();
        StringBuilder headerBuilder = new StringBuilder();
        int firstMethodLine = this.findFirstMethodLine(lines);
        int i = 0;
        while (i < Math.min(firstMethodLine, lines.length)) {
            String line = lines[i];
            headerBuilder.append(line).append("\n");
            Matcher varMatcher = MODULE_VAR_PATTERN.matcher(line);
            if (varMatcher.find()) {
                String varName = varMatcher.group(1) != null ? varMatcher.group(1) : varMatcher.group(2);
                moduleVars.add(varName);
            }
            ++i;
        }
        MethodContext enclosingMethod = this.findEnclosingMethod(lines, cursorLine);
        String surroundingCode = null;
        if (enclosingMethod == null) {
            surroundingCode = this.extractSurroundingCode(lines, cursorLine, 30);
        }
        return new ModuleContext(moduleVars, headerBuilder.toString().trim(), enclosingMethod, surroundingCode);
    }

    public MethodContext findEnclosingMethod(String content, int cursorLine) {
        String[] lines = content.split("\n", -1);
        return this.findEnclosingMethod(lines, cursorLine);
    }

    private MethodContext findEnclosingMethod(String[] lines, int cursorLine) {
        if (cursorLine < 0 || cursorLine >= lines.length) {
            return null;
        }
        int methodStartLine = -1;
        String methodName = null;
        String methodType = null;
        String directive = null;
        int directiveLine = -1;
        int i = cursorLine;
        block0: while (i >= 0) {
            String line = lines[i];
            if (METHOD_END_PATTERN.matcher(line).find()) {
                return null;
            }
            Matcher startMatcher = METHOD_START_PATTERN.matcher(line);
            if (startMatcher.find()) {
                methodStartLine = i;
                methodType = startMatcher.group(1);
                methodName = startMatcher.group(2);
                int j = i - 1;
                while (j >= Math.max(0, i - 3)) {
                    Matcher dirMatcher = DIRECTIVE_PATTERN.matcher(lines[j]);
                    if (dirMatcher.find()) {
                        directive = dirMatcher.group(1);
                        directiveLine = j;
                        break block0;
                    }
                    if (!lines[j].trim().isEmpty() && !lines[j].trim().startsWith("//")) break block0;
                    --j;
                }
                break;
            }
            --i;
        }
        if (methodStartLine == -1) {
            return null;
        }
        int methodEndLine = this.findMethodEndLine(lines, methodStartLine);
        if (cursorLine > methodEndLine) {
            return null;
        }
        String params = this.extractParams(lines, methodStartLine);
        boolean isExport = this.checkIsExport(lines, methodStartLine);
        String region = this.findRegionForLine(lines, methodStartLine);
        int textStartLine = directiveLine >= 0 ? directiveLine : methodStartLine;
        StringBuilder fullText = new StringBuilder();
        int i2 = textStartLine;
        while (i2 <= methodEndLine && i2 < lines.length) {
            fullText.append(lines[i2]);
            if (i2 < methodEndLine) {
                fullText.append("\n");
            }
            ++i2;
        }
        return new MethodContext(methodName, this.normalizeType(methodType), directive, params, isExport, textStartLine, methodEndLine, fullText.toString(), region);
    }

    private int findMethodEndLine(String[] lines, int startLine) {
        int depth = 1;
        int i = startLine + 1;
        while (i < lines.length) {
            String line = lines[i].trim().toLowerCase();
            if (line.startsWith("\u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430 ") || line.startsWith("procedure ") || line.startsWith("\u0444\u0443\u043d\u043a\u0446\u0438\u044f ") || line.startsWith("function ")) {
                ++depth;
            } else if ((line.startsWith("\u043a\u043e\u043d\u0435\u0446\u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b") || line.startsWith("endprocedure") || line.startsWith("\u043a\u043e\u043d\u0435\u0446\u0444\u0443\u043d\u043a\u0446\u0438\u0438") || line.startsWith("endfunction")) && --depth == 0) {
                return i;
            }
            ++i;
        }
        return lines.length - 1;
    }

    private int findFirstMethodLine(String[] lines) {
        int i = 0;
        while (i < lines.length) {
            if (METHOD_START_PATTERN.matcher(lines[i]).find()) {
                return i;
            }
            ++i;
        }
        return lines.length;
    }

    private String extractParams(String[] lines, int methodLine) {
        StringBuilder signature = new StringBuilder();
        int i = methodLine;
        while (i < Math.min(methodLine + 20, lines.length)) {
            signature.append(lines[i]);
            if (lines[i].contains(")")) break;
            signature.append(" ");
            ++i;
        }
        String sig = signature.toString();
        int start = sig.indexOf(40);
        int end = sig.indexOf(41);
        if (start >= 0 && end > start) {
            return sig.substring(start + 1, end).trim();
        }
        return "";
    }

    private boolean checkIsExport(String[] lines, int methodLine) {
        int i = methodLine;
        while (i < Math.min(methodLine + 20, lines.length)) {
            String lower = lines[i].toLowerCase();
            if (lower.contains("\u044d\u043a\u0441\u043f\u043e\u0440\u0442") || lower.contains("export")) {
                return true;
            }
            if (lines[i].contains(")")) break;
            ++i;
        }
        return false;
    }

    private String findRegionForLine(String[] lines, int line) {
        int i = line - 1;
        while (i >= 0) {
            Matcher regionMatcher = REGION_PATTERN.matcher(lines[i]);
            if (regionMatcher.find()) {
                return regionMatcher.group(2).trim();
            }
            if (lines[i].trim().toLowerCase().startsWith("#\u043a\u043e\u043d\u0435\u0446\u043e\u0431\u043b\u0430\u0441\u0442\u0438") || lines[i].trim().toLowerCase().startsWith("#endregion")) break;
            --i;
        }
        return null;
    }

    private String extractSurroundingCode(String[] lines, int cursorLine, int contextLines) {
        int start = Math.max(0, cursorLine - contextLines);
        int end = Math.min(lines.length - 1, cursorLine + contextLines);
        StringBuilder sb = new StringBuilder();
        int i = start;
        while (i <= end) {
            sb.append(lines[i]);
            if (i < end) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    private String normalizeType(String type) {
        if (type == null) {
            return "";
        }
        String lower = type.toLowerCase();
        if (lower.equals("procedure") || lower.equals("\u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430")) {
            return "\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430";
        }
        if (lower.equals("function") || lower.equals("\u0444\u0443\u043d\u043a\u0446\u0438\u044f")) {
            return "\u0424\u0443\u043d\u043a\u0446\u0438\u044f";
        }
        return type;
    }

    public Set<String> extractCalledMethods(String code) {
        HashSet<String> methods = new HashSet<String>();
        if (code == null || code.isEmpty()) {
            return methods;
        }
        Matcher matcher = METHOD_CALL_PATTERN.matcher(code);
        while (matcher.find()) {
            String name = matcher.group(1);
            if (this.isKeyword(name)) continue;
            methods.add(name);
        }
        return methods;
    }

    public List<MethodContext> findMethodDefinitions(String content, Set<String> methodNames) {
        ArrayList<MethodContext> definitions = new ArrayList<MethodContext>();
        if (content == null || methodNames == null || methodNames.isEmpty()) {
            return definitions;
        }
        String[] lines = content.split("\n", -1);
        for (String methodName : methodNames) {
            MethodContext def = this.findMethodByName(lines, methodName);
            if (def == null) continue;
            definitions.add(def);
        }
        return definitions;
    }

    private MethodContext findMethodByName(String[] lines, String methodName) {
        String lowerName = methodName.toLowerCase();
        int i = 0;
        while (i < lines.length) {
            String foundName;
            Matcher startMatcher = METHOD_START_PATTERN.matcher(lines[i]);
            if (startMatcher.find() && (foundName = startMatcher.group(2)).toLowerCase().equals(lowerName)) {
                String methodType = startMatcher.group(1);
                int endLine = this.findMethodEndLine(lines, i);
                String directive = null;
                int directiveLine = -1;
                int j = i - 1;
                while (j >= Math.max(0, i - 3)) {
                    Matcher dirMatcher = DIRECTIVE_PATTERN.matcher(lines[j]);
                    if (dirMatcher.find()) {
                        directive = dirMatcher.group(1);
                        directiveLine = j;
                        break;
                    }
                    if (!lines[j].trim().isEmpty() && !lines[j].trim().startsWith("//")) break;
                    --j;
                }
                String params = this.extractParams(lines, i);
                boolean isExport = this.checkIsExport(lines, i);
                String region = this.findRegionForLine(lines, i);
                int textStartLine = directiveLine >= 0 ? directiveLine : i;
                StringBuilder fullText = new StringBuilder();
                int k = textStartLine;
                while (k <= endLine && k < lines.length) {
                    fullText.append(lines[k]);
                    if (k < endLine) {
                        fullText.append("\n");
                    }
                    ++k;
                }
                return new MethodContext(foundName, this.normalizeType(methodType), directive, params, isExport, textStartLine, endLine, fullText.toString(), region);
            }
            ++i;
        }
        return null;
    }

    private boolean isKeyword(String word) {
        if (word == null) {
            return true;
        }
        String lower = word.toLowerCase();
        return lower.equals("\u0435\u0441\u043b\u0438") || lower.equals("if") || lower.equals("\u0442\u043e\u0433\u0434\u0430") || lower.equals("then") || lower.equals("\u0438\u043d\u0430\u0447\u0435") || lower.equals("else") || lower.equals("\u0438\u043d\u0430\u0447\u0435\u0435\u0441\u043b\u0438") || lower.equals("elsif") || lower.equals("\u043a\u043e\u043d\u0435\u0446\u0435\u0441\u043b\u0438") || lower.equals("endif") || lower.equals("\u0434\u043b\u044f") || lower.equals("for") || lower.equals("\u043a\u0430\u0436\u0434\u043e\u0433\u043e") || lower.equals("each") || lower.equals("\u0438\u0437") || lower.equals("in") || lower.equals("\u043f\u043e") || lower.equals("to") || lower.equals("\u0446\u0438\u043a\u043b") || lower.equals("do") || lower.equals("\u043a\u043e\u043d\u0435\u0446\u0446\u0438\u043a\u043b\u0430") || lower.equals("enddo") || lower.equals("\u043f\u043e\u043a\u0430") || lower.equals("while") || lower.equals("\u043f\u043e\u043f\u044b\u0442\u043a\u0430") || lower.equals("try") || lower.equals("\u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435") || lower.equals("except") || lower.equals("\u043a\u043e\u043d\u0435\u0446\u043f\u043e\u043f\u044b\u0442\u043a\u0438") || lower.equals("endtry") || lower.equals("\u0432\u043e\u0437\u0432\u0440\u0430\u0442") || lower.equals("return") || lower.equals("\u043d\u043e\u0432\u044b\u0439") || lower.equals("new") || lower.equals("\u043f\u0435\u0440\u0435\u043c") || lower.equals("var") || lower.equals("\u043d\u0435") || lower.equals("not") || lower.equals("\u0438") || lower.equals("and") || lower.equals("\u0438\u043b\u0438") || lower.equals("or") || lower.equals("\u0438\u0441\u0442\u0438\u043d\u0430") || lower.equals("true") || lower.equals("\u043b\u043e\u0436\u044c") || lower.equals("false") || lower.equals("\u043d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e") || lower.equals("undefined") || lower.equals("null") || lower.equals("\u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430") || lower.equals("procedure") || lower.equals("\u0444\u0443\u043d\u043a\u0446\u0438\u044f") || lower.equals("function") || lower.equals("\u043a\u043e\u043d\u0435\u0446\u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b") || lower.equals("endprocedure") || lower.equals("\u043a\u043e\u043d\u0435\u0446\u0444\u0443\u043d\u043a\u0446\u0438\u0438") || lower.equals("endfunction");
    }

    public static class MethodContext {
        public final String name;
        public final String type;
        public final String directive;
        public final String params;
        public final boolean isExport;
        public final int startLine;
        public final int endLine;
        public final String fullText;
        public final String region;

        public MethodContext(String name, String type, String directive, String params, boolean isExport, int startLine, int endLine, String fullText, String region) {
            this.name = name;
            this.type = type;
            this.directive = directive;
            this.params = params;
            this.isExport = isExport;
            this.startLine = startLine;
            this.endLine = endLine;
            this.fullText = fullText;
            this.region = region;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.directive != null) {
                sb.append("&").append(this.directive).append(" ");
            }
            sb.append(this.type).append(" ").append(this.name);
            if (this.isExport) {
                sb.append(" \u042d\u043a\u0441\u043f\u043e\u0440\u0442");
            }
            return sb.toString();
        }
    }

    public static class ModuleContext {
        public final List<String> moduleVariables;
        public final String moduleHeader;
        public final MethodContext enclosingMethod;
        public final String surroundingCode;

        public ModuleContext(List<String> moduleVariables, String moduleHeader, MethodContext enclosingMethod, String surroundingCode) {
            this.moduleVariables = moduleVariables;
            this.moduleHeader = moduleHeader;
            this.enclosingMethod = enclosingMethod;
            this.surroundingCode = surroundingCode;
        }

        public boolean isInsideMethod() {
            return this.enclosingMethod != null;
        }
    }
}

