/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.bsl.context;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IDocument;

public class LocalScopeExtractor {
    private static final Pattern METHOD_START = Pattern.compile("^\\s*(\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430|\u0424\u0443\u043d\u043a\u0446\u0438\u044f|Procedure|Function)\\s+(\\w+)\\s*\\(([^)]*)\\)", 10);
    private static final Pattern METHOD_END = Pattern.compile("^\\s*(\u041a\u043e\u043d\u0435\u0446\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b|\u041a\u043e\u043d\u0435\u0446\u0424\u0443\u043d\u043a\u0446\u0438\u0438|EndProcedure|EndFunction)", 10);
    private static final Pattern VAR_DECLARATION = Pattern.compile("^\\s*(\u041f\u0435\u0440\u0435\u043c|Var)\\s+(\\w+)", 10);
    private static final Pattern ASSIGNMENT = Pattern.compile("^\\s*(\\w+)\\s*=\\s*", 8);
    private static final Pattern EXPORT_MARKER = Pattern.compile("\\s+\u042d\u043a\u0441\u043f\u043e\u0440\u0442\\s*$|\\s+Export\\s*$", 2);

    public LocalContext extract(IDocument document, int offset) {
        try {
            String content = document.get();
            return this.extractFromContent(content, offset);
        }
        catch (Exception exception) {
            return LocalContext.empty();
        }
    }

    public LocalContext extractFromContent(String content, int offset) {
        LocalContext.Builder builder = LocalContext.builder();
        MethodBounds bounds = this.findMethodBounds(content, offset);
        if (bounds != null) {
            String methodText = content.substring(bounds.start, bounds.end);
            String signature = this.extractMethodSignature(methodText);
            builder.currentMethodSignature(signature);
            int cursorInMethod = offset - bounds.start;
            String bodyAroundCursor = this.extractBodyAroundCursor(methodText, cursorInMethod, 1500);
            builder.currentMethodBody(bodyAroundCursor);
            builder.cursorOffsetInMethod(cursorInMethod);
            List<String> localVars = this.extractLocalVariables(methodText);
            builder.localVariables(localVars);
            List<String> params = this.extractParameters(signature);
            builder.parameters(params);
        } else {
            String surroundingCode = this.extractSurroundingCode(content, offset, 2000);
            builder.currentMethodBody(surroundingCode);
            builder.cursorOffsetInMethod(Math.min(offset, 1000));
        }
        List<String> moduleVars = this.extractModuleVariables(content);
        builder.moduleVariables(moduleVars);
        List<String> otherMethods = this.extractMethodSignatures(content, offset);
        builder.otherMethodSignatures(otherMethods);
        return builder.build();
    }

    private MethodBounds findMethodBounds(String content, int offset) {
        Matcher startMatcher = METHOD_START.matcher(content);
        Matcher endMatcher = METHOD_END.matcher(content);
        int methodStart = -1;
        int methodEnd = -1;
        while (startMatcher.find()) {
            if (startMatcher.start() > offset) break;
            methodStart = startMatcher.start();
        }
        if (methodStart < 0) {
            return null;
        }
        endMatcher.region(methodStart, content.length());
        while (endMatcher.find()) {
            methodEnd = endMatcher.end();
            if (methodEnd >= offset) break;
        }
        if (methodEnd < 0 || methodEnd < offset) {
            methodEnd = content.length();
        }
        return new MethodBounds(methodStart, methodEnd);
    }

    private String extractMethodSignature(String methodText) {
        Matcher matcher = METHOD_START.matcher(methodText);
        if (matcher.find()) {
            String firstLine;
            String fullMatch = matcher.group(0);
            int lineEnd = methodText.indexOf(10);
            if (lineEnd > 0 && EXPORT_MARKER.matcher(firstLine = methodText.substring(0, lineEnd)).find()) {
                fullMatch = firstLine.trim();
            }
            return fullMatch;
        }
        return "";
    }

    private String extractBodyAroundCursor(String methodText, int cursorPos, int maxChars) {
        int lineEnd;
        int lineStart;
        if (methodText.length() <= maxChars) {
            return methodText;
        }
        int halfWindow = maxChars / 2;
        int start = Math.max(0, cursorPos - halfWindow);
        int end = Math.min(methodText.length(), cursorPos + halfWindow);
        if (start > 0 && (lineStart = methodText.lastIndexOf(10, start)) > 0) {
            start = lineStart + 1;
        }
        if (end < methodText.length() && (lineEnd = methodText.indexOf(10, end)) > 0) {
            end = lineEnd;
        }
        Object result = methodText.substring(start, end);
        if (start > 0) {
            result = "// ... (\u043a\u043e\u0434 \u0432\u044b\u0448\u0435 \u043f\u0440\u043e\u043f\u0443\u0449\u0435\u043d)\n" + (String)result;
        }
        if (end < methodText.length()) {
            result = (String)result + "\n// ... (\u043a\u043e\u0434 \u043d\u0438\u0436\u0435 \u043f\u0440\u043e\u043f\u0443\u0449\u0435\u043d)";
        }
        return result;
    }

    private List<String> extractLocalVariables(String methodText) {
        ArrayList<String> vars = new ArrayList<String>();
        Matcher varMatcher = VAR_DECLARATION.matcher(methodText);
        while (varMatcher.find()) {
            vars.add(varMatcher.group(2));
        }
        Matcher assignMatcher = ASSIGNMENT.matcher(methodText);
        while (assignMatcher.find()) {
            String varName = assignMatcher.group(1);
            if (varName.contains(".") || vars.contains(varName)) continue;
            vars.add(varName);
        }
        return vars;
    }

    private List<String> extractParameters(String signature) {
        String paramsStr;
        ArrayList<String> params = new ArrayList<String>();
        int parenStart = signature.indexOf(40);
        int parenEnd = signature.indexOf(41);
        if (parenStart >= 0 && parenEnd > parenStart && !(paramsStr = signature.substring(parenStart + 1, parenEnd)).trim().isEmpty()) {
            String[] parts;
            String[] stringArray = parts = paramsStr.split(",");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                String param = part.trim();
                int eqIdx = (param = param.replaceFirst("(?i)^(\u0417\u043d\u0430\u0447|Val)\\s+", "")).indexOf(61);
                if (eqIdx > 0) {
                    param = param.substring(0, eqIdx).trim();
                }
                if (!param.isEmpty()) {
                    params.add(param);
                }
                ++n2;
            }
        }
        return params;
    }

    private List<String> extractModuleVariables(String content) {
        ArrayList<String> vars = new ArrayList<String>();
        Matcher methodMatcher = METHOD_START.matcher(content);
        int firstMethodStart = methodMatcher.find() ? methodMatcher.start() : content.length();
        String moduleHeader = content.substring(0, firstMethodStart);
        Matcher varMatcher = VAR_DECLARATION.matcher(moduleHeader);
        while (varMatcher.find()) {
            vars.add(varMatcher.group(2));
        }
        return vars;
    }

    private List<String> extractMethodSignatures(String content, int excludeOffset) {
        ArrayList<String> signatures = new ArrayList<String>();
        Matcher matcher = METHOD_START.matcher(content);
        while (matcher.find()) {
            String restOfLine;
            MethodBounds bounds;
            if (matcher.start() <= excludeOffset && (bounds = this.findMethodBounds(content, matcher.start() + 1)) != null && excludeOffset >= bounds.start && excludeOffset <= bounds.end) continue;
            Object signature = matcher.group(0);
            int lineEnd = content.indexOf(10, matcher.end());
            if (lineEnd > matcher.end() && EXPORT_MARKER.matcher(restOfLine = content.substring(matcher.end(), lineEnd)).find()) {
                signature = (String)signature + restOfLine.trim();
            }
            signatures.add((String)signature);
            if (signatures.size() >= 30) break;
        }
        return signatures;
    }

    private String extractSurroundingCode(String content, int offset, int maxChars) {
        int halfWindow = maxChars / 2;
        int start = Math.max(0, offset - halfWindow);
        int end = Math.min(content.length(), offset + halfWindow);
        return content.substring(start, end);
    }

    public static class LocalContext {
        private final String currentMethodSignature;
        private final String currentMethodBody;
        private final List<String> localVariables;
        private final List<String> parameters;
        private final List<String> moduleVariables;
        private final List<String> otherMethodSignatures;
        private final int cursorOffsetInMethod;

        private LocalContext(Builder builder) {
            this.currentMethodSignature = builder.currentMethodSignature;
            this.currentMethodBody = builder.currentMethodBody;
            this.localVariables = builder.localVariables;
            this.parameters = builder.parameters;
            this.moduleVariables = builder.moduleVariables;
            this.otherMethodSignatures = builder.otherMethodSignatures;
            this.cursorOffsetInMethod = builder.cursorOffsetInMethod;
        }

        public static LocalContext empty() {
            return LocalContext.builder().build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getCurrentMethodSignature() {
            return this.currentMethodSignature;
        }

        public String getCurrentMethodBody() {
            return this.currentMethodBody;
        }

        public List<String> getLocalVariables() {
            return this.localVariables;
        }

        public List<String> getParameters() {
            return this.parameters;
        }

        public List<String> getModuleVariables() {
            return this.moduleVariables;
        }

        public List<String> getOtherMethodSignatures() {
            return this.otherMethodSignatures;
        }

        public int getCursorOffsetInMethod() {
            return this.cursorOffsetInMethod;
        }

        public boolean isEmpty() {
            return (this.currentMethodBody == null || this.currentMethodBody.isEmpty()) && this.otherMethodSignatures.isEmpty();
        }

        public int estimateTokens() {
            int chars = 0;
            if (this.currentMethodSignature != null) {
                chars += this.currentMethodSignature.length();
            }
            if (this.currentMethodBody != null) {
                chars += this.currentMethodBody.length();
            }
            for (String s : this.localVariables) {
                chars += s.length() + 10;
            }
            for (String s : this.parameters) {
                chars += s.length() + 10;
            }
            for (String s : this.moduleVariables) {
                chars += s.length() + 10;
            }
            for (String s : this.otherMethodSignatures) {
                chars += s.length() + 5;
            }
            return chars / 4;
        }

        public static class Builder {
            private String currentMethodSignature = "";
            private String currentMethodBody = "";
            private List<String> localVariables = new ArrayList<String>();
            private List<String> parameters = new ArrayList<String>();
            private List<String> moduleVariables = new ArrayList<String>();
            private List<String> otherMethodSignatures = new ArrayList<String>();
            private int cursorOffsetInMethod = 0;

            public Builder currentMethodSignature(String s) {
                this.currentMethodSignature = s;
                return this;
            }

            public Builder currentMethodBody(String s) {
                this.currentMethodBody = s;
                return this;
            }

            public Builder localVariables(List<String> l) {
                this.localVariables = l;
                return this;
            }

            public Builder parameters(List<String> l) {
                this.parameters = l;
                return this;
            }

            public Builder moduleVariables(List<String> l) {
                this.moduleVariables = l;
                return this;
            }

            public Builder otherMethodSignatures(List<String> l) {
                this.otherMethodSignatures = l;
                return this;
            }

            public Builder cursorOffsetInMethod(int i) {
                this.cursorOffsetInMethod = i;
                return this;
            }

            public LocalContext build() {
                return new LocalContext(this);
            }
        }
    }

    private record MethodBounds(int start, int end) {
    }
}

