/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.bsl.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BslContext {
    private final String moduleType;
    private final String moduleName;
    private final String currentMethod;
    private final String selectedCode;
    private final String surroundingCode;
    private final int cursorOffset;
    private final int cursorLine;
    private final int cursorColumn;
    private final String prefix;
    private final String suffix;
    private final List<String> imports;
    private final List<String> availableVariables;
    private final List<String> availableMethods;
    private final String metadataObjectPath;

    private BslContext(Builder builder) {
        this.moduleType = builder.moduleType;
        this.moduleName = builder.moduleName;
        this.currentMethod = builder.currentMethod;
        this.selectedCode = builder.selectedCode;
        this.surroundingCode = builder.surroundingCode;
        this.cursorOffset = builder.cursorOffset;
        this.cursorLine = builder.cursorLine;
        this.cursorColumn = builder.cursorColumn;
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
        this.imports = Collections.unmodifiableList(new ArrayList<String>(builder.imports));
        this.availableVariables = Collections.unmodifiableList(new ArrayList<String>(builder.availableVariables));
        this.availableMethods = Collections.unmodifiableList(new ArrayList<String>(builder.availableMethods));
        this.metadataObjectPath = builder.metadataObjectPath;
    }

    public String getModuleType() {
        return this.moduleType;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getCurrentMethod() {
        return this.currentMethod;
    }

    public String getSelectedCode() {
        return this.selectedCode;
    }

    public String getSurroundingCode() {
        return this.surroundingCode;
    }

    public int getCursorOffset() {
        return this.cursorOffset;
    }

    public int getCursorLine() {
        return this.cursorLine;
    }

    public int getCursorColumn() {
        return this.cursorColumn;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public List<String> getAvailableVariables() {
        return this.availableVariables;
    }

    public List<String> getAvailableMethods() {
        return this.availableMethods;
    }

    public String getMetadataObjectPath() {
        return this.metadataObjectPath;
    }

    public boolean hasSelection() {
        return this.selectedCode != null && !this.selectedCode.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String moduleType = "";
        private String moduleName = "";
        private String currentMethod = "";
        private String selectedCode = "";
        private String surroundingCode = "";
        private int cursorOffset = 0;
        private int cursorLine = 0;
        private int cursorColumn = 0;
        private String prefix = "";
        private String suffix = "";
        private List<String> imports = new ArrayList<String>();
        private List<String> availableVariables = new ArrayList<String>();
        private List<String> availableMethods = new ArrayList<String>();
        private String metadataObjectPath = "";

        public Builder moduleType(String moduleType) {
            this.moduleType = moduleType;
            return this;
        }

        public Builder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public Builder currentMethod(String currentMethod) {
            this.currentMethod = currentMethod;
            return this;
        }

        public Builder selectedCode(String selectedCode) {
            this.selectedCode = selectedCode;
            return this;
        }

        public Builder surroundingCode(String surroundingCode) {
            this.surroundingCode = surroundingCode;
            return this;
        }

        public Builder cursorOffset(int cursorOffset) {
            this.cursorOffset = cursorOffset;
            return this;
        }

        public Builder cursorLine(int cursorLine) {
            this.cursorLine = cursorLine;
            return this;
        }

        public Builder cursorColumn(int cursorColumn) {
            this.cursorColumn = cursorColumn;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder imports(List<String> imports) {
            this.imports = imports;
            return this;
        }

        public Builder availableVariables(List<String> availableVariables) {
            this.availableVariables = availableVariables;
            return this;
        }

        public Builder availableMethods(List<String> availableMethods) {
            this.availableMethods = availableMethods;
            return this;
        }

        public Builder metadataObjectPath(String metadataObjectPath) {
            this.metadataObjectPath = metadataObjectPath;
            return this;
        }

        public BslContext build() {
            return new BslContext(this);
        }
    }
}

