/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.views;

import com.example.vibe.ui.chat.MessagePart;
import com.example.vibe.ui.theme.ThemeManager;
import com.example.vibe.ui.theme.VibeTheme;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

public class TodoListWidget
extends Composite {
    private final List<MessagePart.TodoListPart.TodoItem> items;
    private final List<Button> checkboxes = new ArrayList<Button>();
    private final VibeTheme theme;
    private Label progressLabel;
    private ProgressBar progressBar;

    public TodoListWidget(Composite parent, MessagePart.TodoListPart todoList) {
        super(parent, 0);
        this.items = new ArrayList<MessagePart.TodoListPart.TodoItem>(todoList.items());
        this.theme = ThemeManager.getInstance().getTheme();
        this.createContents();
    }

    public TodoListWidget(Composite parent, List<MessagePart.TodoListPart.TodoItem> items) {
        super(parent, 0);
        this.items = new ArrayList<MessagePart.TodoListPart.TodoItem>(items);
        this.theme = ThemeManager.getInstance().getTheme();
        this.createContents();
    }

    private void createContents() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.theme.getMargin();
        layout.marginHeight = this.theme.getMargin();
        layout.verticalSpacing = this.theme.getMarginSmall();
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.setBackground(this.theme.getSurfaceElevated());
        this.createHeader();
        this.createItems();
    }

    private void createHeader() {
        Composite header = new Composite((Composite)this, 0);
        header.setBackground(this.getBackground());
        GridLayout headerLayout = new GridLayout(3, false);
        headerLayout.marginWidth = 0;
        headerLayout.marginHeight = 0;
        header.setLayout((Layout)headerLayout);
        header.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label titleLabel = new Label(header, 0);
        titleLabel.setBackground(header.getBackground());
        titleLabel.setForeground(this.theme.getText());
        titleLabel.setFont(this.theme.getFontBold());
        titleLabel.setText("\u2611 \u0417\u0430\u0434\u0430\u0447\u0438");
        titleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.progressBar = new ProgressBar(header, 256);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        GridData progressData = new GridData(4, 0x1000000, true, false);
        progressData.widthHint = 100;
        this.progressBar.setLayoutData((Object)progressData);
        this.progressLabel = new Label(header, 0);
        this.progressLabel.setBackground(header.getBackground());
        this.progressLabel.setForeground(this.theme.getTextMuted());
        this.progressLabel.setFont(this.theme.getFontSmall());
        this.progressLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.updateProgress();
    }

    private void createItems() {
        Composite itemsContainer = new Composite((Composite)this, 0);
        itemsContainer.setBackground(this.getBackground());
        GridLayout itemsLayout = new GridLayout(1, false);
        itemsLayout.marginWidth = this.theme.getMargin();
        itemsLayout.marginHeight = 0;
        itemsLayout.verticalSpacing = 2;
        itemsContainer.setLayout((Layout)itemsLayout);
        itemsContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        int i = 0;
        while (i < this.items.size()) {
            MessagePart.TodoListPart.TodoItem item = this.items.get(i);
            int index = i++;
            Composite itemRow = new Composite(itemsContainer, 0);
            itemRow.setBackground(itemsContainer.getBackground());
            itemRow.setLayout((Layout)new GridLayout(2, false));
            itemRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Button checkbox = new Button(itemRow, 32);
            checkbox.setBackground(itemRow.getBackground());
            checkbox.setSelection(item.checked());
            checkbox.addListener(13, e -> {
                MessagePart.TodoListPart.TodoItem oldItem = this.items.get(index);
                this.items.set(index, new MessagePart.TodoListPart.TodoItem(oldItem.text(), checkbox.getSelection()));
                this.updateProgress();
            });
            this.checkboxes.add(checkbox);
            Label itemLabel = new Label(itemRow, 64);
            itemLabel.setBackground(itemRow.getBackground());
            itemLabel.setForeground(this.theme.getText());
            itemLabel.setFont(this.theme.getFont());
            itemLabel.setText(item.text());
            GridData labelData = new GridData(4, 0x1000000, true, false);
            labelData.widthHint = 300;
            itemLabel.setLayoutData((Object)labelData);
            item.checked();
        }
    }

    private void updateProgress() {
        if (this.items.isEmpty()) {
            this.progressBar.setSelection(0);
            this.progressLabel.setText("0/0");
            return;
        }
        int completed = (int)this.items.stream().filter(MessagePart.TodoListPart.TodoItem::checked).count();
        int total = this.items.size();
        int percent = completed * 100 / total;
        this.progressBar.setSelection(percent);
        this.progressLabel.setText(completed + "/" + total);
    }

    public List<MessagePart.TodoListPart.TodoItem> getItems() {
        return new ArrayList<MessagePart.TodoListPart.TodoItem>(this.items);
    }

    public int getCompletionPercent() {
        if (this.items.isEmpty()) {
            return 0;
        }
        int completed = (int)this.items.stream().filter(MessagePart.TodoListPart.TodoItem::checked).count();
        return completed * 100 / this.items.size();
    }

    public void dispose() {
        this.checkboxes.clear();
        super.dispose();
    }
}

