/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.views;

import com.example.vibe.ui.chat.MessageContentParser;
import com.example.vibe.ui.chat.MessageKind;
import com.example.vibe.ui.chat.MessagePart;
import com.example.vibe.ui.theme.ThemeManager;
import com.example.vibe.ui.theme.VibeTheme;
import com.example.vibe.ui.views.CodeBlockWidget;
import com.example.vibe.ui.views.TodoListWidget;
import com.example.vibe.ui.views.ToolCallWidget;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MessageBubbleComposite
extends Composite {
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private final MessageKind kind;
    private final String rawContent;
    private final LocalDateTime timestamp;
    private final VibeTheme theme;
    private Composite headerComposite;
    private Composite contentComposite;
    private Composite actionsComposite;
    private final List<CodeBlockWidget> codeBlockWidgets = new ArrayList<CodeBlockWidget>();
    private final List<ToolCallWidget> toolCallWidgets = new ArrayList<ToolCallWidget>();
    private final Map<String, ToolCallWidget> toolCallWidgetMap = new HashMap<String, ToolCallWidget>();
    private final MessageContentParser contentParser = new MessageContentParser();
    private boolean hovered = false;

    public MessageBubbleComposite(Composite parent, MessageKind kind, String content) {
        this(parent, kind, content, LocalDateTime.now());
    }

    public MessageBubbleComposite(Composite parent, MessageKind kind, String content, LocalDateTime timestamp) {
        super(parent, 0);
        this.kind = kind;
        this.rawContent = content != null ? content : "";
        this.timestamp = timestamp;
        this.theme = ThemeManager.getInstance().getTheme();
        this.createContents();
        this.setupHoverBehavior();
    }

    private void createContents() {
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.marginWidth = this.theme.getMargin();
        mainLayout.marginHeight = this.theme.getMarginSmall();
        mainLayout.verticalSpacing = 0;
        this.setLayout((Layout)mainLayout);
        this.setLayoutData(new GridData(4, 128, true, false));
        this.setBackground(this.getBackgroundColorForKind());
        this.addListener(9, this::paintBorder);
        this.createHeader();
        this.createContent();
        this.createActions();
    }

    private void createHeader() {
        this.headerComposite = new Composite((Composite)this, 0);
        GridLayout headerLayout = new GridLayout(3, false);
        headerLayout.marginWidth = this.theme.getPadding();
        headerLayout.marginHeight = this.theme.getMarginSmall();
        headerLayout.horizontalSpacing = this.theme.getMargin();
        this.headerComposite.setLayout((Layout)headerLayout);
        this.headerComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.headerComposite.setBackground(this.getBackgroundColorForKind());
        Label roleIcon = new Label(this.headerComposite, 0);
        roleIcon.setText(this.getRoleIcon());
        roleIcon.setFont(this.theme.getFontBold());
        roleIcon.setForeground(this.getRoleColor());
        roleIcon.setBackground(this.headerComposite.getBackground());
        Label roleName = new Label(this.headerComposite, 0);
        roleName.setText(this.kind.getDisplayName());
        roleName.setFont(this.theme.getFontBold());
        roleName.setForeground(this.theme.getText());
        roleName.setBackground(this.headerComposite.getBackground());
        roleName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label timeLabel = new Label(this.headerComposite, 0);
        timeLabel.setText(this.timestamp.format(TIME_FORMATTER));
        timeLabel.setFont(this.theme.getFontSmall());
        timeLabel.setForeground(this.theme.getTextMuted());
        timeLabel.setBackground(this.headerComposite.getBackground());
    }

    private void createContent() {
        this.contentComposite = new Composite((Composite)this, 0);
        GridLayout contentLayout = new GridLayout(1, false);
        contentLayout.marginWidth = this.theme.getPadding();
        contentLayout.marginHeight = this.theme.getMarginSmall();
        contentLayout.verticalSpacing = this.theme.getMarginSmall();
        this.contentComposite.setLayout((Layout)contentLayout);
        this.contentComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.contentComposite.setBackground(this.getBackgroundColorForKind());
        List<MessagePart> parts = this.contentParser.parse(this.rawContent);
        if (parts.isEmpty() && !this.rawContent.trim().isEmpty()) {
            this.createTextWidget(this.rawContent);
        } else {
            for (MessagePart part : parts) {
                this.renderPart(part);
            }
        }
    }

    private void createActions() {
        this.actionsComposite = new Composite((Composite)this, 0);
        GridLayout actionsLayout = new GridLayout(3, false);
        actionsLayout.marginWidth = this.theme.getPadding();
        actionsLayout.marginHeight = this.theme.getMarginSmall();
        actionsLayout.horizontalSpacing = this.theme.getMarginSmall();
        this.actionsComposite.setLayout((Layout)actionsLayout);
        this.actionsComposite.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.actionsComposite.setBackground(this.getBackgroundColorForKind());
        this.actionsComposite.setVisible(false);
        Label copyBtn = this.createActionButton(this.actionsComposite, "\u2398", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        copyBtn.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                MessageBubbleComposite.this.copyToClipboard();
            }
        });
        if (this.kind == MessageKind.ASSISTANT) {
            this.createActionButton(this.actionsComposite, "\u21bb", "\u0420\u0435\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        }
    }

    private Label createActionButton(Composite parent, String icon, String tooltip) {
        final Label btn = new Label(parent, 0);
        btn.setText(icon);
        btn.setToolTipText(tooltip);
        btn.setFont(this.theme.getFont());
        btn.setForeground(this.theme.getTextMuted());
        btn.setBackground(parent.getBackground());
        btn.setCursor(this.getDisplay().getSystemCursor(21));
        btn.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                btn.setForeground(MessageBubbleComposite.this.theme.getAccent());
            }

            public void mouseExit(MouseEvent e) {
                btn.setForeground(MessageBubbleComposite.this.theme.getTextMuted());
            }
        });
        return btn;
    }

    private void setupHoverBehavior() {
        MouseTrackAdapter hoverListener = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                MessageBubbleComposite.this.setHovered(true);
            }

            public void mouseExit(MouseEvent e) {
                Point pt = MessageBubbleComposite.this.getDisplay().getCursorLocation();
                pt = MessageBubbleComposite.this.toControl(pt);
                Rectangle bounds = MessageBubbleComposite.this.getClientArea();
                if (!bounds.contains(pt)) {
                    MessageBubbleComposite.this.setHovered(false);
                }
            }
        };
        this.addMouseTrackListener((MouseTrackListener)hoverListener);
        if (this.headerComposite != null) {
            this.headerComposite.addMouseTrackListener((MouseTrackListener)hoverListener);
        }
        if (this.contentComposite != null) {
            this.contentComposite.addMouseTrackListener((MouseTrackListener)hoverListener);
        }
    }

    private void setHovered(boolean hovered) {
        if (this.hovered != hovered) {
            this.hovered = hovered;
            if (this.actionsComposite != null && !this.actionsComposite.isDisposed()) {
                this.actionsComposite.setVisible(hovered);
                this.layout(true, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void renderPart(MessagePart part) {
        MessagePart messagePart = part;
        if (messagePart instanceof MessagePart.TextPart) {
            void textPart;
            MessagePart.TextPart textPart2 = (MessagePart.TextPart)messagePart;
            MessagePart.TextPart cfr_ignored_0 = (MessagePart.TextPart)messagePart;
            this.createTextWidget(textPart.content());
        } else {
            MessagePart messagePart2 = part;
            if (messagePart2 instanceof MessagePart.CodeBlockPart) {
                void codeBlock;
                MessagePart.CodeBlockPart codeBlockPart = (MessagePart.CodeBlockPart)messagePart2;
                MessagePart.CodeBlockPart cfr_ignored_1 = (MessagePart.CodeBlockPart)messagePart2;
                this.createCodeBlockWidget((MessagePart.CodeBlockPart)codeBlock);
            } else {
                MessagePart messagePart3 = part;
                if (messagePart3 instanceof MessagePart.ToolCallPart) {
                    void toolCall;
                    MessagePart.ToolCallPart toolCallPart = (MessagePart.ToolCallPart)messagePart3;
                    MessagePart.ToolCallPart cfr_ignored_2 = (MessagePart.ToolCallPart)messagePart3;
                    this.createToolCallWidget((MessagePart.ToolCallPart)toolCall);
                } else {
                    MessagePart messagePart4 = part;
                    if (messagePart4 instanceof MessagePart.ToolResultPart) {
                        void toolResult;
                        MessagePart.ToolResultPart toolResultPart = (MessagePart.ToolResultPart)messagePart4;
                        MessagePart.ToolResultPart cfr_ignored_3 = (MessagePart.ToolResultPart)messagePart4;
                        this.updateToolCallWithResult((MessagePart.ToolResultPart)toolResult);
                    } else {
                        MessagePart messagePart5 = part;
                        if (messagePart5 instanceof MessagePart.TodoListPart) {
                            void todoList;
                            MessagePart.TodoListPart todoListPart = (MessagePart.TodoListPart)messagePart5;
                            MessagePart.TodoListPart cfr_ignored_4 = (MessagePart.TodoListPart)messagePart5;
                            this.createTodoListWidget((MessagePart.TodoListPart)todoList);
                        }
                    }
                }
            }
        }
    }

    private void createTextWidget(String text) {
        if (text == null || text.trim().isEmpty()) {
            return;
        }
        StyledText styledText = new StyledText(this.contentComposite, 72);
        styledText.setEditable(false);
        styledText.setBackground(this.getBackgroundColorForKind());
        styledText.setForeground(this.theme.getText());
        styledText.setFont(this.theme.getFont());
        styledText.setLayoutData((Object)new GridData(4, 128, true, false));
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        String processedText = this.processMarkdown(text, styles);
        styledText.setText(processedText);
        for (StyleRange style : styles) {
            if (style.start < 0 || style.start + style.length > styledText.getCharCount()) continue;
            styledText.setStyleRange(style);
        }
        Menu menu = new Menu((Control)styledText);
        MenuItem copyItem = new MenuItem(menu, 8);
        copyItem.setText("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        copyItem.addListener(13, e -> styledText.copy());
        styledText.setMenu(menu);
    }

    private String processMarkdown(String text, List<StyleRange> styles) {
        text = this.processPattern(text, styles, "^(#{1,6})\\s+(.+)$", (start, content) -> this.createHeaderStyle(start, content.length()));
        text = this.processPattern(text, styles, "\\*\\*(.+?)\\*\\*|__(.+?)__", (start, content) -> this.createBoldStyle(start, content.length()));
        text = this.processPattern(text, styles, "(?<![\\*_])\\*([^\\*]+)\\*(?![\\*_])|(?<![\\*_])_([^_]+)_(?![\\*_])", (start, content) -> this.createItalicStyle(start, content.length()));
        text = this.processPattern(text, styles, "`([^`]+)`", (start, content) -> this.createInlineCodeStyle(start, content.length()));
        return text;
    }

    private String processPattern(String text, List<StyleRange> styles, String pattern, StyleFactory factory) {
        Matcher matcher = Pattern.compile(pattern, 8).matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String content = matcher.group(matcher.groupCount());
            if (content == null) {
                int i = 1;
                while (i < matcher.groupCount()) {
                    if (matcher.group(i) != null) {
                        content = matcher.group(i);
                        break;
                    }
                    ++i;
                }
            }
            if (content == null) {
                content = matcher.group(0);
            }
            int startPos = sb.length();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(content));
            styles.add(factory.create(startPos, content));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private StyleRange createHeaderStyle(int start, int length) {
        StyleRange style = new StyleRange();
        style.start = start;
        style.length = length;
        style.font = this.theme.getFontHeader();
        style.foreground = this.theme.getAccent();
        return style;
    }

    private StyleRange createBoldStyle(int start, int length) {
        StyleRange style = new StyleRange();
        style.start = start;
        style.length = length;
        style.font = this.theme.getFontBold();
        style.fontStyle = 1;
        return style;
    }

    private StyleRange createItalicStyle(int start, int length) {
        StyleRange style = new StyleRange();
        style.start = start;
        style.length = length;
        style.font = this.theme.getFontItalic();
        style.fontStyle = 2;
        return style;
    }

    private StyleRange createInlineCodeStyle(int start, int length) {
        StyleRange style = new StyleRange();
        style.start = start;
        style.length = length;
        style.font = this.theme.getFontMono();
        style.background = this.theme.getInlineCodeBackground();
        return style;
    }

    private void createCodeBlockWidget(MessagePart.CodeBlockPart codeBlock) {
        CodeBlockWidget widget = new CodeBlockWidget(this.contentComposite, codeBlock.code(), codeBlock.language());
        widget.setLayoutData(new GridData(4, 128, true, false));
        this.codeBlockWidgets.add(widget);
    }

    private void createToolCallWidget(MessagePart.ToolCallPart toolCall) {
        ToolCallWidget widget = new ToolCallWidget(this.contentComposite, toolCall);
        widget.setLayoutData(new GridData(4, 128, true, false));
        this.toolCallWidgets.add(widget);
        this.toolCallWidgetMap.put(toolCall.toolCallId(), widget);
    }

    private void updateToolCallWithResult(MessagePart.ToolResultPart result) {
        ToolCallWidget widget = this.toolCallWidgetMap.get(result.toolCallId());
        if (widget != null && !widget.isDisposed()) {
            widget.setResult(result);
        }
    }

    private void createTodoListWidget(MessagePart.TodoListPart todoList) {
        TodoListWidget widget = new TodoListWidget(this.contentComposite, todoList);
        widget.setLayoutData(new GridData(4, 128, true, false));
    }

    private void paintBorder(Event e) {
        GC gc = e.gc;
        Rectangle bounds = this.getClientArea();
        gc.setForeground(this.theme.getBorderSubtle());
        gc.setLineWidth(1);
        gc.drawLine(0, 0, bounds.width, 0);
        gc.drawLine(0, bounds.height - 1, bounds.width, bounds.height - 1);
    }

    private Color getBackgroundColorForKind() {
        switch (this.kind) {
            case USER: {
                return this.theme.getUserMessageBackground();
            }
            case ASSISTANT: {
                return this.theme.getAssistantMessageBackground();
            }
            case SYSTEM: {
                return this.theme.getSystemMessageBackground();
            }
            case TOOL_CALL: {
                return this.theme.getToolCallBackground();
            }
            case TOOL_RESULT: {
                return this.theme.getToolResultBackground();
            }
        }
        return this.theme.getSurface();
    }

    private String getRoleIcon() {
        switch (this.kind) {
            case USER: {
                return "\u2022";
            }
            case ASSISTANT: {
                return "\u2726";
            }
            case SYSTEM: {
                return "\u2699";
            }
            case TOOL_CALL: 
            case TOOL_RESULT: {
                return "\u2692";
            }
        }
        return "\u2022";
    }

    private Color getRoleColor() {
        switch (this.kind) {
            case USER: {
                return this.theme.getAccent();
            }
            case ASSISTANT: {
                return this.theme.getSuccess();
            }
            case SYSTEM: {
                return this.theme.getWarning();
            }
            case TOOL_CALL: 
            case TOOL_RESULT: {
                return this.theme.getTextMuted();
            }
        }
        return this.theme.getText();
    }

    private void copyToClipboard() {
        Clipboard clipboard = new Clipboard(this.getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        clipboard.setContents(new Object[]{this.rawContent}, new Transfer[]{textTransfer});
        clipboard.dispose();
    }

    public MessageKind getMessageKind() {
        return this.kind;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public List<CodeBlockWidget> getCodeBlockWidgets() {
        return new ArrayList<CodeBlockWidget>(this.codeBlockWidgets);
    }

    public void addToolResult(MessagePart.ToolResultPart result) {
        this.updateToolCallWithResult(result);
    }

    public void dispose() {
        this.codeBlockWidgets.clear();
        this.toolCallWidgets.clear();
        this.toolCallWidgetMap.clear();
        super.dispose();
    }

    @FunctionalInterface
    private static interface StyleFactory {
        public StyleRange create(int var1, String var2);
    }
}

