/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.views;

import com.example.vibe.ui.theme.ThemeManager;
import com.example.vibe.ui.theme.VibeTheme;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class MarkdownRenderer {
    private static final Pattern CODE_BLOCK_PATTERN = Pattern.compile("```(\\w*)[\\t ]*\\r?\\n([\\s\\S]*?)```", 8);
    private static final Pattern INLINE_CODE_PATTERN = Pattern.compile("`([^`]+)`");
    private static final Pattern BOLD_PATTERN = Pattern.compile("\\*\\*(.+?)\\*\\*|__(.+?)__");
    private static final Pattern ITALIC_PATTERN = Pattern.compile("(?<![\\*_])\\*([^\\*]+)\\*(?![\\*_])|(?<![\\*_])_([^_]+)_(?![\\*_])");
    private static final Pattern HEADER_PATTERN = Pattern.compile("^(#{1,6})\\s+(.+)$", 8);
    private static final Pattern BULLET_PATTERN = Pattern.compile("^\\s*[-*]\\s+(.+)$", 8);
    private static final Pattern NUMBERED_PATTERN = Pattern.compile("^\\s*(\\d+)\\.\\s+(.+)$", 8);
    private static final Pattern BLOCKQUOTE_PATTERN = Pattern.compile("^>\\s*(.+)$", 8);
    private static final Pattern TABLE_PATTERN = Pattern.compile("(^\\|.+\\|\\s*\\r?\\n)(^\\|[-:|\\s]+\\|\\s*\\r?\\n)((?:^\\|.+\\|\\s*\\r?\\n?)+)", 8);
    private final StyledText styledText;
    private final VibeTheme theme;
    private Color inlineCodeBackground;
    private Color codeBlockBackground;
    private Color codeColor;
    private Color headerColor;
    private Color quoteColor;
    private Color tableColor;
    private Font boldFont;
    private Font italicFont;
    private Font codeFont;
    private Font headerFont;

    public MarkdownRenderer(StyledText styledText) {
        this.styledText = styledText;
        this.theme = ThemeManager.getInstance().getTheme();
        this.initializeResources();
    }

    private void initializeResources() {
        this.inlineCodeBackground = this.theme.getInlineCodeBackground();
        this.codeBlockBackground = this.theme.getCodeBackground();
        this.codeColor = this.theme.getCodeText();
        this.headerColor = this.theme.getAccent();
        this.quoteColor = this.theme.getTextMuted();
        this.tableColor = this.theme.getAccent();
        this.boldFont = this.theme.getFontBold();
        this.italicFont = this.theme.getFontItalic();
        this.codeFont = this.theme.getFontMono();
        this.headerFont = this.theme.getFontHeader();
    }

    public String render(String markdown) {
        if (markdown == null || markdown.isEmpty()) {
            return "";
        }
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        String plainText = this.processMarkdown(markdown, styles);
        return plainText;
    }

    public void appendFormatted(String markdown, int baseOffset) {
        if (markdown == null || markdown.isEmpty()) {
            return;
        }
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        String plainText = this.processMarkdown(markdown, styles);
        for (StyleRange style : styles) {
            style.start += baseOffset;
        }
        this.styledText.append(plainText);
        for (StyleRange style : styles) {
            if (style.start < 0 || style.start + style.length > this.styledText.getCharCount()) continue;
            this.styledText.setStyleRange(style);
        }
    }

    private String processMarkdown(String markdown, List<StyleRange> styles) {
        StringBuilder result = new StringBuilder();
        String text = markdown;
        ArrayList<CodeBlock> codeBlocks = new ArrayList<CodeBlock>();
        Matcher codeBlockMatcher = CODE_BLOCK_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        int blockIndex = 0;
        while (codeBlockMatcher.find()) {
            String language = codeBlockMatcher.group(1);
            String code = codeBlockMatcher.group(2);
            String placeholder = "\u0000CODEBLOCK" + blockIndex + "\u0000";
            codeBlocks.add(new CodeBlock(language, code, placeholder));
            codeBlockMatcher.appendReplacement(sb, Matcher.quoteReplacement(placeholder));
            ++blockIndex;
        }
        codeBlockMatcher.appendTail(sb);
        text = sb.toString();
        text = this.processTables(text, styles);
        text = this.processHeaders(text, styles, result);
        text = this.processBlockquotes(text, styles);
        text = this.processBold(text, styles);
        text = this.processItalic(text, styles);
        text = this.processInlineCode(text, styles);
        text = this.processBulletLists(text, styles);
        text = this.processNumberedLists(text, styles);
        for (CodeBlock block : codeBlocks) {
            int placeholderPos = text.indexOf(block.placeholder);
            if (placeholderPos < 0) continue;
            String codeText = block.code;
            if (codeText.endsWith("\n")) {
                codeText = codeText.substring(0, codeText.length() - 1);
            }
            StyleRange codeStyle = new StyleRange();
            codeStyle.start = placeholderPos;
            codeStyle.length = codeText.length();
            codeStyle.font = this.codeFont;
            codeStyle.foreground = this.codeColor;
            codeStyle.background = this.codeBlockBackground;
            styles.add(codeStyle);
            text = text.replace(block.placeholder, codeText);
        }
        return text;
    }

    private String processHeaders(String text, List<StyleRange> styles, StringBuilder resultBuilder) {
        Matcher matcher = HEADER_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.group(1).length();
            String headerText = matcher.group(2);
            int startPos = sb.length();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(headerText));
            StyleRange style = new StyleRange();
            style.start = startPos;
            style.length = headerText.length();
            style.font = this.headerFont;
            style.foreground = this.headerColor;
            styles.add(style);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processBlockquotes(String text, List<StyleRange> styles) {
        Matcher matcher = BLOCKQUOTE_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String quoteText = "\u2502 " + matcher.group(1);
            int startPos = sb.length();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(quoteText));
            StyleRange style = new StyleRange();
            style.start = startPos;
            style.length = quoteText.length();
            style.foreground = this.quoteColor;
            style.font = this.italicFont;
            styles.add(style);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processBold(String text, List<StyleRange> styles) {
        Matcher matcher = BOLD_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String boldText = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            int startPos = sb.length();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(boldText));
            StyleRange style = new StyleRange();
            style.start = startPos;
            style.length = boldText.length();
            style.font = this.boldFont;
            style.fontStyle = 1;
            styles.add(style);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processItalic(String text, List<StyleRange> styles) {
        Matcher matcher = ITALIC_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String italicText = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            int startPos = sb.length();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(italicText));
            StyleRange style = new StyleRange();
            style.start = startPos;
            style.length = italicText.length();
            style.font = this.italicFont;
            style.fontStyle = 2;
            styles.add(style);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processInlineCode(String text, List<StyleRange> styles) {
        Matcher matcher = INLINE_CODE_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String codeText = matcher.group(1);
            int startPos = sb.length();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(codeText));
            StyleRange style = new StyleRange();
            style.start = startPos;
            style.length = codeText.length();
            style.font = this.codeFont;
            style.foreground = this.codeColor;
            style.background = this.inlineCodeBackground;
            styles.add(style);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processBulletLists(String text, List<StyleRange> styles) {
        Matcher matcher = BULLET_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String listText = "  \u2022 " + matcher.group(1);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(listText));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processNumberedLists(String text, List<StyleRange> styles) {
        Matcher matcher = NUMBERED_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String number = matcher.group(1);
            String listText = "  " + number + ". " + matcher.group(2);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(listText));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processTables(String text, List<StyleRange> styles) {
        Matcher matcher = TABLE_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            Object cells;
            String headerRow = matcher.group(1).trim();
            String dataRows = matcher.group(3);
            String[] headers = this.parseTableRow(headerRow);
            if (headers.length == 0) continue;
            String[] dataLines = dataRows.split("\\n");
            ArrayList<String[]> rows = new ArrayList<String[]>();
            String[] stringArray = dataLines;
            int n = dataLines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!(line = line.trim()).isEmpty() && line.startsWith("|") && ((String[])(cells = this.parseTableRow(line))).length > 0) {
                    rows.add((String[])cells);
                }
                ++n2;
            }
            int[] widths = new int[headers.length];
            int i = 0;
            while (i < headers.length) {
                widths[i] = headers[i].length();
                ++i;
            }
            for (String[] row : rows) {
                int i2 = 0;
                while (i2 < Math.min(row.length, widths.length)) {
                    widths[i2] = Math.max(widths[i2], row[i2].length());
                    ++i2;
                }
            }
            StringBuilder table = new StringBuilder();
            int startPos = sb.length();
            table.append(this.buildTableBorder(widths, '\u250c', '\u252c', '\u2510')).append("\n");
            table.append(this.buildTableRow(headers, widths)).append("\n");
            table.append(this.buildTableBorder(widths, '\u251c', '\u253c', '\u2524')).append("\n");
            cells = rows.iterator();
            while (cells.hasNext()) {
                String[] row = (String[])cells.next();
                table.append(this.buildTableRow(row, widths)).append("\n");
            }
            table.append(this.buildTableBorder(widths, '\u2514', '\u2534', '\u2518'));
            String tableText = table.toString();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(tableText));
            StyleRange style = new StyleRange();
            style.start = startPos;
            style.length = tableText.length();
            style.font = this.codeFont;
            style.foreground = this.tableColor;
            styles.add(style);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String[] parseTableRow(String row) {
        if ((row = row.trim()).startsWith("|")) {
            row = row.substring(1);
        }
        if (row.endsWith("|")) {
            row = row.substring(0, row.length() - 1);
        }
        String[] cells = row.split("\\|");
        int i = 0;
        while (i < cells.length) {
            cells[i] = cells[i].trim();
            ++i;
        }
        return cells;
    }

    private String buildTableBorder(int[] widths, char left, char middle, char right) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        int i = 0;
        while (i < widths.length) {
            int j = 0;
            while (j < widths[i] + 2) {
                sb.append('\u2500');
                ++j;
            }
            if (i < widths.length - 1) {
                sb.append(middle);
            }
            ++i;
        }
        sb.append(right);
        return sb.toString();
    }

    private String buildTableRow(String[] cells, int[] widths) {
        StringBuilder sb = new StringBuilder();
        sb.append('\u2502');
        int i = 0;
        while (i < widths.length) {
            sb.append(' ');
            String cell = i < cells.length ? cells[i] : "";
            sb.append(cell);
            int j = cell.length();
            while (j < widths[i]) {
                sb.append(' ');
                ++j;
            }
            sb.append(' ');
            sb.append('\u2502');
            ++i;
        }
        return sb.toString();
    }

    public void dispose() {
    }

    private static class CodeBlock {
        final String language;
        final String code;
        final String placeholder;

        CodeBlock(String language, String code, String placeholder) {
            this.language = language;
            this.code = code;
            this.placeholder = placeholder;
        }
    }
}

