/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.views;

import com.example.vibe.core.agent.prompts.SystemPromptBuilder;
import com.example.vibe.core.diff.CodeDiffUtils;
import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.model.LlmMessage;
import com.example.vibe.core.model.LlmRequest;
import com.example.vibe.core.model.LlmResponse;
import com.example.vibe.core.model.LlmStreamChunk;
import com.example.vibe.core.model.ToolCall;
import com.example.vibe.core.provider.ILlmProvider;
import com.example.vibe.core.provider.LlmProviderException;
import com.example.vibe.core.provider.LlmProviderRegistry;
import com.example.vibe.core.provider.ModelService;
import com.example.vibe.core.session.Session;
import com.example.vibe.core.session.SessionManager;
import com.example.vibe.core.settings.PromptTemplateService;
import com.example.vibe.core.state.VibeStateService;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolRegistry;
import com.example.vibe.core.tools.ToolResult;
import com.example.vibe.ui.dialogs.SessionPromptDialog;
import com.example.vibe.ui.dialogs.ToolConfirmationDialog;
import com.example.vibe.ui.diff.DiffReviewDialog;
import com.example.vibe.ui.diff.ProposedChange;
import com.example.vibe.ui.diff.ProposedChangeSet;
import com.example.vibe.ui.editor.CodeApplicationService;
import com.example.vibe.ui.internal.Messages;
import com.example.vibe.ui.theme.ThemeManager;
import com.example.vibe.ui.theme.VibeTheme;
import com.example.vibe.ui.views.BrowserChatPanel;
import com.example.vibe.ui.views.ChatMessageComposite;
import com.example.vibe.ui.views.TypingIndicatorWidget;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class ChatView
extends ViewPart {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(ChatView.class);
    public static final String ID = "com.example.vibe.ui.views.ChatView";
    public static final String VIEW_ID = "com.example.vibe.ui.views.ChatView";
    private static final int MAX_TOOL_ITERATIONS = 30;
    private boolean toolsEnabled = true;
    private static final boolean USE_BROWSER_RENDERING = true;
    private ScrolledComposite scrolledComposite;
    private Composite messagesContainer;
    private BrowserChatPanel browserChatPanel;
    private Text inputField;
    private Button sendButton;
    private Button clearButton;
    private Button stopButton;
    private Button applyCodeButton;
    private Button sessionPromptButton;
    private Combo modelCombo;
    private TypingIndicatorWidget typingIndicator;
    private final List<LlmMessage> conversationHistory = new ArrayList<LlmMessage>();
    private final List<ChatMessageComposite> messageWidgets = new ArrayList<ChatMessageComposite>();
    private CompletableFuture<?> currentRequest;
    private boolean isProcessing = false;
    private String lastAssistantResponse;
    private final SessionManager sessionManager = SessionManager.getInstance();
    private Session currentSession;
    private StringBuffer streamingContent;
    private StringBuffer streamingReasoning;
    private volatile boolean isStreaming = false;
    private volatile boolean streamingHandledToolCalls = false;
    private boolean previewModeEnabled = false;
    private ProposedChangeSet currentProposedChanges;
    private Consumer<VibeTheme> themeChangeListener;
    private MouseWheelListener mouseWheelScroller;

    public void createPartControl(Composite parent) {
        VibeTheme theme = ThemeManager.getInstance().getTheme();
        this.initializeSession();
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setBackground(theme.getBackground());
        this.createChatArea(container);
        this.createInputArea(container);
        this.appendSystemMessage(Messages.ChatView_WelcomeMessage);
    }

    private void createChatArea(Composite parent) {
        this.createBrowserChatArea(parent);
    }

    private void createBrowserChatArea(Composite parent) {
        this.browserChatPanel = new BrowserChatPanel(parent);
        this.browserChatPanel.setLayoutData(new GridData(4, 4, true, true));
        this.browserChatPanel.setApplyCodeCallback((code, language, filePath) -> LOG.info("Apply code requested: language=%s, filePath=%s, codeLength=%d", new Object[]{language, filePath, code != null ? code.length() : 0}));
        this.themeChangeListener = theme -> {
            if (this.browserChatPanel != null && this.browserChatPanel.isBrowserAvailable()) {
                this.browserChatPanel.updateTheme(ThemeManager.getInstance().isDarkTheme());
            }
        };
        ThemeManager.getInstance().addThemeChangeListener(this.themeChangeListener);
        this.browserChatPanel.updateTheme(ThemeManager.getInstance().getTheme().isDark());
    }

    private void createStyledTextChatArea(Composite parent) {
        VibeTheme theme = ThemeManager.getInstance().getTheme();
        this.scrolledComposite = new ScrolledComposite(parent, 2560);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setBackground(theme.getBackground());
        this.messagesContainer = new Composite((Composite)this.scrolledComposite, 0);
        this.messagesContainer.setBackground(theme.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = theme.getMargin();
        layout.marginHeight = theme.getMargin();
        layout.verticalSpacing = theme.getMargin();
        this.messagesContainer.setLayout((Layout)layout);
        this.scrolledComposite.setContent((Control)this.messagesContainer);
        this.messagesContainer.addListener(11, e -> this.updateScrollSize());
        if (this.scrolledComposite.getVerticalBar() != null) {
            this.scrolledComposite.getVerticalBar().setIncrement(20);
            this.scrolledComposite.getVerticalBar().setPageIncrement(100);
        }
        this.installMouseWheelScrolling(this.scrolledComposite, this.messagesContainer);
        this.typingIndicator = new TypingIndicatorWidget(this.messagesContainer);
        this.typingIndicator.setLayoutData(new GridData(4, 0x1000000, true, false));
    }

    private void createInputArea(Composite parent) {
        VibeTheme theme = ThemeManager.getInstance().getTheme();
        Composite inputArea = new Composite(parent, 0);
        inputArea.setBackground(theme.getSurface());
        inputArea.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout inputAreaLayout = new GridLayout(1, false);
        inputAreaLayout.marginWidth = theme.getMargin();
        inputAreaLayout.marginHeight = theme.getMargin();
        inputAreaLayout.verticalSpacing = theme.getMargin();
        inputArea.setLayout((Layout)inputAreaLayout);
        Composite modelRow = new Composite(inputArea, 0);
        modelRow.setBackground(theme.getSurface());
        modelRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout modelRowLayout = new GridLayout(3, false);
        modelRowLayout.marginWidth = 0;
        modelRowLayout.marginHeight = 0;
        modelRowLayout.horizontalSpacing = 6;
        modelRow.setLayout((Layout)modelRowLayout);
        Label modelLabel = new Label(modelRow, 0);
        modelLabel.setText("\u041c\u043e\u0434\u0435\u043b\u044c:");
        modelLabel.setBackground(theme.getSurface());
        modelLabel.setForeground(theme.getText());
        modelLabel.setFont(theme.getFont());
        this.modelCombo = new Combo(modelRow, 12);
        this.modelCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.modelCombo.setFont(theme.getFont());
        ModelService modelService = ModelService.getInstance();
        for (ModelService.ModelInfo model : modelService.getAvailableModels()) {
            this.modelCombo.add(model.getDisplayName());
            this.modelCombo.setData(model.getDisplayName(), (Object)model.getId());
        }
        this.modelCombo.select(0);
        this.modelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = ChatView.this.modelCombo.getSelectionIndex();
                if (idx >= 0) {
                    String displayName = ChatView.this.modelCombo.getItem(idx);
                    String modelId = (String)ChatView.this.modelCombo.getData(displayName);
                    ModelService.getInstance().setSelectedModel(modelId);
                }
            }
        });
        this.sessionPromptButton = new Button(modelRow, 8);
        this.sessionPromptButton.setFont(theme.getFont());
        this.sessionPromptButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.sessionPromptButton.addListener(13, e -> this.editSessionPrompt());
        this.updateSessionPromptButtonState();
        this.inputField = new Text(inputArea, 2626);
        this.inputField.setBackground(theme.getInputBackground());
        this.inputField.setForeground(theme.getText());
        this.inputField.setFont(theme.getFont());
        GridData inputData = new GridData(4, 4, true, false);
        inputData.heightHint = 80;
        this.inputField.setLayoutData((Object)inputData);
        this.inputField.setMessage(Messages.ChatView_InputPlaceholder);
        this.inputField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.keyCode == 13 || e.keyCode == 0x1000050) && (e.stateMask & 0x20000) == 0) {
                    e.doit = false;
                    ChatView.this.sendMessage();
                }
            }
        });
        Composite buttonBar = new Composite(inputArea, 0);
        buttonBar.setBackground(inputArea.getBackground());
        buttonBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout buttonLayout = new GridLayout(5, false);
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        buttonLayout.horizontalSpacing = 4;
        buttonBar.setLayout((Layout)buttonLayout);
        this.sendButton = new Button(buttonBar, 8);
        this.sendButton.setText("\u27a4");
        this.sendButton.setToolTipText(Messages.ChatView_SendButton + " (Enter)");
        this.sendButton.setFont(theme.getFont());
        GridData sendData = new GridData(16384, 0x1000000, false, false);
        sendData.widthHint = 36;
        sendData.heightHint = 28;
        this.sendButton.setLayoutData((Object)sendData);
        this.sendButton.addListener(13, e -> this.sendMessage());
        this.applyCodeButton = new Button(buttonBar, 8);
        this.applyCodeButton.setText("\u2913");
        this.applyCodeButton.setToolTipText(Messages.ChatView_ApplyCodeTooltip);
        this.applyCodeButton.setFont(theme.getFont());
        this.applyCodeButton.setEnabled(false);
        GridData applyData = new GridData(16384, 0x1000000, false, false);
        applyData.widthHint = 36;
        applyData.heightHint = 28;
        this.applyCodeButton.setLayoutData((Object)applyData);
        this.applyCodeButton.addListener(13, e -> this.applyCodeToEditor());
        Label spacer = new Label(buttonBar, 0);
        spacer.setBackground(buttonBar.getBackground());
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.stopButton = new Button(buttonBar, 8);
        this.stopButton.setText("\u25a0");
        this.stopButton.setToolTipText(Messages.ChatView_StopButton);
        this.stopButton.setFont(theme.getFont());
        this.stopButton.setEnabled(false);
        GridData stopData = new GridData(131072, 0x1000000, false, false);
        stopData.widthHint = 36;
        stopData.heightHint = 28;
        this.stopButton.setLayoutData((Object)stopData);
        this.stopButton.addListener(13, e -> this.stopGeneration());
        this.clearButton = new Button(buttonBar, 8);
        this.clearButton.setText("\ud83d\uddd1");
        this.clearButton.setToolTipText(Messages.ChatView_ClearButton);
        this.clearButton.setFont(theme.getFont());
        GridData clearData = new GridData(131072, 0x1000000, false, false);
        clearData.widthHint = 36;
        clearData.heightHint = 28;
        this.clearButton.setLayoutData((Object)clearData);
        this.clearButton.addListener(13, e -> this.clearChat());
    }

    private void initializeSession() {
        this.currentSession = this.sessionManager.getOrCreateCurrentSession();
    }

    private Session getCurrentSession() {
        if (this.currentSession == null) {
            this.initializeSession();
        }
        return this.currentSession;
    }

    private void editSessionPrompt() {
        Session session = this.getCurrentSession();
        if (session == null) {
            return;
        }
        SessionPromptDialog dialog = new SessionPromptDialog(this.getShell(), session.getSystemPrompt());
        if (dialog.open() != 0) {
            return;
        }
        String newPrompt = dialog.getPrompt();
        if (ChatView.isBlank(newPrompt)) {
            session.setSystemPrompt(null);
        } else {
            session.setSystemPrompt(newPrompt.trim());
        }
        boolean saved = this.sessionManager.saveSession(session);
        if (saved) {
            this.appendSystemMessage(ChatView.isBlank(newPrompt) ? "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043f\u0440\u043e\u043c\u043f\u0442 \u0441\u0435\u0441\u0441\u0438\u0438 \u043e\u0447\u0438\u0449\u0435\u043d." : "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043f\u0440\u043e\u043c\u043f\u0442 \u0441\u0435\u0441\u0441\u0438\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d \u0438 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d.");
        } else {
            this.appendSystemMessage("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043f\u0440\u043e\u043c\u043f\u0442 \u0441\u0435\u0441\u0441\u0438\u0438. \u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u0434\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a\u0430.");
        }
        this.updateSessionPromptButtonState();
    }

    private void updateSessionPromptButtonState() {
        if (this.sessionPromptButton == null || this.sessionPromptButton.isDisposed()) {
            return;
        }
        boolean hasCustomPrompt = !ChatView.isBlank(this.getCurrentSession() != null ? this.getCurrentSession().getSystemPrompt() : null);
        this.sessionPromptButton.setText(hasCustomPrompt ? "\u041f\u0440\u043e\u043c\u043f\u0442*" : "\u041f\u0440\u043e\u043c\u043f\u0442");
        this.sessionPromptButton.setToolTipText(hasCustomPrompt ? "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043f\u0440\u043e\u043c\u043f\u0442 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0441\u0435\u0441\u0441\u0438\u0438 (\u0432\u043a\u043b\u044e\u0447\u0435\u043d)." : "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043f\u0440\u043e\u043c\u043f\u0442 \u0434\u043b\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0441\u0435\u0441\u0441\u0438\u0438.");
    }

    private void updateScrollSize() {
        if (this.messagesContainer == null || this.messagesContainer.isDisposed() || this.scrolledComposite == null || this.scrolledComposite.isDisposed()) {
            return;
        }
        int width = this.scrolledComposite.getClientArea().width;
        if (width <= 0) {
            width = this.scrolledComposite.getBounds().width - this.scrolledComposite.getVerticalBar().getSize().x;
        }
        if (width > 0) {
            Point size = this.messagesContainer.computeSize(width, -1);
            this.messagesContainer.setSize(size);
            this.scrolledComposite.setMinSize(size);
        }
    }

    private void scrollToBottom() {
        if (this.scrolledComposite == null || this.scrolledComposite.isDisposed()) {
            return;
        }
        this.messagesContainer.layout(true, true);
        this.updateScrollSize();
        this.scrolledComposite.getDisplay().asyncExec(() -> {
            if (this.scrolledComposite.isDisposed() || this.messagesContainer.isDisposed()) {
                return;
            }
            int contentHeight = this.messagesContainer.getSize().y;
            int viewportHeight = this.scrolledComposite.getClientArea().height;
            if (contentHeight > viewportHeight) {
                this.scrolledComposite.setOrigin(0, contentHeight - viewportHeight);
            }
        });
    }

    private void sendMessage() {
        String userInput = this.inputField.getText().trim();
        LOG.debug("sendMessage called, isProcessing=%b, inputLength=%d", new Object[]{this.isProcessing, userInput.length()});
        if (userInput.isEmpty() || this.isProcessing) {
            LOG.debug("sendMessage blocked: isEmpty=%b, isProcessing=%b", new Object[]{userInput.isEmpty(), this.isProcessing});
            return;
        }
        ILlmProvider provider = LlmProviderRegistry.getInstance().getActiveProvider();
        if (provider == null || !provider.isConfigured()) {
            LOG.warn("Provider not configured");
            this.appendSystemMessage(Messages.ChatView_NotConfiguredMessage);
            return;
        }
        CodeApplicationService.SelectionInfo editorContext = CodeApplicationService.getInstance().getCurrentSelection();
        this.appendUserMessage(userInput);
        this.inputField.setText("");
        this.setProcessing(true, "\u041f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430...");
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.buildMessageWithContext(userInput, editorContext)).thenAcceptAsync(messageWithContext -> {
            this.conversationHistory.add(LlmMessage.user((String)messageWithContext));
            this.setProcessingStage("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430...");
            this.startConversationLoop(provider);
        }, runnable -> {
            Display display = this.getDisplay();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(runnable);
            }
        })).exceptionally(error -> {
            LOG.error("Error preparing message context: %s", new Object[]{error.getMessage()});
            Display display = this.getDisplay();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(() -> {
                    this.setProcessing(false);
                    this.appendSystemMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0438 \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442\u0430: " + error.getMessage());
                });
            }
            return null;
        });
    }

    private void startConversationLoop(ILlmProvider provider) {
        LOG.debug("startConversationLoop: beginning");
        LlmRequest request = this.buildRequestWithTools();
        LOG.debug("startConversationLoop: request built with %d messages, %d tools", new Object[]{request.getMessages().size(), request.hasTools() ? request.getTools().size() : 0});
        Display display = this.getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(() -> {
                if (!this.isDisposed()) {
                    this.setProcessingStage("\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u0430 \u043c\u043e\u0434\u0435\u043b\u0438...");
                }
            });
        }
        if (provider.supportsStreaming()) {
            this.startStreamingRequest(provider, request, display);
        } else {
            this.startNonStreamingRequest(provider, request, display);
        }
    }

    private void startStreamingRequest(ILlmProvider provider, LlmRequest request, Display display) {
        LOG.debug("startStreamingRequest: using streaming mode");
        this.streamingContent = new StringBuffer();
        this.streamingReasoning = new StringBuffer();
        this.isStreaming = true;
        this.streamingHandledToolCalls = false;
        if (!display.isDisposed()) {
            display.asyncExec(() -> {
                if (!this.isDisposed()) {
                    this.setProcessingStage("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u0430...");
                    this.appendAssistantMessage("");
                }
            });
        }
        CompletableFuture.runAsync(() -> {
            block2: {
                try {
                    provider.streamComplete(request, chunk -> this.handleStreamChunk((LlmStreamChunk)chunk, display));
                }
                catch (Exception e) {
                    LOG.error("Streaming error: %s", new Object[]{e.getMessage()});
                    if (display.isDisposed()) break block2;
                    display.asyncExec(() -> {
                        if (!this.isDisposed()) {
                            this.handleError(e);
                        }
                    });
                }
            }
        });
    }

    private void handleStreamChunk(LlmStreamChunk chunk, Display display) {
        String content;
        if (chunk.isError()) {
            LOG.error("Stream error: %s", new Object[]{chunk.getErrorMessage()});
            if (!display.isDisposed()) {
                display.asyncExec(() -> {
                    if (!this.isDisposed()) {
                        this.isStreaming = false;
                        this.handleError(new RuntimeException(chunk.getErrorMessage()));
                    }
                });
            }
            return;
        }
        if (chunk.hasReasoning()) {
            this.streamingReasoning.append(chunk.getReasoningContent());
            String accumulatedReasoning = this.streamingReasoning.toString();
            String accumulatedContent = this.streamingContent.toString();
            if (!display.isDisposed()) {
                display.asyncExec(() -> {
                    if (!this.isDisposed() && this.browserChatPanel != null) {
                        this.browserChatPanel.updateLastMessageWithReasoning(accumulatedContent, accumulatedReasoning);
                    }
                });
            }
        }
        if ((content = chunk.getContent()) != null && !content.isEmpty()) {
            this.streamingContent.append(content);
            String accumulated = this.streamingContent.toString();
            String accumulatedReasoning = this.streamingReasoning.toString();
            if (!display.isDisposed()) {
                display.asyncExec(() -> {
                    if (!this.isDisposed() && this.browserChatPanel != null) {
                        if (accumulatedReasoning.isEmpty()) {
                            this.browserChatPanel.updateLastMessage(accumulated);
                        } else {
                            this.browserChatPanel.updateLastMessageWithReasoning(accumulated, accumulatedReasoning);
                        }
                    }
                });
            }
        }
        if (chunk.hasToolCalls() || chunk.isToolUse()) {
            LOG.debug("Stream received tool calls");
            this.streamingHandledToolCalls = true;
            List toolCalls = chunk.getToolCalls();
            String accumulatedContent = this.streamingContent.toString();
            String accumulatedReasoning = this.streamingReasoning.toString();
            if (!display.isDisposed()) {
                display.asyncExec(() -> {
                    if (!this.isDisposed()) {
                        ILlmProvider provider;
                        this.isStreaming = false;
                        this.setProcessingStage("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432...");
                        LlmResponse toolResponse = LlmResponse.builder().content(accumulatedContent).toolCalls(toolCalls).finishReason("tool_use").build();
                        if (!(this.browserChatPanel == null || accumulatedReasoning.isEmpty() && accumulatedContent.isEmpty())) {
                            this.browserChatPanel.updateLastMessageWithReasoning(accumulatedContent, accumulatedReasoning);
                        }
                        if ((provider = LlmProviderRegistry.getInstance().getActiveProvider()) != null) {
                            ((CompletableFuture)this.handleResponseWithTools(toolResponse, provider, 0).thenAccept(finalContent -> {
                                if (!display.isDisposed()) {
                                    display.asyncExec(() -> {
                                        if (!this.isDisposed()) {
                                            this.setProcessing(false);
                                        }
                                    });
                                }
                            })).exceptionally(error -> {
                                if (!display.isDisposed()) {
                                    display.asyncExec(() -> {
                                        if (!this.isDisposed()) {
                                            this.handleError((Throwable)error);
                                        }
                                    });
                                }
                                return null;
                            });
                        }
                    }
                });
            }
            return;
        }
        if (chunk.isComplete() && !this.streamingHandledToolCalls) {
            String finalContent = this.streamingContent.toString();
            LOG.debug("Stream complete, content length: %d", new Object[]{finalContent.length()});
            if (!display.isDisposed()) {
                display.asyncExec(() -> {
                    if (!this.isDisposed()) {
                        this.isStreaming = false;
                        if (!finalContent.isEmpty()) {
                            this.conversationHistory.add(LlmMessage.assistant((String)finalContent));
                            this.lastAssistantResponse = finalContent;
                            boolean hasCode = !CodeDiffUtils.extractCodeBlocks((String)finalContent).isEmpty();
                            this.applyCodeButton.setEnabled(hasCode);
                        }
                        this.setProcessing(false);
                    }
                });
            }
        } else if (chunk.isComplete() && this.streamingHandledToolCalls) {
            LOG.debug("Stream complete ignored - tool calls are being processed");
        }
    }

    private void startNonStreamingRequest(ILlmProvider provider, LlmRequest request, Display display) {
        LOG.debug("startNonStreamingRequest: using non-streaming mode");
        this.currentRequest = ((CompletableFuture)((CompletableFuture)provider.complete(request).thenCompose(response -> {
            LOG.debug("startConversationLoop: response received, hasToolCalls=%b", new Object[]{response.hasToolCalls()});
            if (!display.isDisposed()) {
                display.asyncExec(() -> {
                    if (!this.isDisposed()) {
                        if (response.hasToolCalls()) {
                            this.setProcessingStage("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432...");
                        } else {
                            this.setProcessingStage("\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430...");
                        }
                    }
                });
            }
            return this.handleResponseWithTools((LlmResponse)response, provider, 0);
        })).thenAccept(finalContent -> {
            LOG.debug("startConversationLoop: chain completed successfully");
            if (!display.isDisposed()) {
                display.asyncExec(() -> {
                    if (!this.isDisposed()) {
                        LOG.debug("startConversationLoop: calling setProcessing(false) from thenAccept");
                        this.setProcessing(false);
                    }
                });
            }
        })).exceptionally(error -> {
            LOG.error("startConversationLoop: error in chain: %s", new Object[]{error.getMessage()});
            if (!display.isDisposed()) {
                display.asyncExec(() -> {
                    if (!this.isDisposed()) {
                        this.handleError((Throwable)error);
                    }
                });
            }
            return null;
        });
        LOG.debug("startNonStreamingRequest: request sent asynchronously");
    }

    private LlmRequest buildRequestWithTools() {
        LlmRequest.Builder requestBuilder = LlmRequest.builder();
        requestBuilder.model(ModelService.getInstance().getSelectedModel());
        requestBuilder.systemMessage(this.getSystemPrompt());
        for (LlmMessage msg : this.conversationHistory) {
            requestBuilder.addMessage(msg);
        }
        if (this.toolsEnabled) {
            List tools = ToolRegistry.getInstance().getToolDefinitions();
            requestBuilder.tools(tools);
            requestBuilder.toolChoice(LlmRequest.ToolChoice.AUTO);
        }
        return requestBuilder.build();
    }

    private CompletableFuture<String> handleResponseWithTools(LlmResponse response, ILlmProvider provider, int iteration) {
        LOG.debug("handleResponseWithTools: iteration=%d, hasToolCalls=%b, finishReason=%s", new Object[]{iteration, response.hasToolCalls(), response.getFinishReason()});
        Display display = this.getDisplay();
        if (response.hasToolCalls() && iteration < 30) {
            LOG.debug("handleResponseWithTools: processing %d tool calls", new Object[]{response.getToolCalls().size()});
            return this.processToolCalls(response, provider, iteration, display);
        }
        if (response.hasToolCalls() && iteration >= 30) {
            LOG.warn("handleResponseWithTools: max iterations (%d) reached, stopping tool loop", new Object[]{30});
            if (!display.isDisposed()) {
                display.asyncExec(() -> {
                    if (!this.isDisposed()) {
                        this.appendSystemMessage(String.format("\u26a0\ufe0f \u0414\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043b\u0438\u043c\u0438\u0442 \u0438\u0442\u0435\u0440\u0430\u0446\u0438\u0439 (%d). \u0410\u0433\u0435\u043d\u0442 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0434\u043b\u044f \u043f\u0440\u0435\u0434\u043e\u0442\u0432\u0440\u0430\u0449\u0435\u043d\u0438\u044f \u0431\u0435\u0441\u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0433\u043e \u0446\u0438\u043a\u043b\u0430.", 30));
                    }
                });
            }
        }
        LOG.debug("handleResponseWithTools: final response (no tool calls or max iterations)");
        String content = response.getContent();
        LOG.debug("handleResponseWithTools: content length=%d, display.isDisposed=%b", new Object[]{content != null ? content.length() : 0, display.isDisposed()});
        if (!display.isDisposed()) {
            display.asyncExec(() -> {
                LOG.debug("handleResponseWithTools asyncExec: isDisposed=%b, content empty=%b", new Object[]{this.isDisposed(), content == null || content.isEmpty()});
                if (!this.isDisposed() && content != null && !content.isEmpty()) {
                    LOG.debug("handleResponseWithTools: appending assistant message, length=%d", new Object[]{content.length()});
                    this.appendAssistantMessage(content);
                    this.conversationHistory.add(LlmMessage.assistant((String)content));
                    this.lastAssistantResponse = content;
                    boolean hasCode = !CodeDiffUtils.extractCodeBlocks((String)content).isEmpty();
                    this.applyCodeButton.setEnabled(hasCode);
                    LOG.debug("handleResponseWithTools: message appended successfully");
                }
            });
        }
        return CompletableFuture.completedFuture(content);
    }

    private CompletableFuture<String> processToolCalls(LlmResponse response, ILlmProvider provider, int iteration, Display display) {
        LOG.debug("processToolCalls: starting with %d tool calls", new Object[]{response.getToolCalls().size()});
        List toolCalls = response.getToolCalls();
        String assistantContent = response.getContent();
        this.conversationHistory.add(LlmMessage.assistantWithToolCalls((String)assistantContent, (List)toolCalls));
        ArrayList<ToolCall> editCalls = new ArrayList<ToolCall>();
        ArrayList<ToolCall> otherCalls = new ArrayList<ToolCall>();
        for (ToolCall call : toolCalls) {
            if (this.shouldInterceptForPreview(call)) {
                editCalls.add(call);
                continue;
            }
            otherCalls.add(call);
        }
        String reasoningContent = response.hasReasoning() ? response.getReasoningContent() : assistantContent;
        int currentIteration = iteration;
        if (!display.isDisposed()) {
            display.asyncExec(() -> {
                if (!this.isDisposed()) {
                    StringBuilder toolNames = new StringBuilder();
                    int i = 0;
                    while (i < toolCalls.size()) {
                        if (i > 0) {
                            toolNames.append(", ");
                        }
                        toolNames.append(((ToolCall)toolCalls.get(i)).getName());
                        ++i;
                    }
                    this.setProcessingStage("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435: " + toolNames.toString());
                    if (this.browserChatPanel != null && this.browserChatPanel.isBrowserAvailable()) {
                        if (currentIteration > 0 && reasoningContent != null && !reasoningContent.trim().isEmpty()) {
                            this.browserChatPanel.addAssistantReasoningMessage(reasoningContent);
                        }
                        ArrayList<BrowserChatPanel.ToolCallDisplayData> toolCallCards = new ArrayList<BrowserChatPanel.ToolCallDisplayData>();
                        for (ToolCall call : toolCalls) {
                            BrowserChatPanel.ToolCallDisplayData cardData = new BrowserChatPanel.ToolCallDisplayData(call.getId(), call.getName(), call.getArguments());
                            cardData.setStatus(BrowserChatPanel.ToolCallStatus.RUNNING);
                            toolCallCards.add(cardData);
                        }
                        this.browserChatPanel.addToolCallCards(toolCallCards);
                    } else {
                        StringBuilder toolInfo = new StringBuilder();
                        toolInfo.append("\ud83d\udd27 \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u044b:\n");
                        for (ToolCall call : toolCalls) {
                            String suffix = this.shouldInterceptForPreview(call) ? " (\u043f\u0440\u0435\u0434\u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440)" : "";
                            toolInfo.append("\u2022 ").append(call.getName()).append(suffix).append("\n");
                        }
                        this.appendSystemMessage(toolInfo.toString().trim());
                    }
                }
            });
        }
        ProposedChangeSet proposedChanges = null;
        if (!editCalls.isEmpty()) {
            proposedChanges = new ProposedChangeSet(String.valueOf(System.currentTimeMillis()));
            for (ToolCall call : editCalls) {
                try {
                    ProposedChange change = this.createProposedChangeFromToolCall(call);
                    proposedChanges.addChange(change);
                }
                catch (Exception exception) {
                    otherCalls.add(call);
                }
            }
            this.currentProposedChanges = proposedChanges;
        }
        ToolRegistry registry = ToolRegistry.getInstance();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        ArrayList<ToolCall> executedCalls = new ArrayList<ToolCall>();
        for (ToolCall call : otherCalls) {
            ITool tool = registry.getTool(call.getName());
            executedCalls.add(call);
            if (tool != null && (tool.requiresConfirmation() || tool.isDestructive())) {
                CompletableFuture<ToolResult> confirmedFuture = new CompletableFuture<ToolResult>();
                if (display.isDisposed()) {
                    LOG.warn("Display disposed, skipping tool confirmation for %s", new Object[]{call.getName()});
                    confirmedFuture.complete(ToolResult.failure((String)"Display disposed"));
                } else {
                    display.asyncExec(() -> {
                        if (this.isDisposed()) {
                            confirmedFuture.complete(ToolResult.failure((String)"View disposed"));
                            return;
                        }
                        ToolConfirmationDialog dialog = new ToolConfirmationDialog(this.getShell(), call, tool.getDescription(), tool.isDestructive());
                        if (dialog.openAndConfirm()) {
                            ((CompletableFuture)registry.execute(call).thenAccept(confirmedFuture::complete)).exceptionally(e -> {
                                confirmedFuture.complete(ToolResult.failure((String)("Error: " + e.getMessage())));
                                return null;
                            });
                        } else if (dialog.wasSkipped()) {
                            confirmedFuture.complete(ToolResult.success((String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c", (ToolResult.ToolResultType)ToolResult.ToolResultType.CONFIRMATION));
                        } else {
                            confirmedFuture.complete(ToolResult.failure((String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c"));
                        }
                    });
                }
                futures.add(confirmedFuture);
                continue;
            }
            futures.add(registry.execute(call));
        }
        ProposedChangeSet capturedProposedChanges = proposedChanges;
        ArrayList<ToolCall> capturedEditCalls = editCalls;
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenCompose(v -> {
            HashMap<String, ToolResult> allResults = new HashMap<String, ToolResult>();
            int i = 0;
            while (i < executedCalls.size()) {
                ToolResult result;
                ToolCall call = (ToolCall)executedCalls.get(i);
                try {
                    result = (ToolResult)((CompletableFuture)futures.get(i)).join();
                }
                catch (Exception e) {
                    result = ToolResult.failure((String)("Error: " + e.getMessage()));
                }
                allResults.put(call.getId(), result);
                ++i;
            }
            if (capturedProposedChanges != null && !capturedProposedChanges.isEmpty() && capturedProposedChanges.hasActualChanges()) {
                CompletableFuture diffFuture = new CompletableFuture();
                if (display.isDisposed()) {
                    LOG.warn("Display disposed, skipping diff review");
                    HashMap<String, ToolResult> skipped = new HashMap<String, ToolResult>();
                    for (ToolCall call : capturedEditCalls) {
                        skipped.put(call.getId(), ToolResult.failure((String)"Display disposed"));
                    }
                    diffFuture.complete(skipped);
                } else {
                    display.asyncExec(() -> this.lambda$41(capturedEditCalls, diffFuture, capturedProposedChanges));
                }
                return diffFuture.thenCompose(diffResults -> {
                    allResults.putAll((Map<String, ToolResult>)diffResults);
                    return this.continueAfterToolCalls(toolCalls, allResults, provider, iteration, display);
                });
            }
            return this.continueAfterToolCalls(toolCalls, allResults, provider, iteration, display);
        });
    }

    private CompletableFuture<String> continueAfterToolCalls(List<ToolCall> toolCalls, Map<String, ToolResult> allResults, ILlmProvider provider, int iteration, Display display) {
        LOG.debug("continueAfterToolCalls: %d tool calls, %d results, iteration=%d", new Object[]{toolCalls.size(), allResults.size(), iteration});
        for (ToolCall call : toolCalls) {
            ToolResult result = allResults.get(call.getId());
            if (result == null) {
                result = ToolResult.failure((String)"\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            Object resultContent = result.isSuccess() ? result.getContent() : "Error: " + result.getErrorMessage();
            this.conversationHistory.add(LlmMessage.toolResult((String)call.getId(), (String)resultContent));
        }
        if (!display.isDisposed()) {
            display.asyncExec(() -> {
                if (!this.isDisposed()) {
                    for (ToolCall call : toolCalls) {
                        ToolResult result = (ToolResult)allResults.get(call.getId());
                        if (result == null) continue;
                        this.updateToolCallCardWithResult(call, result);
                    }
                }
            });
        }
        LOG.debug("continueAfterToolCalls: sending next request to LLM");
        if (!display.isDisposed()) {
            display.asyncExec(() -> {
                if (!this.isDisposed()) {
                    this.setProcessingStage("\u041e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u0430 \u043c\u043e\u0434\u0435\u043b\u0438...");
                }
            });
        }
        LlmRequest nextRequest = this.buildRequestWithTools();
        return provider.complete(nextRequest).thenCompose(nextResponse -> {
            LOG.debug("continueAfterToolCalls: got next response, hasToolCalls=%b", new Object[]{nextResponse.hasToolCalls()});
            if (!display.isDisposed()) {
                display.asyncExec(() -> {
                    if (!this.isDisposed()) {
                        if (nextResponse.hasToolCalls()) {
                            this.setProcessingStage("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432...");
                        } else {
                            this.setProcessingStage("\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430...");
                        }
                    }
                });
            }
            return this.handleResponseWithTools((LlmResponse)nextResponse, provider, iteration + 1);
        });
    }

    private void updateToolCallCardWithResult(ToolCall call, ToolResult result) {
        if (this.browserChatPanel != null && this.browserChatPanel.isBrowserAvailable()) {
            int len;
            String content;
            BrowserChatPanel.ToolCallStatus status = result.isSuccess() ? BrowserChatPanel.ToolCallStatus.SUCCESS : BrowserChatPanel.ToolCallStatus.ERROR;
            String string = content = result.isSuccess() ? result.getContent() : result.getErrorMessage();
            String resultSummary = result.isSuccess() && content != null ? ((len = content.length()) >= 1000 ? String.format("%,d \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432", len) : String.format("%d \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432", len)) : (!result.isSuccess() ? "\u041e\u0448\u0438\u0431\u043a\u0430" : "\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e");
            Object resultPreview = "";
            if (content != null && !content.isEmpty()) {
                resultPreview = content.length() > 200 ? content.substring(0, 200) + "..." : content;
            }
            this.browserChatPanel.updateToolCallResult(call.getId(), status, resultSummary, (String)resultPreview);
        } else {
            this.appendToolResultMessage(call, result);
        }
    }

    private void appendToolResultMessage(ToolCall call, ToolResult result) {
        Object content;
        if (this.messagesContainer == null || this.messagesContainer.isDisposed()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        String icon = result.isSuccess() ? "\u2713" : "\u2717";
        sb.append(icon).append(" **").append(this.getToolDisplayName(call.getName())).append("**\n\n");
        Object object = content = result.isSuccess() ? result.getContent() : result.getErrorMessage();
        if (content != null && !((String)content).isEmpty()) {
            if (((String)content).length() > 1500) {
                content = ((String)content).substring(0, 1500) + "\n... (\u043e\u0431\u0440\u0435\u0437\u0430\u043d\u043e)";
            }
            sb.append((String)content);
        }
        this.appendMessage("\u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442", sb.toString(), false);
    }

    private boolean shouldInterceptForPreview(ToolCall call) {
        return this.previewModeEnabled && "edit_file".equals(call.getName());
    }

    private Map<String, Object> parseToolArguments(String json) {
        if (json == null || json.isEmpty() || "{}".equals(json)) {
            return new HashMap<String, Object>();
        }
        try {
            Gson gson = new Gson();
            Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
            Map result = (Map)gson.fromJson(json, mapType);
            return result != null ? result : new HashMap();
        }
        catch (Exception exception) {
            return new HashMap<String, Object>();
        }
    }

    private ProposedChange createProposedChangeFromToolCall(ToolCall call) {
        ProposedChange.ChangeKind kind;
        String afterContent;
        Map<String, Object> args = this.parseToolArguments(call.getArguments());
        String filePath = (String)args.get("path");
        if (filePath == null) {
            filePath = (String)args.get("file_path");
        }
        String newContent = (String)args.get("content");
        String oldString = (String)args.get("old_string");
        String newString = (String)args.get("new_string");
        String beforeContent = this.readFileContent(filePath);
        if (beforeContent == null) {
            afterContent = newContent != null ? newContent : newString;
            kind = ProposedChange.ChangeKind.CREATE;
        } else if (oldString != null && newString != null) {
            afterContent = beforeContent.replace(oldString, newString);
            kind = ProposedChange.ChangeKind.MODIFY;
        } else if (newContent != null) {
            afterContent = newContent;
            kind = ProposedChange.ChangeKind.REPLACE;
        } else {
            afterContent = beforeContent;
            kind = ProposedChange.ChangeKind.MODIFY;
        }
        return new ProposedChange(filePath, beforeContent, afterContent, kind, call.getId());
    }

    private String readFileContent(String filePath) {
        if (filePath == null) {
            return null;
        }
        try {
            IFile file;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String normalized = filePath;
            if (normalized.startsWith("/") && !normalized.startsWith("//")) {
                normalized = normalized.substring(1);
            }
            if ((file = root.getFile(Path.fromPortableString((String)(normalized = normalized.replace('\\', '/'))))).exists()) {
                Throwable throwable = null;
                Object var6_7 = null;
                try (InputStream is = file.getContents();){
                    return new String(is.readAllBytes(), StandardCharsets.UTF_8);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private Map<String, ToolResult> showDiffReviewAndApply(ProposedChangeSet changeSet) {
        HashMap<String, ToolResult> results = new HashMap<String, ToolResult>();
        if (changeSet == null || changeSet.isEmpty()) {
            return results;
        }
        DiffReviewDialog dialog = new DiffReviewDialog(this.getShell(), changeSet);
        dialog.openAndApply();
        for (ProposedChange change : changeSet.getChanges()) {
            ToolResult result = switch (change.getStatus()) {
                case ProposedChange.ChangeStatus.APPLIED -> ToolResult.success((String)String.format("\u0424\u0430\u0439\u043b %s \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0451\u043d", change.getFileName()), (ToolResult.ToolResultType)ToolResult.ToolResultType.CONFIRMATION);
                case ProposedChange.ChangeStatus.REJECTED -> ToolResult.success((String)String.format("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 %s \u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c", change.getFileName()), (ToolResult.ToolResultType)ToolResult.ToolResultType.CONFIRMATION);
                case ProposedChange.ChangeStatus.FAILED -> ToolResult.failure((String)String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043a %s", change.getFileName()));
                default -> ToolResult.success((String)String.format("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 %s \u043e\u0436\u0438\u0434\u0430\u0435\u0442 \u0440\u0430\u0441\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u0438\u044f", change.getFileName()), (ToolResult.ToolResultType)ToolResult.ToolResultType.CONFIRMATION);
            };
            if (change.getToolCallId() == null) continue;
            results.put(change.getToolCallId(), result);
        }
        return results;
    }

    private String getToolDisplayName(String name) {
        return switch (name) {
            case "read_file" -> "\u0427\u0442\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430";
            case "edit_file" -> "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430";
            case "list_files" -> "\u0421\u043f\u0438\u0441\u043e\u043a \u0444\u0430\u0439\u043b\u043e\u0432";
            case "grep" -> "\u041f\u043e\u0438\u0441\u043a \u0442\u0435\u043a\u0441\u0442\u0430";
            case "search_codebase" -> "\u041f\u043e\u0438\u0441\u043a \u043f\u043e \u043a\u043e\u0434\u0443";
            default -> name;
        };
    }

    private boolean isDisposed() {
        return this.browserChatPanel == null || this.browserChatPanel.isDisposed();
    }

    private Shell getShell() {
        if (this.browserChatPanel != null && !this.browserChatPanel.isDisposed()) {
            return this.browserChatPanel.getShell();
        }
        if (this.scrolledComposite != null && !this.scrolledComposite.isDisposed()) {
            return this.scrolledComposite.getShell();
        }
        if (this.getSite() != null && this.getSite().getShell() != null && !this.getSite().getShell().isDisposed()) {
            return this.getSite().getShell();
        }
        return Display.getDefault().getActiveShell();
    }

    private Display getDisplay() {
        if (this.browserChatPanel != null && !this.browserChatPanel.isDisposed()) {
            return this.browserChatPanel.getDisplay();
        }
        if (this.scrolledComposite != null && !this.scrolledComposite.isDisposed()) {
            return this.scrolledComposite.getDisplay();
        }
        return Display.getDefault();
    }

    private String getSystemPrompt() {
        String workspacePath = "";
        try {
            workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        }
        catch (Exception exception) {
            workspacePath = "/\u043f\u0443\u0442\u044c/\u043a/workspace";
        }
        Session session = this.getCurrentSession();
        String sessionPrompt = session != null ? session.getSystemPrompt() : null;
        String basePrompt = SystemPromptBuilder.buildChatSystemPrompt((boolean)this.toolsEnabled, (String)workspacePath, (String)sessionPrompt);
        return PromptTemplateService.getInstance().applySystemPrompt(basePrompt);
    }

    private String buildMessageWithContext(String userMessage, CodeApplicationService.SelectionInfo editorContext) {
        StringBuilder sb = new StringBuilder();
        if (editorContext != null && editorContext.hasDocument()) {
            Object docText;
            sb.append("### \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0444\u0430\u0439\u043b \u0432 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0435\n\n");
            if (editorContext.getFileName() != null) {
                String fileName = editorContext.getFileName();
                sb.append("**\u0424\u0430\u0439\u043b:** `").append(fileName).append("`\n");
                int srcIndex = fileName.indexOf("/src/");
                if (srcIndex > 0) {
                    String projectRoot = fileName.substring(0, srcIndex);
                    String projectSrcPath = projectRoot + "/src";
                    sb.append("**\u041a\u043e\u0440\u0435\u043d\u044c \u043f\u0440\u043e\u0435\u043a\u0442\u0430:** `").append(projectRoot).append("`\n");
                    sb.append("**\u041f\u0443\u0442\u044c \u043a \u0438\u0441\u0445\u043e\u0434\u043d\u0438\u043a\u0430\u043c:** `").append(projectSrcPath).append("`\n");
                }
                sb.append("\n");
            }
            if (editorContext.hasSelection() && editorContext.getSelectedText() != null) {
                sb.append("**\u0412\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 \u043a\u043e\u0434:**\n```bsl\n");
                sb.append(editorContext.getSelectedText());
                sb.append("\n```\n\n");
            }
            if ((docText = editorContext.getDocumentText()) != null && !((String)docText).isEmpty()) {
                int maxLength = 6000;
                if (((String)docText).length() > maxLength) {
                    if (editorContext.hasSelection()) {
                        int start = Math.max(0, editorContext.getOffset() - maxLength / 2);
                        int end = Math.min(((String)docText).length(), editorContext.getOffset() + editorContext.getLength() + maxLength / 2);
                        docText = "...\n" + ((String)docText).substring(start, end) + "\n...";
                    } else {
                        docText = ((String)docText).substring(0, maxLength) + "\n... (\u0444\u0430\u0439\u043b \u043e\u0431\u0440\u0435\u0437\u0430\u043d)";
                    }
                }
                sb.append("**\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0444\u0430\u0439\u043b\u0430:**\n```bsl\n");
                sb.append((String)docText);
                sb.append("\n```\n\n");
            }
        }
        sb.append("### \u0412\u043e\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\n\n");
        sb.append(userMessage);
        return sb.toString();
    }

    private void handleError(Throwable error) {
        Throwable cause;
        LOG.error("handleError: %s", new Object[]{error.getMessage()});
        if (error.getCause() != null) {
            LOG.error("handleError cause: %s", new Object[]{error.getCause().getMessage()});
        }
        Throwable throwable = cause = error.getCause() != null ? error.getCause() : error;
        if (cause instanceof LlmProviderException) {
            LlmProviderException lpe = (LlmProviderException)cause;
            if (lpe.isBudgetExceeded()) {
                this.appendSystemMessage("\u0411\u044e\u0434\u0436\u0435\u0442 \u0438\u0441\u0447\u0435\u0440\u043f\u0430\u043d. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443 \u0438\u043b\u0438 \u0434\u043e\u0436\u0434\u0438\u0442\u0435\u0441\u044c \u0441\u0431\u0440\u043e\u0441\u0430.");
                VibeStateService.getInstance().setBudgetExceeded("\u0411\u044e\u0434\u0436\u0435\u0442 \u0438\u0441\u0447\u0435\u0440\u043f\u0430\u043d");
                this.setProcessing(false);
                return;
            }
            if (lpe.isRateLimitError()) {
                this.appendSystemMessage("\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432. \u041f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435 \u043d\u0435\u043c\u043d\u043e\u0433\u043e.");
                this.setProcessing(false);
                return;
            }
            if (lpe.isAuthenticationError()) {
                this.appendSystemMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430.");
                this.setProcessing(false);
                return;
            }
        }
        String message = cause.getMessage();
        this.appendSystemMessage(MessageFormat.format(Messages.ChatView_ErrorMessage, message));
        LOG.debug("handleError: calling setProcessing(false)");
        this.setProcessing(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyCodeToEditor() {
        boolean replaceSelection;
        String[] stringArray;
        boolean hasSelection;
        if (this.lastAssistantResponse == null || this.lastAssistantResponse.isEmpty()) {
            return;
        }
        CodeApplicationService codeService = CodeApplicationService.getInstance();
        CodeApplicationService.SelectionInfo selection = codeService.getCurrentSelection();
        boolean bl = hasSelection = selection != null && selection.hasSelection();
        if (hasSelection) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = Messages.ChatView_ReplaceSelection;
            stringArray2[1] = Messages.ChatView_InsertAtCursor;
            stringArray = stringArray2;
            stringArray2[2] = Messages.ChatView_Cancel;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = Messages.ChatView_InsertAtCursor;
            stringArray = stringArray3;
            stringArray3[1] = Messages.ChatView_Cancel;
        }
        String[] buttons = stringArray;
        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.ChatView_ApplyCodeTitle, null, Messages.ChatView_ApplyCodeMessage, 3, buttons, 0);
        int result = dialog.open();
        if (hasSelection) {
            if (result == 0) {
                replaceSelection = true;
            } else {
                if (result != 1) return;
                replaceSelection = false;
            }
        } else {
            if (result != 0) return;
            replaceSelection = false;
        }
        boolean success = codeService.applyFromResponse(this.lastAssistantResponse, replaceSelection);
        if (success) {
            this.appendSystemMessage(Messages.ChatView_CodeAppliedSuccess);
            return;
        } else {
            this.appendSystemMessage(Messages.ChatView_CodeAppliedFailed);
        }
    }

    private void stopGeneration() {
        if (this.currentRequest != null && !this.currentRequest.isDone()) {
            this.currentRequest.cancel(true);
            ILlmProvider provider = LlmProviderRegistry.getInstance().getActiveProvider();
            if (provider != null) {
                provider.cancel();
            }
        }
        this.setProcessing(false);
    }

    private void clearChat() {
        this.clearChatBrowser();
        this.conversationHistory.clear();
        this.lastAssistantResponse = null;
        this.currentSession = this.sessionManager.startNewSession();
        this.updateSessionPromptButtonState();
        if (!this.isDisposed()) {
            this.applyCodeButton.setEnabled(false);
        }
        this.appendSystemMessage(Messages.ChatView_WelcomeMessage);
    }

    private void clearChatBrowser() {
        if (this.browserChatPanel != null && !this.browserChatPanel.isDisposed()) {
            this.browserChatPanel.clearChat();
        }
    }

    private void clearChatStyledText() {
        for (ChatMessageComposite widget : this.messageWidgets) {
            if (widget.isDisposed()) continue;
            widget.dispose();
        }
        this.messageWidgets.clear();
        if (this.messagesContainer != null && !this.messagesContainer.isDisposed()) {
            Control[] controlArray = this.messagesContainer.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (!child.isDisposed() && child != this.typingIndicator) {
                    child.dispose();
                }
                ++n2;
            }
            if (this.typingIndicator != null && !this.typingIndicator.isDisposed()) {
                this.typingIndicator.hide();
            }
            this.messagesContainer.layout(true, true);
            this.updateScrollSize();
        }
    }

    private void setProcessing(boolean processing) {
        this.setProcessing(processing, null);
    }

    private void setProcessing(boolean processing, String stage) {
        LOG.debug("setProcessing: changing from %b to %b, stage=%s", new Object[]{this.isProcessing, processing, stage});
        this.isProcessing = processing;
        if (!this.isDisposed()) {
            this.sendButton.setEnabled(!processing);
            this.stopButton.setEnabled(processing);
            this.inputField.setEnabled(!processing);
            if (this.browserChatPanel != null && this.browserChatPanel.isBrowserAvailable()) {
                this.browserChatPanel.showTypingIndicator(processing, stage);
            }
        }
    }

    private void setProcessingStage(String stage) {
        if (!this.isDisposed() && this.isProcessing && this.browserChatPanel != null && this.browserChatPanel.isBrowserAvailable()) {
            this.browserChatPanel.setProcessingStage(stage);
        }
    }

    private void appendUserMessage(String message) {
        this.appendMessage("\u0412\u044b", message, false);
    }

    private void appendAssistantMessage(String message) {
        this.appendMessage("AI", message, true);
    }

    private void appendSystemMessage(String message) {
        this.appendMessage("\u0421\u0438\u0441\u0442\u0435\u043c\u0430", message, false);
    }

    private void appendMessage(String sender, String message, boolean isAssistant) {
        this.appendMessageBrowser(sender, message, isAssistant);
    }

    private void appendMessageBrowser(String sender, String message, boolean isAssistant) {
        LOG.debug("appendMessageBrowser: sender=%s, isAssistant=%b, messageLength=%d", new Object[]{sender, isAssistant, message != null ? message.length() : 0});
        if (this.browserChatPanel == null || this.browserChatPanel.isDisposed()) {
            LOG.warn("appendMessageBrowser: browserChatPanel is null or disposed");
            return;
        }
        boolean isSystem = "\u0421\u0438\u0441\u0442\u0435\u043c\u0430".equals(sender) || "System".equals(sender);
        this.browserChatPanel.addMessage(sender, message, isAssistant, isSystem);
        LOG.debug("appendMessageBrowser: message added to browserChatPanel");
    }

    private void appendMessageStyledText(String sender, String message, boolean isAssistant) {
        if (this.messagesContainer == null || this.messagesContainer.isDisposed()) {
            return;
        }
        ChatMessageComposite messageWidget = new ChatMessageComposite(this.messagesContainer, sender, message, isAssistant);
        messageWidget.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.messageWidgets.add(messageWidget);
        if (this.typingIndicator != null && !this.typingIndicator.isDisposed() && this.typingIndicator.isShowing()) {
            this.typingIndicator.moveBelow(null);
        }
        this.messagesContainer.layout(true, true);
        this.updateScrollSize();
        this.scrollToBottom();
    }

    public void sendProgrammaticMessage(String message) {
        this.inputField.setText(message);
        this.sendMessage();
    }

    public void sendMessage(String prompt) {
        this.sendProgrammaticMessage(prompt);
    }

    public boolean isPreviewModeEnabled() {
        return this.previewModeEnabled;
    }

    public void setPreviewModeEnabled(boolean enabled) {
        this.previewModeEnabled = enabled;
    }

    public ProposedChangeSet getCurrentProposedChanges() {
        return this.currentProposedChanges;
    }

    public void setFocus() {
        this.inputField.setFocus();
    }

    private void installMouseWheelScrolling(ScrolledComposite scrollable, Composite content) {
        this.mouseWheelScroller = e -> {
            if (scrollable.isDisposed()) {
                return;
            }
            Point origin = scrollable.getOrigin();
            int scrollAmount = e.count * 25;
            int newY = Math.max(0, origin.y - scrollAmount);
            scrollable.setOrigin(origin.x, newY);
        };
        scrollable.addMouseWheelListener(this.mouseWheelScroller);
        this.installMouseWheelRecursively((Control)content);
        content.addListener(11, e -> {
            Control[] controlArray = content.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child.getData("wheelListenerInstalled") == null) {
                    this.installMouseWheelRecursively(child);
                }
                ++n2;
            }
        });
    }

    private void installMouseWheelRecursively(Control control) {
        if (control == null || control.isDisposed() || this.mouseWheelScroller == null) {
            return;
        }
        if (control.getData("wheelListenerInstalled") != null) {
            return;
        }
        control.addMouseWheelListener(this.mouseWheelScroller);
        control.setData("wheelListenerInstalled", (Object)Boolean.TRUE);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.installMouseWheelRecursively(child);
                ++n2;
            }
        }
    }

    public void dispose() {
        if (this.currentRequest != null && !this.currentRequest.isDone()) {
            this.currentRequest.cancel(true);
        }
        this.conversationHistory.clear();
        if (this.themeChangeListener != null) {
            ThemeManager.getInstance().removeThemeChangeListener(this.themeChangeListener);
            this.themeChangeListener = null;
        }
        if (this.typingIndicator != null && !this.typingIndicator.isDisposed()) {
            this.typingIndicator.dispose();
        }
        for (ChatMessageComposite widget : this.messageWidgets) {
            if (widget.isDisposed()) continue;
            widget.dispose();
        }
        this.messageWidgets.clear();
        super.dispose();
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$41(List var1_1, CompletableFuture var2_2, ProposedChangeSet var3_3) {
        block5: {
            if (this.isDisposed()) {
                skipped = new HashMap<String, ToolResult>();
                for (ToolCall call : var1_1) {
                    skipped.put(call.getId(), ToolResult.failure((String)"View disposed"));
                }
                var2_2.complete(skipped);
                return;
            }
            try {
                diffResults = this.showDiffReviewAndApply(var3_3);
                var2_2.complete(diffResults);
                break block5;
            }
            catch (Exception e) {
                ChatView.LOG.error("Error showing diff review: %s", new Object[]{e.getMessage()});
                errors = new HashMap<String, ToolResult>();
                ** for (call : var1_1)
            }
lbl-1000:
            // 1 sources

            {
                errors.put(call.getId(), ToolResult.failure((String)("Error: " + e.getMessage())));
                continue;
            }
lbl22:
            // 1 sources

            var2_2.complete(errors);
        }
    }
}

