/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.views;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.ui.internal.VibeUiPlugin;
import com.example.vibe.ui.markdown.FlexmarkParser;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class BrowserChatPanel
extends Composite {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(BrowserChatPanel.class);
    private static final String CSS_RESOURCE = "/resources/chat.css";
    private static final String JS_RESOURCE = "/resources/chat.js";
    private static String cachedCss;
    private static String cachedJs;
    private final Browser browser;
    private final FlexmarkParser markdownParser;
    private final List<ChatMessageData> messages = new ArrayList<ChatMessageData>();
    private BrowserFunction copyFunction;
    private BrowserFunction openUrlFunction;
    private BrowserFunction applyCodeFunction;
    private boolean browserReady = false;
    private String pendingThemeClass;
    private ApplyCodeCallback applyCodeCallback;
    private boolean typingIndicatorVisible = false;
    private String typingIndicatorStage;
    private final Map<String, ToolCallDisplayData> activeToolCalls = new HashMap<String, ToolCallDisplayData>();

    public BrowserChatPanel(Composite parent) {
        super(parent, 0);
        this.markdownParser = new FlexmarkParser();
        this.setLayout((Layout)new FillLayout());
        Browser tempBrowser = null;
        try {
            tempBrowser = new Browser((Composite)this, 262144);
        }
        catch (SWTError sWTError) {
            try {
                tempBrowser = new Browser((Composite)this, 0);
            }
            catch (SWTError e2) {
                VibeUiPlugin.log(e2);
            }
        }
        this.browser = tempBrowser;
        if (this.browser != null) {
            this.setupBrowser();
            this.initializeHtml();
        }
    }

    private void setupBrowser() {
        this.browser.addMenuDetectListener(e -> {
            boolean bl = e.doit = false;
        });
        this.copyFunction = new BrowserFunction(this.browser, "copyToClipboard"){

            public Object function(Object[] arguments) {
                if (arguments.length > 0 && arguments[0] instanceof String) {
                    BrowserChatPanel.this.copyToClipboard((String)arguments[0]);
                }
                return null;
            }
        };
        this.openUrlFunction = new BrowserFunction(this.browser, "openUrl"){

            public Object function(Object[] arguments) {
                if (arguments.length > 0 && arguments[0] instanceof String) {
                    BrowserChatPanel.this.openExternalUrl((String)arguments[0]);
                }
                return null;
            }
        };
        this.applyCodeFunction = new BrowserFunction(this.browser, "applyCode"){

            public Object function(Object[] arguments) {
                if (BrowserChatPanel.this.applyCodeCallback != null && arguments.length >= 3) {
                    String code = arguments[0] instanceof String ? (String)arguments[0] : "";
                    String language = arguments[1] instanceof String ? (String)arguments[1] : "";
                    String filePath = arguments[2] instanceof String ? (String)arguments[2] : "";
                    Display.getDefault().asyncExec(() -> BrowserChatPanel.this.applyCodeCallback.apply(code, language, filePath));
                }
                return null;
            }
        };
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                BrowserChatPanel.this.browserReady = true;
                BrowserChatPanel.this.applyThemeClassIfReady();
                BrowserChatPanel.this.applyTypingIndicatorState();
            }
        });
    }

    private void initializeHtml() {
        String html = this.buildHtmlDocument("");
        this.browser.setText(html);
    }

    public void addMessage(String sender, String content, boolean isAssistant) {
        this.addMessage(sender, content, isAssistant, false);
    }

    public void addMessage(String sender, String content, boolean isAssistant, boolean isSystem) {
        LOG.debug("addMessage: sender=%s, isAssistant=%b, isSystem=%b, contentLength=%d", new Object[]{sender, isAssistant, isSystem, content != null ? content.length() : 0});
        ChatMessageData msg = new ChatMessageData(sender, content, isAssistant, isSystem);
        this.messages.add(msg);
        LOG.debug("addMessage: browserReady=%b, browser=%s, disposed=%b", new Object[]{this.browserReady, this.browser != null ? "not null" : "null", this.browser != null && this.browser.isDisposed()});
        if (this.browserReady && this.browser != null && !this.browser.isDisposed()) {
            String messageHtml = this.buildMessageHtml(msg);
            LOG.debug("addMessage: messageHtml length=%d", new Object[]{messageHtml.length()});
            String escapedHtml = this.escapeForJs(messageHtml);
            LOG.debug("addMessage: escapedHtml length=%d", new Object[]{escapedHtml.length()});
            String jsCode = "var container = document.getElementById('messages');if (container) {  container.insertAdjacentHTML('beforeend', '" + escapedHtml + "');  scrollToBottom();  if (typeof hljs !== 'undefined') { hljs.highlightAll(); }}console.log('Message added, container:', container ? 'found' : 'NOT FOUND');";
            boolean success = this.browser.execute(jsCode);
            LOG.debug("addMessage: browser.execute returned %b", new Object[]{success});
            if (!success) {
                LOG.warn("addMessage: browser.execute failed! Falling back to renderAllMessages");
                this.renderAllMessages();
            }
        } else {
            LOG.debug("addMessage: browser not ready, calling renderAllMessages");
            this.renderAllMessages();
        }
    }

    public void updateLastMessage(String content) {
        if (this.messages.isEmpty()) {
            return;
        }
        ChatMessageData lastMsg = this.messages.get(this.messages.size() - 1);
        ChatMessageData updated = new ChatMessageData(lastMsg.sender, content, lastMsg.isAssistant, lastMsg.isSystem);
        this.messages.set(this.messages.size() - 1, updated);
        if (this.browserReady && this.browser != null && !this.browser.isDisposed()) {
            String messageHtml = this.buildMessageContentHtml(content);
            String escapedHtml = this.escapeForJs(messageHtml);
            this.browser.execute("var lastMsg = document.querySelector('.message:last-child .message-content');if (lastMsg) {  lastMsg.innerHTML = '" + escapedHtml + "';  scrollToBottom();  if (typeof hljs !== 'undefined') { hljs.highlightAll(); }}");
        }
    }

    public void updateLastMessageWithReasoning(String content, String reasoning) {
        if (this.messages.isEmpty()) {
            return;
        }
        ChatMessageData lastMsg = this.messages.get(this.messages.size() - 1);
        ChatMessageData updated = new ChatMessageData(lastMsg.sender, content, lastMsg.isAssistant, lastMsg.isSystem, reasoning);
        this.messages.set(this.messages.size() - 1, updated);
        if (this.browserReady && this.browser != null && !this.browser.isDisposed()) {
            String reasoningHtml = "";
            if (reasoning != null && !reasoning.isEmpty()) {
                reasoningHtml = this.buildReasoningBlock(reasoning);
            }
            String contentHtml = content != null ? this.buildMessageContentHtml(content) : "";
            String script = String.format("updateMessageWithReasoning('%s', '%s')", this.escapeForJs(reasoningHtml), this.escapeForJs(contentHtml));
            this.browser.execute(script);
        }
    }

    private String buildReasoningBlock(String reasoning) {
        return this.buildReasoningBlock(reasoning, false);
    }

    private String buildReasoningBlock(String reasoning, boolean expanded) {
        String escapedReasoning = this.escapeHtml(reasoning).replace("\n", "<br>");
        String reasoningClass = expanded ? "reasoning-block expanded" : "reasoning-block";
        return "<div class=\"" + reasoningClass + "\"><div class=\"reasoning-header\" onclick=\"toggleReasoning(this)\"><span class=\"reasoning-chevron\">\u25b6</span><span class=\"reasoning-title\">\ud83d\udcad \u0425\u043e\u0434 \u0440\u0430\u0441\u0441\u0443\u0436\u0434\u0435\u043d\u0438\u0439</span></div><div class=\"reasoning-content\">" + escapedReasoning + "</div></div>";
    }

    public void showTypingIndicator(boolean show) {
        this.showTypingIndicator(show, null);
    }

    public void showTypingIndicator(boolean show, String stage) {
        if (this.browser == null || this.browser.isDisposed()) {
            return;
        }
        this.typingIndicatorVisible = show;
        this.typingIndicatorStage = stage;
        if (!this.browserReady) {
            return;
        }
        if (show) {
            String stageText = stage != null && !stage.isEmpty() ? this.escapeForJs(stage) : "AI \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442 \u0437\u0430\u043f\u0440\u043e\u0441";
            this.browser.execute("var indicator = document.getElementById('typing-indicator');var stageText = document.getElementById('typing-stage');if (indicator) {  indicator.style.display = 'flex';  if (stageText) stageText.textContent = '" + stageText + "';}scrollToBottom();");
        } else {
            this.browser.execute("var indicator = document.getElementById('typing-indicator');if (indicator) indicator.style.display = 'none';");
        }
    }

    public void setProcessingStage(String stage) {
        if (this.browser == null || this.browser.isDisposed()) {
            return;
        }
        if (stage == null || stage.isEmpty()) {
            return;
        }
        this.typingIndicatorStage = stage;
        if (!this.browserReady) {
            return;
        }
        String stageText = this.escapeForJs(stage);
        this.browser.execute("var stageText = document.getElementById('typing-stage');if (stageText) stageText.textContent = '" + stageText + "';");
    }

    public void clearChat() {
        this.messages.clear();
        this.activeToolCalls.clear();
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.execute("var container = document.getElementById('messages');if (container) container.innerHTML = '';");
        }
    }

    public void renderAllMessages() {
        if (this.browser == null || this.browser.isDisposed()) {
            return;
        }
        StringBuilder messagesHtml = new StringBuilder();
        for (ChatMessageData msg : this.messages) {
            messagesHtml.append(this.buildMessageHtml(msg));
        }
        String html = this.buildHtmlDocument(messagesHtml.toString());
        this.browser.setText(html);
    }

    private void applyTypingIndicatorState() {
        if (this.browser == null || this.browser.isDisposed() || !this.browserReady) {
            return;
        }
        if (this.typingIndicatorVisible) {
            String stageText = this.typingIndicatorStage != null && !this.typingIndicatorStage.isEmpty() ? this.escapeForJs(this.typingIndicatorStage) : "AI \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442 \u0437\u0430\u043f\u0440\u043e\u0441";
            this.browser.execute("var indicator = document.getElementById('typing-indicator');var stageText = document.getElementById('typing-stage');if (indicator) {  indicator.style.display = 'flex';  if (stageText) stageText.textContent = '" + stageText + "';}scrollToBottom();");
        } else {
            this.browser.execute("var indicator = document.getElementById('typing-indicator');if (indicator) indicator.style.display = 'none';");
        }
    }

    public void updateTheme(boolean isDark) {
        this.pendingThemeClass = isDark ? "dark" : "light";
        this.applyThemeClassIfReady();
        Display display = this.getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(() -> {
                if (this.isDisposed()) {
                    return;
                }
                this.pendingThemeClass = this.resolveThemeClass();
                this.applyThemeClassIfReady();
            });
        }
    }

    public void setApplyCodeCallback(ApplyCodeCallback callback) {
        this.applyCodeCallback = callback;
    }

    public boolean isBrowserAvailable() {
        return this.browser != null && !this.browser.isDisposed() && this.browserReady;
    }

    public void addToolCallCard(ToolCallDisplayData toolCall) {
        if (this.browser == null || this.browser.isDisposed() || !this.browserReady) {
            LOG.warn("addToolCallCard: browser not ready");
            return;
        }
        this.activeToolCalls.put(toolCall.getId(), toolCall);
        String cardHtml = this.buildToolCallCardHtml(toolCall);
        String escapedHtml = this.escapeForJs(cardHtml);
        String jsCode = "var container = document.getElementById('messages');if (container) {  container.insertAdjacentHTML('beforeend', '" + escapedHtml + "');  scrollToBottom();}";
        boolean success = this.browser.execute(jsCode);
        if (!success) {
            LOG.warn("addToolCallCard: browser.execute failed");
        }
    }

    public void addToolCallCards(List<ToolCallDisplayData> toolCalls) {
        if (this.browser == null || this.browser.isDisposed() || !this.browserReady) {
            LOG.warn("addToolCallCards: browser not ready");
            return;
        }
        StringBuilder allCardsHtml = new StringBuilder();
        for (ToolCallDisplayData toolCall : toolCalls) {
            this.activeToolCalls.put(toolCall.getId(), toolCall);
            allCardsHtml.append(this.buildToolCallCardHtml(toolCall));
        }
        String escapedHtml = this.escapeForJs(allCardsHtml.toString());
        String jsCode = "var container = document.getElementById('messages');if (container) {  container.insertAdjacentHTML('beforeend', '" + escapedHtml + "');  scrollToBottom();}";
        boolean success = this.browser.execute(jsCode);
        if (!success) {
            LOG.warn("addToolCallCards: browser.execute failed");
        }
    }

    public void updateToolCallResult(String toolCallId, ToolCallStatus status, String resultSummary, String resultPreview) {
        if (this.browser == null || this.browser.isDisposed() || !this.browserReady) {
            LOG.warn("updateToolCallResult: browser not ready");
            return;
        }
        ToolCallDisplayData toolCall = this.activeToolCalls.get(toolCallId);
        if (toolCall != null) {
            toolCall.setStatus(status);
            toolCall.setResultSummary(resultSummary);
            toolCall.setResultPreview(resultPreview);
        }
        String escapedSummary = this.escapeForJs(resultSummary != null ? resultSummary : "");
        String escapedPreview = this.escapeForJs(resultPreview != null ? resultPreview : "");
        String jsCode = String.format("updateToolCallCard('%s', '%s', '%s', '%s', '%s');", this.escapeForJs(toolCallId), status.cssClass, this.escapeForJs(status.icon), escapedSummary, escapedPreview);
        boolean success = this.browser.execute(jsCode);
        if (!success) {
            LOG.warn("updateToolCallResult: browser.execute failed for %s", new Object[]{toolCallId});
        }
    }

    public void addReasoningBlock(String reasoning) {
        this.addAssistantReasoningMessage(reasoning);
    }

    public void addAssistantReasoningMessage(String reasoning) {
        if (reasoning == null || reasoning.isEmpty()) {
            return;
        }
        ChatMessageData msg = new ChatMessageData("AI", "", true, false, reasoning);
        this.messages.add(msg);
        if (this.browserReady && this.browser != null && !this.browser.isDisposed()) {
            String messageHtml = this.buildMessageHtml(msg);
            String escapedHtml = this.escapeForJs(messageHtml);
            String jsCode = "var container = document.getElementById('messages');if (container) {  container.insertAdjacentHTML('beforeend', '" + escapedHtml + "');  scrollToBottom();  if (typeof hljs !== 'undefined') { hljs.highlightAll(); }}";
            this.browser.execute(jsCode);
        } else {
            this.renderAllMessages();
        }
    }

    private String buildToolCallCardHtml(ToolCallDisplayData toolCall) {
        String displayName = this.getToolDisplayName(toolCall.getName());
        if (displayName == null || displayName.isBlank()) {
            displayName = toolCall.getName() != null && !toolCall.getName().isBlank() ? toolCall.getName() : "\u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442";
        }
        String argsSummary = toolCall.getArgsSummary();
        String argsJson = toolCall.getArgsJson();
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"tool-call\" data-tool-call-id=\"").append(this.escapeHtml(toolCall.getId())).append("\">\n");
        sb.append("  <div class=\"tool-call-header\" onclick=\"toggleToolCall(this)\">\n");
        sb.append("    <div class=\"tool-call-top\">\n");
        sb.append("      <div class=\"tool-call-main\">\n");
        sb.append("        <span class=\"tool-call-icon\">\ud83d\udd27</span>\n");
        sb.append("        <span class=\"tool-call-name\">").append(this.escapeHtml(displayName)).append("</span>\n");
        sb.append("      </div>\n");
        sb.append("      <div class=\"tool-call-actions\">\n");
        sb.append("        <span class=\"tool-call-status ").append(toolCall.getStatus().cssClass).append("\">").append(toolCall.getStatus().icon).append("</span>\n");
        sb.append("        <span class=\"tool-call-chevron\">\u25be</span>\n");
        sb.append("      </div>\n");
        sb.append("    </div>\n");
        if (argsSummary != null && !argsSummary.isEmpty()) {
            sb.append("    <div class=\"tool-call-meta\">\n");
            sb.append("      <span class=\"tool-call-args-summary\">").append(this.escapeHtml(argsSummary)).append("</span>\n");
            sb.append("    </div>\n");
        }
        sb.append("  </div>\n");
        sb.append("  <div class=\"tool-call-body\">\n");
        if (argsJson != null && !argsJson.isEmpty() && !"{}".equals(argsJson)) {
            sb.append("    <div class=\"tool-call-section\">\n");
            sb.append("      <div class=\"tool-call-section-title\">\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b</div>\n");
            sb.append("      <pre class=\"tool-call-args\">").append(this.escapeHtml(this.formatJson(argsJson))).append("</pre>\n");
            sb.append("    </div>\n");
        }
        sb.append("    <div class=\"tool-call-result\" style=\"display:none;\"></div>\n");
        sb.append("  </div>\n");
        sb.append("</div>\n");
        return sb.toString();
    }

    private String formatJson(String json) {
        if (json == null || json.isEmpty()) {
            return "";
        }
        try {
            Gson gson = new Gson();
            JsonElement el = JsonParser.parseString((String)json);
            return gson.toJson(el);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            return json;
        }
    }

    private String getToolDisplayName(String name) {
        if (name == null) {
            return "";
        }
        return switch (name) {
            case "read_file" -> "\u0427\u0442\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430";
            case "edit_file" -> "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430";
            case "list_files" -> "\u0421\u043f\u0438\u0441\u043e\u043a \u0444\u0430\u0439\u043b\u043e\u0432";
            case "grep" -> "\u041f\u043e\u0438\u0441\u043a \u0442\u0435\u043a\u0441\u0442\u0430";
            case "search_codebase" -> "\u041f\u043e\u0438\u0441\u043a \u043f\u043e \u043a\u043e\u0434\u0443";
            case "list_metadata" -> "\u0421\u043f\u0438\u0441\u043e\u043a \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445";
            case "get_metadata" -> "\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445";
            case "open_module" -> "\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u043c\u043e\u0434\u0443\u043b\u044f";
            case "get_diagnostics" -> "\u0414\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438";
            default -> name;
        };
    }

    private String buildHtmlDocument(String messagesHtml) {
        String css = this.loadCss();
        String js = this.loadJs();
        String themeClass = this.getEffectiveThemeClass();
        return "<!DOCTYPE html>\n<html>\n<head>\n    <meta charset=\"UTF-8\">\n    <style>\n" + css + "\n    </style>\n</head>\n<body class=\"" + themeClass + "\">\n    <div class=\"chat-root\">\n        <div class=\"message-container\" id=\"messages\">\n" + messagesHtml + "        </div>\n        <div class=\"typing-indicator\" id=\"typing-indicator\" style=\"display:none;\">\n            <div class=\"typing-content\">\n                <div class=\"typing-spinner\"></div>\n                <span id=\"typing-stage\">AI \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442 \u0437\u0430\u043f\u0440\u043e\u0441</span>\n            </div>\n            <div class=\"typing-dots\">\n                <span class=\"typing-dot\"></span>\n                <span class=\"typing-dot\"></span>\n                <span class=\"typing-dot\"></span>\n            </div>\n        </div>\n    </div>\n    <script>\n" + js + "\n    </script>\n</body>\n</html>";
    }

    private void applyThemeClassIfReady() {
        if (this.browser == null || this.browser.isDisposed() || !this.browserReady) {
            return;
        }
        String themeClass = this.getEffectiveThemeClass();
        this.browser.execute("setTheme('" + themeClass + "');");
    }

    private String resolveThemeClass() {
        Color bg = null;
        if (this.getParent() != null && !this.getParent().isDisposed()) {
            bg = this.getParent().getBackground();
        } else if (!this.isDisposed()) {
            bg = this.getBackground();
        } else {
            Display display = this.getDisplay();
            if (display != null && !display.isDisposed()) {
                bg = display.getSystemColor(22);
            }
        }
        return this.toThemeClass(bg);
    }

    private String getEffectiveThemeClass() {
        String visualThemeClass = this.resolveThemeClass();
        if (this.pendingThemeClass == null) {
            return visualThemeClass;
        }
        if (!this.pendingThemeClass.equals(visualThemeClass)) {
            LOG.debug("Theme mismatch (requested=%s, visual=%s), using visual theme", new Object[]{this.pendingThemeClass, visualThemeClass});
            return visualThemeClass;
        }
        return this.pendingThemeClass;
    }

    private String toThemeClass(Color bg) {
        int luminance;
        if (bg != null && !bg.isDisposed() && (luminance = (bg.getRed() + bg.getGreen() + bg.getBlue()) / 3) < 140) {
            return "dark";
        }
        return "light";
    }

    private String buildMessageHtml(ChatMessageData msg) {
        String messageClass = msg.isSystem ? "system" : (msg.isAssistant ? "assistant" : "user");
        String contentHtml = this.buildMessageContentHtml(msg.content);
        String reasoningHtml = "";
        if (msg.reasoning != null && !msg.reasoning.isEmpty()) {
            boolean expandReasoningByDefault = msg.content == null || msg.content.isEmpty();
            reasoningHtml = this.buildReasoningBlock(msg.reasoning, expandReasoningByDefault);
        }
        return "<div class=\"message " + messageClass + "\" id=\"" + msg.id + "\">\n    <div class=\"message-header\">\n        <span class=\"message-sender\">" + this.escapeHtml(msg.sender) + "</span>\n    </div>\n    <div class=\"message-content\">\n" + reasoningHtml + contentHtml + "\n    </div>\n</div>\n";
    }

    private String buildMessageContentHtml(String content) {
        return this.markdownParser.toHtml(content);
    }

    private String loadCss() {
        if (cachedCss != null) {
            return cachedCss;
        }
        cachedCss = this.loadResource(CSS_RESOURCE);
        if (cachedCss == null) {
            cachedCss = this.getDefaultCss();
        }
        return cachedCss;
    }

    private String loadJs() {
        if (cachedJs != null) {
            return cachedJs;
        }
        cachedJs = this.loadResource(JS_RESOURCE);
        if (cachedJs == null) {
            cachedJs = this.getDefaultJs();
        }
        return cachedJs;
    }

    /*
     * Loose catch block
     */
    private String loadResource(String path) {
        block17: {
            try {
                URL url = VibeUiPlugin.getDefault().getBundle().getEntry(path);
                if (url == null) break block17;
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    String string;
                    BufferedReader reader;
                    InputStream is;
                    block19: {
                        block18: {
                            is = url.openStream();
                            reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                            string = reader.lines().collect(Collectors.joining("\n"));
                            if (reader == null) break block18;
                            reader.close();
                        }
                        if (is == null) break block19;
                        is.close();
                    }
                    return string;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (reader != null) {
                                    reader.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (is != null) {
                                    is.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                VibeUiPlugin.log(e);
            }
        }
        return null;
    }

    private String getDefaultCss() {
        return "body { font-family: sans-serif; font-size: 14px; padding: 12px; }\nbody.dark { background: #1e293b; color: #f1f5f9; }\ntable { border-collapse: collapse; width: 100%; }\nth, td { border: 1px solid #ccc; padding: 8px; }\npre { background: #f5f5f5; padding: 12px; overflow-x: auto; }\nbody.dark pre { background: #0f172a; }";
    }

    private String getDefaultJs() {
        return "function scrollToBottom() {\n  var container = document.getElementById('messages');\n  if (container) container.scrollTop = container.scrollHeight;\n}\nfunction setTheme(theme) { document.body.className = theme; }\nfunction copyCode(btn) {\n  var code = btn.closest('.code-block').querySelector('code');\n  if (typeof copyToClipboard === 'function') copyToClipboard(code.textContent);\n  btn.textContent = '\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u043e!';\n  setTimeout(function() { btn.textContent = '\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c'; }, 2000);\n}";
    }

    private String escapeHtml(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }

    private String escapeForJs(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("\\", "\\\\").replace("'", "\\'").replace("\n", "\\n").replace("\r", "");
    }

    private void copyToClipboard(String text) {
        Display.getDefault().asyncExec(() -> {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            try {
                clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
            }
            finally {
                clipboard.dispose();
            }
        });
    }

    private void openExternalUrl(String url) {
        Display.getDefault().asyncExec(() -> {
            boolean bl = Program.launch((String)url);
        });
    }

    public void dispose() {
        if (this.copyFunction != null) {
            this.copyFunction.dispose();
        }
        if (this.openUrlFunction != null) {
            this.openUrlFunction.dispose();
        }
        if (this.applyCodeFunction != null) {
            this.applyCodeFunction.dispose();
        }
        super.dispose();
    }

    @FunctionalInterface
    public static interface ApplyCodeCallback {
        public void apply(String var1, String var2, String var3);
    }

    public static class ChatMessageData {
        public final String sender;
        public final String content;
        public final boolean isAssistant;
        public final boolean isSystem;
        public final String id;
        public final String reasoning;

        public ChatMessageData(String sender, String content, boolean isAssistant, boolean isSystem) {
            this(sender, content, isAssistant, isSystem, null);
        }

        public ChatMessageData(String sender, String content, boolean isAssistant, boolean isSystem, String reasoning) {
            this.sender = sender;
            this.content = content;
            this.isAssistant = isAssistant;
            this.isSystem = isSystem;
            this.reasoning = reasoning;
            this.id = "msg-" + System.currentTimeMillis() + "-" + (int)(Math.random() * 10000.0);
        }
    }

    public static class ToolCallDisplayData {
        private final String id;
        private final String name;
        private final String argsSummary;
        private final String argsJson;
        private ToolCallStatus status;
        private String resultSummary;
        private String resultPreview;

        public ToolCallDisplayData(String id, String name, String argsJson) {
            this.id = id;
            this.name = name;
            this.argsJson = argsJson;
            this.argsSummary = ToolCallDisplayData.buildArgsSummary(argsJson);
            this.status = ToolCallStatus.PENDING;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getArgsSummary() {
            return this.argsSummary;
        }

        public String getArgsJson() {
            return this.argsJson;
        }

        public ToolCallStatus getStatus() {
            return this.status;
        }

        public String getResultSummary() {
            return this.resultSummary;
        }

        public String getResultPreview() {
            return this.resultPreview;
        }

        public void setStatus(ToolCallStatus status) {
            this.status = status;
        }

        public void setResultSummary(String resultSummary) {
            this.resultSummary = resultSummary;
        }

        public void setResultPreview(String resultPreview) {
            this.resultPreview = resultPreview;
        }

        private static String buildArgsSummary(String json) {
            JsonElement element;
            block8: {
                if (json == null || json.isEmpty() || "{}".equals(json)) {
                    return "";
                }
                element = JsonParser.parseString((String)json);
                if (element.isJsonObject()) break block8;
                LOG.debug("Tool arguments are not JSON object, skipping summary");
                return "";
            }
            try {
                String[] priorityKeys;
                JsonObject obj = element.getAsJsonObject();
                StringBuilder sb = new StringBuilder();
                String[] stringArray = priorityKeys = new String[]{"path", "file_path", "query", "pattern", "kind", "name"};
                int n = priorityKeys.length;
                int n2 = 0;
                while (n2 < n) {
                    JsonElement val;
                    String key = stringArray[n2];
                    if (obj.has(key) && (val = obj.get(key)).isJsonPrimitive()) {
                        Object value = val.getAsString();
                        if (((String)value).length() > 40) {
                            value = "..." + ((String)value).substring(((String)value).length() - 37);
                        }
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(key).append("=").append((String)value);
                        if (sb.length() > 60) break;
                    }
                    ++n2;
                }
                return sb.toString();
            }
            catch (JsonSyntaxException e) {
                LOG.warn("Failed to parse tool arguments: %s", new Object[]{e.getMessage()});
                return "";
            }
        }
    }

    public static enum ToolCallStatus {
        PENDING("\u23f3", "pending"),
        RUNNING("\ud83d\udd04", "running"),
        SUCCESS("\u2713", "success"),
        ERROR("\u2717", "error");

        public final String icon;
        public final String cssClass;

        private ToolCallStatus(String icon, String cssClass) {
            this.icon = icon;
            this.cssClass = cssClass;
        }
    }
}

