/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.tools;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.tools.ITool;
import com.example.vibe.core.tools.ToolResult;
import com.example.vibe.ui.diagnostics.EdtDiagnostic;
import com.example.vibe.ui.diagnostics.EdtDiagnosticsCollector;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class GetDiagnosticsTool
implements ITool {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(GetDiagnosticsTool.class);
    private static final String SCHEMA = "{\n    \"type\": \"object\",\n    \"properties\": {\n        \"path\": {\n            \"type\": \"string\",\n            \"description\": \"\u041f\u0443\u0442\u044c \u043a \u0444\u0430\u0439\u043b\u0443 (workspace-relative). \u0415\u0441\u043b\u0438 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u2014 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440.\"\n        },\n        \"severity\": {\n            \"type\": \"string\",\n            \"enum\": [\"error\", \"warning\", \"info\"],\n            \"description\": \"\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0441\u0435\u0440\u044c\u0451\u0437\u043d\u043e\u0441\u0442\u0438: error (\u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0448\u0438\u0431\u043a\u0438), warning (\u043e\u0448\u0438\u0431\u043a\u0438 \u0438 \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f), info (\u0432\u0441\u0435). \u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e: error\"\n        },\n        \"max_items\": {\n            \"type\": \"integer\",\n            \"description\": \"\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a. \u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e: 50\"\n        },\n        \"wait_ms\": {\n            \"type\": \"integer\",\n            \"description\": \"\u0412\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043f\u0435\u0440\u0435\u0441\u0447\u0451\u0442\u0430 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a \u0432 \u043c\u0441 (0-2000). \u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e: 0\"\n        }\n    },\n    \"required\": []\n}\n";

    public String getName() {
        return "get_diagnostics";
    }

    public String getDescription() {
        return "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438 EDT (\u043e\u0448\u0438\u0431\u043a\u0438 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438, \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f) \u0434\u043b\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0444\u0430\u0439\u043b\u0430. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439 \u043f\u043e\u0441\u043b\u0435 \u0432\u043d\u0435\u0441\u0435\u043d\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0441\u0442\u0438 \u043a\u043e\u0434\u0430.";
    }

    public String getParameterSchema() {
        return SCHEMA;
    }

    public CompletableFuture<ToolResult> execute(Map<String, Object> parameters) {
        String path = (String)parameters.get("path");
        String severityStr = (String)parameters.getOrDefault("severity", "error");
        int maxItems = this.getIntParam(parameters, "max_items", 50);
        long waitMs = this.getIntParam(parameters, "wait_ms", 0);
        if (maxItems < 1) {
            maxItems = 1;
        }
        if (maxItems > 200) {
            maxItems = 200;
        }
        if (waitMs < 0L) {
            waitMs = 0L;
        }
        if (waitMs > 2000L) {
            waitMs = 2000L;
        }
        EdtDiagnostic.Severity minSeverity = this.parseSeverity(severityStr);
        EdtDiagnosticsCollector.DiagnosticsQuery query = new EdtDiagnosticsCollector.DiagnosticsQuery(minSeverity, maxItems, true, waitMs);
        LOG.debug("get_diagnostics: path=%s, severity=%s, max=%d, wait=%d", new Object[]{path, minSeverity, maxItems, waitMs});
        EdtDiagnosticsCollector collector = EdtDiagnosticsCollector.getInstance();
        CompletableFuture<EdtDiagnosticsCollector.DiagnosticsResult> resultFuture = path != null && !path.isBlank() ? collector.collectFromFile(path, query) : collector.collectFromActiveEditor(query);
        return ((CompletableFuture)resultFuture.thenApply(result -> {
            String formatted = result.formatForLlm();
            LOG.debug("get_diagnostics result: %d errors, %d warnings", new Object[]{result.errorCount(), result.warningCount()});
            return ToolResult.success((String)formatted);
        })).exceptionally(e -> {
            LOG.error("get_diagnostics failed: %s", new Object[]{e.getMessage()});
            return ToolResult.failure((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a: " + e.getMessage()));
        });
    }

    private EdtDiagnostic.Severity parseSeverity(String str) {
        if (str == null) {
            return EdtDiagnostic.Severity.ERROR;
        }
        return switch (str.toLowerCase()) {
            case "warn", "warning" -> EdtDiagnostic.Severity.WARNING;
            case "all", "info" -> EdtDiagnostic.Severity.INFO;
            default -> EdtDiagnostic.Severity.ERROR;
        };
    }

    /*
     * WARNING - void declaration
     */
    private int getIntParam(Map<String, Object> params, String key, int defaultValue) {
        Object value = params.get(key);
        if (value == null) {
            return defaultValue;
        }
        Object object = value;
        if (object instanceof Number) {
            void num;
            Number number = (Number)object;
            Number cfr_ignored_0 = (Number)object;
            return num.intValue();
        }
        try {
            return Integer.parseInt(String.valueOf(value));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }
}

