/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.theme;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.ui.theme.DarkTheme;
import com.example.vibe.ui.theme.LightTheme;
import com.example.vibe.ui.theme.VibeTheme;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public class ThemeManager {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(ThemeManager.class);
    private static final String[] DARK_THEME_MARKERS = new String[]{"dark", "dracula", "night", "black", "highcontrast"};
    private static final String[] LIGHT_THEME_MARKERS = new String[]{"light", "classic"};
    private static final String[] WORKBENCH_BACKGROUND_KEYS = new String[]{"org.eclipse.ui.workbench.ACTIVE_TAB_BG_START", "org.eclipse.ui.workbench.INACTIVE_TAB_BG_START", "org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_BG_START", "org.eclipse.ui.workbench.INACTIVE_TAB_UNSELECTED_BG_START", "org.eclipse.ui.editors.backgroundColor"};
    private static ThemeManager instance;
    private final Map<String, Color> colorCache = new HashMap<String, Color>();
    private final Map<String, Font> fontCache = new HashMap<String, Font>();
    private final List<Consumer<VibeTheme>> themeChangeListeners = new ArrayList<Consumer<VibeTheme>>();
    private VibeTheme currentTheme;
    private boolean isDarkTheme;
    private Display display;
    private boolean initialized = false;
    private IPropertyChangeListener eclipseThemeListener;

    private ThemeManager() {
    }

    public static synchronized ThemeManager getInstance() {
        if (instance == null) {
            instance = new ThemeManager();
        }
        return instance;
    }

    public synchronized void initialize(Display display) {
        if (this.initialized) {
            LOG.debug("ThemeManager already initialized, skipping");
            return;
        }
        this.display = display;
        this.detectTheme();
        this.createTheme();
        try {
            IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
            this.eclipseThemeListener = event -> {
                if ("CHANGE_CURRENT_THEME".equals(event.getProperty())) {
                    LOG.info("Eclipse theme changed, updating Vibe theme");
                    this.detectTheme();
                    this.createTheme();
                    this.notifyThemeChange();
                }
            };
            themeManager.addPropertyChangeListener(this.eclipseThemeListener);
        }
        catch (Exception e) {
            LOG.warn("Could not register theme change listener: %s", new Object[]{e.getMessage()});
        }
        this.initialized = true;
        LOG.info("ThemeManager initialized, dark mode: %b", new Object[]{this.isDarkTheme});
    }

    public VibeTheme getTheme() {
        if (this.currentTheme == null) {
            if (this.display == null) {
                this.display = Display.getDefault();
            }
            this.detectTheme();
            this.createTheme();
        }
        return this.currentTheme;
    }

    public boolean isDarkTheme() {
        return this.isDarkTheme;
    }

    public void addThemeChangeListener(Consumer<VibeTheme> listener) {
        this.themeChangeListeners.add(listener);
    }

    public void removeThemeChangeListener(Consumer<VibeTheme> listener) {
        this.themeChangeListeners.remove(listener);
    }

    public Color getColor(String key, RGB rgb) {
        return this.colorCache.computeIfAbsent(key, k -> new Color((Device)this.getDisplay(), rgb));
    }

    public Font getFont(String key, String name, int height, int style) {
        return this.fontCache.computeIfAbsent(key, k -> {
            FontData fd = new FontData(name, height, style);
            return new Font((Device)this.getDisplay(), fd);
        });
    }

    public synchronized void dispose() {
        if (this.eclipseThemeListener != null) {
            try {
                IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
                themeManager.removePropertyChangeListener(this.eclipseThemeListener);
            }
            catch (Exception exception) {}
            this.eclipseThemeListener = null;
        }
        Runnable disposeRunnable = () -> {
            for (Color color : this.colorCache.values()) {
                if (color == null || color.isDisposed()) continue;
                color.dispose();
            }
            this.colorCache.clear();
            for (Font font : this.fontCache.values()) {
                if (font == null || font.isDisposed()) continue;
                font.dispose();
            }
            this.fontCache.clear();
        };
        if (this.display != null && !this.display.isDisposed()) {
            if (Display.getCurrent() == this.display) {
                disposeRunnable.run();
            } else {
                try {
                    this.display.syncExec(disposeRunnable);
                }
                catch (Exception exception) {
                    disposeRunnable.run();
                }
            }
        } else {
            disposeRunnable.run();
        }
        this.themeChangeListeners.clear();
        this.currentTheme = null;
        this.initialized = false;
        LOG.debug("ThemeManager disposed");
    }

    private void detectTheme() {
        try {
            String normalizedThemeId;
            IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
            ITheme theme = themeManager.getCurrentTheme();
            String themeId = theme.getId();
            String string = normalizedThemeId = themeId != null ? themeId.toLowerCase(Locale.ROOT) : "";
            if (this.containsAnyMarker(normalizedThemeId, DARK_THEME_MARKERS)) {
                this.isDarkTheme = true;
                LOG.debug("Detected dark theme by theme ID: %s", new Object[]{themeId});
                return;
            }
            if (this.containsAnyMarker(normalizedThemeId, LIGHT_THEME_MARKERS)) {
                this.isDarkTheme = false;
                LOG.debug("Detected light theme by theme ID: %s", new Object[]{themeId});
                return;
            }
            ColorRegistry colorRegistry = theme.getColorRegistry();
            String[] stringArray = WORKBENCH_BACKGROUND_KEYS;
            int n = WORKBENCH_BACKGROUND_KEYS.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                RGB rgb = colorRegistry.getRGB(key);
                if (rgb != null) {
                    int luminance = (rgb.red + rgb.green + rgb.blue) / 3;
                    this.isDarkTheme = luminance < 140;
                    LOG.debug("Detected theme by color key %s (luminance=%d): %s", new Object[]{key, luminance, this.isDarkTheme ? "dark" : "light"});
                    return;
                }
                ++n2;
            }
            this.isDarkTheme = this.isSystemBackgroundDark();
            LOG.debug("Theme ID was ambiguous (%s), fallback to system background: %s", new Object[]{themeId, this.isDarkTheme ? "dark" : "light"});
        }
        catch (Exception e) {
            this.isDarkTheme = this.isSystemBackgroundDark();
            LOG.debug("Could not detect theme from workbench (%s), fallback: %s", new Object[]{e.getMessage(), this.isDarkTheme ? "dark" : "light"});
        }
    }

    private boolean containsAnyMarker(String value, String[] markers) {
        String[] stringArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            String marker = stringArray[n2];
            if (value.contains(marker)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isSystemBackgroundDark() {
        try {
            Color sysBg = this.getDisplay().getSystemColor(22);
            int luminance = (sysBg.getRed() + sysBg.getGreen() + sysBg.getBlue()) / 3;
            return luminance < 140;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void createTheme() {
        this.currentTheme = this.isDarkTheme ? new DarkTheme(this) : new LightTheme(this);
    }

    private void notifyThemeChange() {
        for (Consumer<VibeTheme> listener : this.themeChangeListeners) {
            try {
                listener.accept(this.currentTheme);
            }
            catch (Exception e) {
                LOG.warn("Error notifying theme change listener: %s", new Object[]{e.getMessage()});
            }
        }
    }

    Display getDisplay() {
        return this.display != null ? this.display : Display.getDefault();
    }

    int getBaseFontHeight() {
        Font systemFont = this.getDisplay().getSystemFont();
        FontData[] fontData = systemFont.getFontData();
        return fontData.length > 0 ? fontData[0].getHeight() : 10;
    }

    String getBaseFontName() {
        Font systemFont = this.getDisplay().getSystemFont();
        FontData[] fontData = systemFont.getFontData();
        return fontData.length > 0 ? fontData[0].getName() : "Arial";
    }

    String getMonoFontName() {
        String[] stringArray = new String[]{"JetBrains Mono", "Fira Code", "Menlo", "Consolas", "Monaco", "Courier New", "Monospace"};
        String os = System.getProperty("os.name", "").toLowerCase();
        if (os.contains("mac")) {
            return "Menlo";
        }
        if (os.contains("win")) {
            return "Consolas";
        }
        return "Monospace";
    }
}

