/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.statusbar;

import com.example.vibe.core.backend.RegistrationResult;
import com.example.vibe.core.internal.VibeCorePlugin;
import com.example.vibe.core.state.VibeState;
import com.example.vibe.core.state.VibeStateService;
import com.example.vibe.ui.dialogs.LoginDialog;
import com.example.vibe.ui.dialogs.RegistrationDialog;
import com.example.vibe.ui.internal.VibeUiPlugin;
import java.util.EnumMap;
import java.util.Map;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class VibeStatusBarControl
extends ContributionItem
implements VibeStateService.StateChangeListener {
    public static final String ID = "com.example.vibe.ui.statusbar";
    private Composite composite;
    private Label iconLabel;
    private Label textLabel;
    private VibeState currentDisplayState;
    private final Map<VibeState, Image> imageCache = new EnumMap<VibeState, Image>(VibeState.class);

    public VibeStatusBarControl() {
        super(ID);
    }

    public VibeStatusBarControl(String id) {
        super(id);
    }

    public void fill(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 4;
        layout.horizontalSpacing = 4;
        this.composite.setLayout((Layout)layout);
        StatusLineLayoutData layoutData = new StatusLineLayoutData();
        layoutData.widthHint = 120;
        this.composite.setLayoutData((Object)layoutData);
        this.iconLabel = new Label(this.composite, 0);
        this.iconLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.textLabel = new Label(this.composite, 0);
        this.textLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.composite.setToolTipText("1C Copilot Status");
        this.composite.addListener(3, e -> this.showStatusDetails());
        this.iconLabel.addListener(3, e -> this.showStatusDetails());
        this.textLabel.addListener(3, e -> this.showStatusDetails());
        VibeStateService.getInstance().addListener((VibeStateService.StateChangeListener)this);
        this.updateDisplay(VibeStateService.getInstance().getState(), VibeStateService.getInstance().getStatusMessage());
    }

    public void onStateChanged(VibeState oldState, VibeState newState, String message) {
        Display display = Display.getDefault();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(() -> {
                if (!this.isDisposed()) {
                    this.updateDisplay(newState, message);
                }
            });
        }
    }

    private void updateDisplay(VibeState state, String message) {
        if (this.isDisposed()) {
            return;
        }
        if (state != this.currentDisplayState) {
            Image icon = this.getIconForState(state);
            this.iconLabel.setImage(icon);
            this.currentDisplayState = state;
        }
        String displayText = this.truncateText(message, 15);
        this.textLabel.setText(displayText);
        String tooltip = this.buildTooltip(state, message);
        this.composite.setToolTipText(tooltip);
        this.iconLabel.setToolTipText(tooltip);
        this.textLabel.setToolTipText(tooltip);
        if (state.isError()) {
            this.textLabel.setForeground(this.composite.getDisplay().getSystemColor(3));
        } else if (state.isActive()) {
            this.textLabel.setForeground(this.composite.getDisplay().getSystemColor(9));
        } else {
            this.textLabel.setForeground(null);
        }
        this.composite.layout(true);
    }

    private Image getIconForState(VibeState state) {
        Image cached = this.imageCache.get(state);
        if (cached != null && !cached.isDisposed()) {
            return cached;
        }
        String iconPath = state.getIconPath();
        try {
            Image icon = VibeUiPlugin.getImageDescriptor(iconPath).createImage();
            if (icon != null) {
                this.imageCache.put(state, icon);
                return icon;
            }
        }
        catch (Exception exception) {}
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        switch (state) {
            case ERROR: {
                return sharedImages.getImage("IMG_OBJS_ERROR_TSK");
            }
            case NOT_CONFIGURED: {
                return sharedImages.getImage("IMG_OBJS_WARN_TSK");
            }
            case COMPLETING: 
            case PROCESSING: 
            case STREAMING: 
            case INDEXING: {
                return sharedImages.getImage("IMG_ELCL_SYNCED");
            }
            case DISABLED: {
                return sharedImages.getImage("IMG_ELCL_STOP");
            }
        }
        return sharedImages.getImage("IMG_OBJS_INFO_TSK");
    }

    private String buildTooltip(VibeState state, String message) {
        String error;
        StringBuilder sb = new StringBuilder();
        sb.append("1C Copilot: ").append(state.getDisplayName());
        if (message != null && !message.isEmpty() && !message.equals(state.getDisplayName())) {
            sb.append("\n").append(message);
        }
        if ((error = VibeStateService.getInstance().getErrorMessage()) != null && !error.isEmpty()) {
            sb.append("\n\nError: ").append(error);
        }
        sb.append("\n\nClick for details");
        return sb.toString();
    }

    private String truncateText(String text, int maxLength) {
        if (text == null) {
            return "";
        }
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, maxLength - 3) + "...";
    }

    private void showStatusDetails() {
        VibeState state = VibeStateService.getInstance().getState();
        String message = VibeStateService.getInstance().getStatusMessage();
        String error = VibeStateService.getInstance().getErrorMessage();
        StringBuilder details = new StringBuilder();
        details.append("Status: ").append(state.getDisplayName()).append("\n");
        details.append("Message: ").append(message).append("\n");
        if (error != null) {
            details.append("Error: ").append(error).append("\n");
        }
        VibeUiPlugin.log("Vibe Status: " + details.toString());
        if (state == VibeState.NOT_CONFIGURED) {
            this.openAuthDialog();
        }
    }

    private void openAuthDialog() {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                MessageDialog chooser = new MessageDialog(window.getShell(), "\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f", null, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u0434\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f AI-\u0441\u0435\u0440\u0432\u0438\u0441\u0430", 3, new String[]{"\u0412\u043e\u0439\u0442\u0438", "\u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f", "\u041e\u0442\u043c\u0435\u043d\u0430"}, 0);
                int choice = chooser.open();
                if (choice == 0) {
                    this.openLoginDialog(window);
                } else if (choice == 1) {
                    this.openRegistrationDialog(window);
                }
            }
        }
        catch (Exception e) {
            VibeUiPlugin.log(e);
        }
    }

    private void openRegistrationDialog(IWorkbenchWindow window) {
        RegistrationResult result;
        RegistrationDialog dialog = new RegistrationDialog(window.getShell());
        if (dialog.open() == 0 && (result = dialog.getRegistrationResult()) != null && result.isSuccess()) {
            VibeCorePlugin.initializeLlmProvider((String)result.getApiKey());
            VibeStateService.getInstance().setIdle();
        }
    }

    private void openLoginDialog(IWorkbenchWindow window) {
        RegistrationResult result;
        LoginDialog dialog = new LoginDialog(window.getShell());
        if (dialog.open() == 0 && (result = dialog.getLoginResult()) != null && result.isSuccess()) {
            VibeCorePlugin.initializeLlmProvider((String)result.getApiKey());
            VibeStateService.getInstance().setIdle();
        }
    }

    private boolean isDisposed() {
        return this.composite == null || this.composite.isDisposed();
    }

    public void dispose() {
        VibeStateService.getInstance().removeListener((VibeStateService.StateChangeListener)this);
        for (Image image : this.imageCache.values()) {
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
        this.imageCache.clear();
        this.currentDisplayState = null;
        super.dispose();
    }
}

