/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.preferences;

import com.example.vibe.ui.internal.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ModelListFieldEditor
extends FieldEditor {
    private static final String SEPARATOR = ";";
    private org.eclipse.swt.widgets.List modelList;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private Composite buttonBox;
    private List<String> models = new ArrayList<String>();

    public ModelListFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        }
        ((GridData)this.modelList.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.modelList = this.getListControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 100;
        this.modelList.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.modelList != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.parseModels(value);
            this.populateList();
        }
    }

    protected void doLoadDefault() {
        if (this.modelList != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.parseModels(value);
            this.populateList();
        }
    }

    protected void doStore() {
        String value = String.join((CharSequence)SEPARATOR, this.models);
        this.getPreferenceStore().setValue(this.getPreferenceName(), value);
    }

    public int getNumberOfControls() {
        return 2;
    }

    private org.eclipse.swt.widgets.List getListControl(Composite parent) {
        if (this.modelList == null) {
            this.modelList = new org.eclipse.swt.widgets.List(parent, 2820);
            this.modelList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ModelListFieldEditor.this.updateButtons();
                }
            });
        }
        return this.modelList;
    }

    private Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.addButton = this.createButton(this.buttonBox, Messages.ModelListFieldEditor_AddButton);
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ModelListFieldEditor.this.addModel();
                }
            });
            this.editButton = this.createButton(this.buttonBox, Messages.ModelListFieldEditor_EditButton);
            this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ModelListFieldEditor.this.editModel();
                }
            });
            this.removeButton = this.createButton(this.buttonBox, Messages.ModelListFieldEditor_RemoveButton);
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ModelListFieldEditor.this.removeModel();
                }
            });
            Label separator = new Label(this.buttonBox, 0);
            separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.upButton = this.createButton(this.buttonBox, Messages.ModelListFieldEditor_UpButton);
            this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ModelListFieldEditor.this.moveUp();
                }
            });
            this.downButton = this.createButton(this.buttonBox, Messages.ModelListFieldEditor_DownButton);
            this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ModelListFieldEditor.this.moveDown();
                }
            });
            this.updateButtons();
        }
        return this.buttonBox;
    }

    private Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        GridData gd = new GridData(768);
        gd.widthHint = 80;
        button.setLayoutData((Object)gd);
        return button;
    }

    private void parseModels(String value) {
        this.models.clear();
        if (value != null && !value.isEmpty()) {
            String[] parts;
            String[] stringArray = parts = value.split(SEPARATOR);
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                String trimmed = part.trim();
                if (!trimmed.isEmpty()) {
                    this.models.add(trimmed);
                }
                ++n2;
            }
        }
    }

    private void populateList() {
        this.modelList.removeAll();
        for (String model : this.models) {
            this.modelList.add(model);
        }
        this.updateButtons();
    }

    private void updateButtons() {
        int index = this.modelList.getSelectionIndex();
        int size = this.models.size();
        this.editButton.setEnabled(index >= 0);
        this.removeButton.setEnabled(index >= 0);
        this.upButton.setEnabled(index > 0);
        this.downButton.setEnabled(index >= 0 && index < size - 1);
    }

    private void addModel() {
        String newModel;
        Shell shell = this.modelList.getShell();
        InputDialog dialog = new InputDialog(shell, Messages.ModelListFieldEditor_AddDialogTitle, Messages.ModelListFieldEditor_AddDialogMessage, "", (IInputValidator)new ModelNameValidator());
        if (dialog.open() == 0 && !(newModel = dialog.getValue().trim()).isEmpty() && !this.models.contains(newModel)) {
            this.models.add(newModel);
            this.populateList();
            this.modelList.setSelection(this.models.size() - 1);
            this.updateButtons();
        }
    }

    private void editModel() {
        String newModel;
        int index = this.modelList.getSelectionIndex();
        if (index < 0) {
            return;
        }
        String currentModel = this.models.get(index);
        Shell shell = this.modelList.getShell();
        InputDialog dialog = new InputDialog(shell, Messages.ModelListFieldEditor_EditDialogTitle, Messages.ModelListFieldEditor_EditDialogMessage, currentModel, (IInputValidator)new ModelNameValidator());
        if (dialog.open() == 0 && !(newModel = dialog.getValue().trim()).isEmpty()) {
            this.models.set(index, newModel);
            this.populateList();
            this.modelList.setSelection(index);
            this.updateButtons();
        }
    }

    private void removeModel() {
        int index = this.modelList.getSelectionIndex();
        if (index >= 0) {
            this.models.remove(index);
            this.populateList();
            if (index < this.models.size()) {
                this.modelList.setSelection(index);
            } else if (!this.models.isEmpty()) {
                this.modelList.setSelection(this.models.size() - 1);
            }
            this.updateButtons();
        }
    }

    private void moveUp() {
        int index = this.modelList.getSelectionIndex();
        if (index > 0) {
            String model = this.models.remove(index);
            this.models.add(index - 1, model);
            this.populateList();
            this.modelList.setSelection(index - 1);
            this.updateButtons();
        }
    }

    private void moveDown() {
        int index = this.modelList.getSelectionIndex();
        if (index >= 0 && index < this.models.size() - 1) {
            String model = this.models.remove(index);
            this.models.add(index + 1, model);
            this.populateList();
            this.modelList.setSelection(index + 1);
            this.updateButtons();
        }
    }

    public List<String> getModels() {
        return new ArrayList<String>(this.models);
    }

    private static class ModelNameValidator
    implements IInputValidator {
        private ModelNameValidator() {
        }

        public String isValid(String newText) {
            if (newText == null || newText.trim().isEmpty()) {
                return Messages.ModelListFieldEditor_ValidationEmpty;
            }
            if (newText.contains(ModelListFieldEditor.SEPARATOR)) {
                return Messages.ModelListFieldEditor_ValidationSemicolon;
            }
            return null;
        }
    }
}

