/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.preferences;

import com.example.vibe.ui.internal.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ModelConfigurationEditor {
    private static final String SEPARATOR = ";";
    private final String modelsPreferenceName;
    private final String activeModelPreferenceName;
    private final IPreferenceStore preferenceStore;
    private Composite container;
    private org.eclipse.swt.widgets.List modelList;
    private Combo activeModelCombo;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private List<String> models = new ArrayList<String>();
    private String activeModel = "";

    public ModelConfigurationEditor(Composite parent, String title, String modelsPreferenceName, String activeModelPreferenceName, IPreferenceStore preferenceStore) {
        this.modelsPreferenceName = modelsPreferenceName;
        this.activeModelPreferenceName = activeModelPreferenceName;
        this.preferenceStore = preferenceStore;
        this.createControl(parent, title);
        this.load();
    }

    private void createControl(Composite parent, String title) {
        Group group = new Group(parent, 0);
        group.setText(title);
        group.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        this.container = group;
        Label activeLabel = new Label((Composite)group, 0);
        activeLabel.setText(Messages.ModelConfigurationEditor_ActiveModelLabel);
        this.activeModelCombo = new Combo((Composite)group, 12);
        this.activeModelCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.activeModelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ModelConfigurationEditor.this.activeModelCombo.getSelectionIndex();
                if (index >= 0 && index < ModelConfigurationEditor.this.models.size()) {
                    ModelConfigurationEditor.this.activeModel = ModelConfigurationEditor.this.models.get(index);
                }
            }
        });
        Label modelsLabel = new Label((Composite)group, 0);
        modelsLabel.setText(Messages.ModelConfigurationEditor_CustomModelsLabel);
        gd = new GridData();
        gd.horizontalSpan = 2;
        modelsLabel.setLayoutData((Object)gd);
        Composite listContainer = new Composite((Composite)group, 0);
        listContainer.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        listContainer.setLayoutData((Object)gd);
        this.modelList = new org.eclipse.swt.widgets.List(listContainer, 2564);
        gd = new GridData(4, 4, true, false);
        gd.heightHint = 80;
        this.modelList.setLayoutData((Object)gd);
        this.modelList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelConfigurationEditor.this.updateButtons();
            }
        });
        Composite buttonBox = new Composite(listContainer, 0);
        buttonBox.setLayout((Layout)new GridLayout(1, true));
        buttonBox.setLayoutData((Object)new GridData(0x1000000, 1, false, false));
        this.addButton = new Button(buttonBox, 8);
        this.addButton.setText(Messages.ModelListFieldEditor_AddButton);
        this.addButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelConfigurationEditor.this.addModel();
            }
        });
        this.editButton = new Button(buttonBox, 8);
        this.editButton.setText(Messages.ModelListFieldEditor_EditButton);
        this.editButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelConfigurationEditor.this.editModel();
            }
        });
        this.removeButton = new Button(buttonBox, 8);
        this.removeButton.setText(Messages.ModelListFieldEditor_RemoveButton);
        this.removeButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelConfigurationEditor.this.removeModel();
            }
        });
        this.updateButtons();
    }

    public void load() {
        String modelsValue = this.preferenceStore.getString(this.modelsPreferenceName);
        this.activeModel = this.preferenceStore.getString(this.activeModelPreferenceName);
        this.parseModels(modelsValue);
        this.populateControls();
    }

    public void loadDefaults() {
        String modelsValue = this.preferenceStore.getDefaultString(this.modelsPreferenceName);
        this.activeModel = this.preferenceStore.getDefaultString(this.activeModelPreferenceName);
        this.parseModels(modelsValue);
        this.populateControls();
    }

    public void store() {
        String modelsValue = String.join((CharSequence)SEPARATOR, this.models);
        this.preferenceStore.setValue(this.modelsPreferenceName, modelsValue);
        this.preferenceStore.setValue(this.activeModelPreferenceName, this.activeModel);
    }

    private void parseModels(String value) {
        this.models.clear();
        if (value != null && !value.isEmpty()) {
            String[] parts;
            String[] stringArray = parts = value.split(SEPARATOR);
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                String trimmed = part.trim();
                if (!trimmed.isEmpty()) {
                    this.models.add(trimmed);
                }
                ++n2;
            }
        }
    }

    private void populateControls() {
        this.modelList.removeAll();
        for (String model : this.models) {
            this.modelList.add(model);
        }
        this.activeModelCombo.removeAll();
        int activeIndex = -1;
        int i = 0;
        while (i < this.models.size()) {
            String model = this.models.get(i);
            this.activeModelCombo.add(model);
            if (model.equals(this.activeModel)) {
                activeIndex = i;
            }
            ++i;
        }
        if (activeIndex >= 0) {
            this.activeModelCombo.select(activeIndex);
        } else if (!this.models.isEmpty()) {
            this.activeModelCombo.select(0);
            this.activeModel = this.models.get(0);
        }
        this.updateButtons();
    }

    private void updateButtons() {
        int index = this.modelList.getSelectionIndex();
        this.editButton.setEnabled(index >= 0);
        this.removeButton.setEnabled(index >= 0);
    }

    private void addModel() {
        String newModel;
        InputDialog dialog = new InputDialog(this.container.getShell(), Messages.ModelListFieldEditor_AddDialogTitle, Messages.ModelListFieldEditor_AddDialogMessage, "", (IInputValidator)new ModelNameValidator());
        if (dialog.open() == 0 && !(newModel = dialog.getValue().trim()).isEmpty() && !this.models.contains(newModel)) {
            this.models.add(newModel);
            this.populateControls();
            this.modelList.setSelection(this.models.size() - 1);
            if (this.models.size() == 1) {
                this.activeModel = newModel;
                this.activeModelCombo.select(0);
            }
            this.updateButtons();
        }
    }

    private void editModel() {
        String newModel;
        int index = this.modelList.getSelectionIndex();
        if (index < 0) {
            return;
        }
        String currentModel = this.models.get(index);
        boolean wasActive = currentModel.equals(this.activeModel);
        InputDialog dialog = new InputDialog(this.container.getShell(), Messages.ModelListFieldEditor_EditDialogTitle, Messages.ModelListFieldEditor_EditDialogMessage, currentModel, (IInputValidator)new ModelNameValidator());
        if (dialog.open() == 0 && !(newModel = dialog.getValue().trim()).isEmpty()) {
            this.models.set(index, newModel);
            if (wasActive) {
                this.activeModel = newModel;
            }
            this.populateControls();
            this.modelList.setSelection(index);
            this.updateButtons();
        }
    }

    private void removeModel() {
        int index = this.modelList.getSelectionIndex();
        if (index >= 0) {
            String removedModel = this.models.remove(index);
            if (removedModel.equals(this.activeModel)) {
                this.activeModel = !this.models.isEmpty() ? this.models.get(0) : "";
            }
            this.populateControls();
            if (index < this.models.size()) {
                this.modelList.setSelection(index);
            } else if (!this.models.isEmpty()) {
                this.modelList.setSelection(this.models.size() - 1);
            }
            this.updateButtons();
        }
    }

    public Composite getControl() {
        return this.container;
    }

    public List<String> getModels() {
        return new ArrayList<String>(this.models);
    }

    public String getActiveModel() {
        return this.activeModel;
    }

    private static class ModelNameValidator
    implements IInputValidator {
        private ModelNameValidator() {
        }

        public String isValid(String newText) {
            if (newText == null || newText.trim().isEmpty()) {
                return Messages.ModelListFieldEditor_ValidationEmpty;
            }
            if (newText.contains(ModelConfigurationEditor.SEPARATOR)) {
                return Messages.ModelListFieldEditor_ValidationSemicolon;
            }
            return null;
        }
    }
}

