/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.preferences;

import com.example.vibe.core.mcp.McpServerManager;
import com.example.vibe.core.mcp.config.McpServerConfig;
import com.example.vibe.core.mcp.config.McpServerConfigStore;
import com.example.vibe.core.mcp.model.McpServerState;
import com.example.vibe.ui.internal.Messages;
import com.example.vibe.ui.preferences.McpServerEditDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class McpServersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer tableViewer;
    private List<McpServerConfig> servers;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button startButton;
    private Button stopButton;

    public void init(IWorkbench workbench) {
        this.servers = new ArrayList<McpServerConfig>(McpServerConfigStore.getInstance().getServers());
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label description = new Label(container, 64);
        description.setText(Messages.McpServersPreferencePage_Description);
        GridData gd = new GridData(4, 128, true, false, 2, 1);
        gd.widthHint = 400;
        description.setLayoutData((Object)gd);
        this.createTable(container);
        this.createButtons(container);
        return container;
    }

    private void createTable(Composite parent) {
        this.tableViewer = new TableViewer(parent, 67588);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 200;
        table.setLayoutData((Object)gd);
        this.createColumn(table, Messages.McpServersPreferencePage_ColumnEnabled, 40);
        this.createColumn(table, Messages.McpServersPreferencePage_ColumnName, 150);
        this.createColumn(table, Messages.McpServersPreferencePage_ColumnCommand, 200);
        this.createColumn(table, Messages.McpServersPreferencePage_ColumnStatus, 100);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new McpServerLabelProvider());
        this.tableViewer.setInput(this.servers);
        this.tableViewer.addDoubleClickListener(e -> this.editServer());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                McpServersPreferencePage.this.updateButtonStates();
            }
        });
    }

    private TableColumn createColumn(Table table, String text, int width) {
        TableColumn column = new TableColumn(table, 0);
        column.setText(text);
        column.setWidth(width);
        return column;
    }

    private void createButtons(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        buttonBar.setLayoutData((Object)new GridData(4, 128, false, false));
        this.addButton = this.createButton(buttonBar, Messages.McpServersPreferencePage_Add, this::addServer);
        this.editButton = this.createButton(buttonBar, Messages.McpServersPreferencePage_Edit, this::editServer);
        this.removeButton = this.createButton(buttonBar, Messages.McpServersPreferencePage_Remove, this::removeServer);
        Label separator = new Label(buttonBar, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.startButton = this.createButton(buttonBar, Messages.McpServersPreferencePage_Start, this::startServer);
        this.stopButton = this.createButton(buttonBar, Messages.McpServersPreferencePage_Stop, this::stopServer);
        this.updateButtonStates();
    }

    private Button createButton(Composite parent, String text, Runnable action) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> action.run()));
        return button;
    }

    private void addServer() {
        McpServerEditDialog dialog = new McpServerEditDialog(this.getShell(), null);
        if (dialog.open() == 0) {
            this.servers.add(dialog.getServerConfig());
            this.tableViewer.refresh();
        }
    }

    private void editServer() {
        McpServerEditDialog dialog;
        McpServerConfig selected = this.getSelectedServer();
        if (selected != null && (dialog = new McpServerEditDialog(this.getShell(), selected)).open() == 0) {
            int index = this.servers.indexOf(selected);
            this.servers.set(index, dialog.getServerConfig());
            this.tableViewer.refresh();
        }
    }

    private void removeServer() {
        boolean confirm;
        McpServerConfig selected = this.getSelectedServer();
        if (selected != null && (confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.ProvidersPreferencePage_RemoveConfirmTitle, (String)String.format(Messages.ProvidersPreferencePage_RemoveConfirmMessage, selected.getName())))) {
            McpServerManager.getInstance().stopServer(selected.getId());
            this.servers.remove(selected);
            this.tableViewer.refresh();
        }
    }

    private void startServer() {
        McpServerConfig selected = this.getSelectedServer();
        if (selected != null) {
            McpServerManager.getInstance().startServer(selected).thenRun(() -> Display.getDefault().asyncExec(() -> {
                this.tableViewer.refresh();
                this.updateButtonStates();
            }));
            this.tableViewer.refresh();
            this.updateButtonStates();
        }
    }

    private void stopServer() {
        McpServerConfig selected = this.getSelectedServer();
        if (selected != null) {
            McpServerManager.getInstance().stopServer(selected.getId());
            this.tableViewer.refresh();
            this.updateButtonStates();
        }
    }

    private McpServerConfig getSelectedServer() {
        IStructuredSelection selection = this.tableViewer.getStructuredSelection();
        return (McpServerConfig)selection.getFirstElement();
    }

    private void updateButtonStates() {
        McpServerConfig selected = this.getSelectedServer();
        boolean hasSelection = selected != null;
        McpServerState state = hasSelection ? McpServerManager.getInstance().getServerState(selected.getId()) : McpServerState.STOPPED;
        boolean isRunning = state == McpServerState.RUNNING;
        boolean isStarting = state == McpServerState.STARTING;
        this.editButton.setEnabled(hasSelection);
        this.removeButton.setEnabled(hasSelection);
        this.startButton.setEnabled(hasSelection && !isRunning && !isStarting);
        this.stopButton.setEnabled(hasSelection && (isRunning || isStarting));
    }

    public boolean performOk() {
        McpServerConfigStore.getInstance().setServers(this.servers);
        return true;
    }

    protected void performDefaults() {
        this.servers.clear();
        this.tableViewer.refresh();
        super.performDefaults();
    }

    private class McpServerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private McpServerLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            McpServerConfig config = (McpServerConfig)element;
            switch (columnIndex) {
                case 0: {
                    return config.isEnabled() ? "\u2713" : "";
                }
                case 1: {
                    return config.getName();
                }
                case 2: {
                    Object cmd = config.getCommand();
                    List args = config.getArgs();
                    if (!args.isEmpty()) {
                        cmd = (String)cmd + " " + String.join((CharSequence)" ", args);
                    }
                    return cmd;
                }
                case 3: {
                    return this.getStatusText(config);
                }
            }
            return "";
        }

        private String getStatusText(McpServerConfig config) {
            McpServerState state = McpServerManager.getInstance().getServerState(config.getId());
            switch (state) {
                case RUNNING: {
                    return Messages.McpServersPreferencePage_StatusRunning;
                }
                case STARTING: {
                    return Messages.McpServersPreferencePage_StatusStarting;
                }
                case ERROR: {
                    return Messages.McpServersPreferencePage_StatusError;
                }
            }
            return Messages.McpServersPreferencePage_StatusStopped;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (columnIndex == 3) {
                McpServerConfig config = (McpServerConfig)element;
                McpServerState state = McpServerManager.getInstance().getServerState(config.getId());
                if (state == McpServerState.RUNNING) {
                    return Display.getDefault().getSystemColor(6);
                }
                if (state == McpServerState.ERROR) {
                    return Display.getDefault().getSystemColor(3);
                }
                if (state == McpServerState.STARTING) {
                    return Display.getDefault().getSystemColor(8);
                }
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }
    }
}

