/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.markdown;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.ui.markdown.CodeBlockNodeRenderer;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.util.Arrays;

public class FlexmarkParser {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(FlexmarkParser.class);
    private final Parser parser;
    private final HtmlRenderer renderer;

    public FlexmarkParser() {
        MutableDataSet options = new MutableDataSet();
        options.set(Parser.EXTENSIONS, Arrays.asList(TablesExtension.create(), AutolinkExtension.create(), StrikethroughExtension.create()));
        options.set(HtmlRenderer.SOFT_BREAK, (Object)"<br />\n");
        options.set(TablesExtension.COLUMN_SPANS, (Object)false);
        options.set(TablesExtension.APPEND_MISSING_COLUMNS, (Object)true);
        options.set(TablesExtension.DISCARD_EXTRA_COLUMNS, (Object)true);
        options.set(TablesExtension.HEADER_SEPARATOR_COLUMN_MATCH, (Object)true);
        this.parser = Parser.builder((DataHolder)options).build();
        this.renderer = HtmlRenderer.builder((DataHolder)options).nodeRendererFactory((NodeRendererFactory)new CodeBlockNodeRenderer.Factory()).build();
        LOG.debug("FlexmarkParser initialized with extensions: Tables, Autolink, Strikethrough");
    }

    public String toHtml(String markdown) {
        if (markdown == null || markdown.isEmpty()) {
            return "";
        }
        try {
            String normalized = markdown.replace("\r\n", "\n").replace("\r", "\n");
            Document document = this.parser.parse(normalized);
            if (document == null) {
                LOG.warn("FlexmarkParser: parser.parse() returned null");
                return this.escapeHtml(markdown);
            }
            String html = this.renderer.render((Node)document);
            LOG.debug("FlexmarkParser: rendered %d chars markdown to %d chars HTML", new Object[]{markdown.length(), html.length()});
            return html;
        }
        catch (Exception e) {
            LOG.error("FlexmarkParser: failed to parse markdown", (Throwable)e);
            return this.escapeHtml(markdown);
        }
    }

    private String escapeHtml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }
}

