/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.handlers;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.review.BslCodeReviewer;
import com.example.vibe.ui.dialogs.ReviewResultDialog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class ReviewCodeHandler
extends AbstractHandler {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(ReviewCodeHandler.class);

    /*
     * Unable to fully structure code
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block19: {
            window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            if (window == null) {
                return null;
            }
            shell = window.getShell();
            page = window.getActivePage();
            code = null;
            filePath = null;
            editor = page != null ? page.getActiveEditor() : null;
            var10_8 = editor;
            if (!(var10_8 instanceof ITextEditor)) break block19;
            var8_9 = (ITextEditor)var10_8;
            (ITextEditor)var10_8;
            document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            if (document == null) break block19;
            selection = textEditor.getSelectionProvider().getSelection();
            var15_12 = selection;
            if (!(var15_12 instanceof ITextSelection)) ** GOTO lbl-1000
            var13_13 = (ITextSelection)var15_12;
            (ITextSelection)var15_12;
            if (textSelection.getLength() > 0) {
                code = textSelection.getText();
                filePath = editor.getTitle() + " (\u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435)";
            } else lbl-1000:
            // 2 sources

            {
                code = document.get();
                filePath = editor.getTitle();
            }
        }
        if (code == null && (var14_14 = (selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event))) instanceof IStructuredSelection) {
            selection = (IStructuredSelection)var14_14;
            (IStructuredSelection)var14_14;
            var18_15 = firstElement = structuredSelection.getFirstElement();
            if (var18_15 instanceof IFile) {
                var16_16 = (IFile)var18_15;
                (IFile)var18_15;
                if (file.getName().endsWith(".bsl")) {
                    try {
                        var19_17 = null;
                        var20_20 = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader(file.getContents(), StandardCharsets.UTF_8));
                            try {
                                code = reader.lines().collect(Collectors.joining("\n"));
                                filePath = file.getFullPath().toString();
                            }
                            finally {
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                        }
                        catch (Throwable var20_21) {
                            if (var19_17 == null) {
                                var19_17 = var20_21;
                            } else if (var19_17 != var20_21) {
                                var19_17.addSuppressed(var20_21);
                            }
                            throw var19_17;
                        }
                    }
                    catch (Exception e) {
                        ReviewCodeHandler.LOG.error("Failed to read file %s: %s", new Object[]{file.getName(), e.getMessage()});
                        MessageDialog.openError((Shell)shell, (String)"\u041e\u0448\u0438\u0431\u043a\u0430", (String)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0444\u0430\u0439\u043b: " + e.getMessage()));
                        return null;
                    }
                }
            }
        }
        if (code == null || code.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043a\u043e\u0434\u0430", (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 BSL \u0444\u0430\u0439\u043b \u0438\u043b\u0438 \u043e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u0435\u0433\u043e \u0432 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0435 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438.");
            return null;
        }
        ReviewCodeHandler.LOG.info("Starting code review for: %s", new Object[]{filePath});
        reviewer = new BslCodeReviewer();
        result = reviewer.review(code, filePath);
        ReviewCodeHandler.LOG.info("Review completed: %s", new Object[]{result});
        dialog = new ReviewResultDialog(shell, result);
        dialog.open();
        return null;
    }
}

