/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.handlers;

import com.example.vibe.core.logging.LogSanitizer;
import com.example.vibe.core.logging.VibeLogger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class DumpEdtDiagnosticsHandler
extends AbstractHandler {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(DumpEdtDiagnosticsHandler.class);
    private static final int MAX_ITEMS = 200;
    private static final int MAX_MESSAGE_LEN = 240;

    /*
     * WARNING - void declaration
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        void editor;
        IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IEditorPart iEditorPart = editorPart;
        if (!(iEditorPart instanceof ITextEditor)) {
            MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"\u0414\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438 EDT", (String)"\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u043c \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u043e\u043c.");
            return null;
        }
        ITextEditor iTextEditor = (ITextEditor)iEditorPart;
        ITextEditor cfr_ignored_0 = (ITextEditor)iEditorPart;
        IEditorInput input = editor.getEditorInput();
        IFile file = this.resolveFile(input);
        DumpResult dump = this.dumpEditorDiagnostics((ITextEditor)editor, input, file);
        LOG.info("=== EDT diagnostics dump ===\n%s", new Object[]{dump.fullLog});
        StringBuilder summary = new StringBuilder();
        summary.append("\u0424\u0430\u0439\u043b: ").append(dump.fileLabel).append("\n");
        summary.append("Markers: ").append(dump.markerCount).append("\n");
        summary.append("Annotations: ").append(dump.annotationCount).append("\n\n");
        summary.append("\u0422\u043e\u043f marker types:\n").append(this.formatTopMap(dump.markerTypes)).append("\n");
        summary.append("\u0422\u043e\u043f annotation types:\n").append(this.formatTopMap(dump.annotationTypes)).append("\n");
        summary.append("\n\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0437\u0430\u043f\u0438\u0441\u0430\u043d\u044b \u0432 \u043b\u043e\u0433:\n");
        summary.append(VibeLogger.getInstance().getLogFilePath());
        MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"\u0414\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438 EDT", (String)summary.toString());
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private DumpResult dumpEditorDiagnostics(ITextEditor editor, IEditorInput input, IFile file) {
        IAnnotationModel model;
        String fileLabel = file != null ? file.getFullPath().toString() : String.valueOf(input);
        StringBuilder sb = new StringBuilder();
        sb.append("Active editor input: ").append(String.valueOf(input)).append("\n");
        sb.append("Resolved IFile: ").append(file != null ? file.getFullPath() : "null").append("\n\n");
        HashMap<String, Integer> markerTypes = new HashMap<String, Integer>();
        HashMap<String, Integer> annotationTypes = new HashMap<String, Integer>();
        ArrayList<String> markerSamples = new ArrayList<String>();
        int markerCount = 0;
        if (file != null) {
            try {
                IMarker[] markers = file.findMarkers(null, true, 0);
                markerCount = Math.min(markers.length, 200);
                sb.append("== Markers (showing up to ").append(200).append(") ==\n");
                int i = 0;
                while (i < markers.length && i < 200) {
                    IMarker m = markers[i];
                    String type = this.safeMarkerType(m);
                    markerTypes.merge(type, 1, Integer::sum);
                    String msg = String.valueOf(m.getAttribute("message", ""));
                    int line = m.getAttribute("lineNumber", -1);
                    int severity = m.getAttribute("severity", -1);
                    int charStart = m.getAttribute("charStart", -1);
                    int charEnd = m.getAttribute("charEnd", -1);
                    String row = String.format("marker[%d]: type=%s, severity=%s, line=%d, char=%d..%d, message=%s", i, type, this.formatSeverity(severity), line, charStart, charEnd, LogSanitizer.truncate((String)msg, (int)240));
                    sb.append(row).append("\n");
                    if (!msg.isBlank() && markerSamples.size() < 10) {
                        markerSamples.add(row);
                    }
                    ++i;
                }
                sb.append("\n");
            }
            catch (CoreException e) {
                sb.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f markers: ").append(e.getMessage()).append("\n\n");
            }
        } else {
            sb.append("Markers skipped: IFile not resolved.\n\n");
        }
        int annotationCount = 0;
        ArrayList<String> annotationSamples = new ArrayList<String>();
        IDocumentProvider docProvider = editor.getDocumentProvider();
        IDocument doc = docProvider != null ? docProvider.getDocument((Object)input) : null;
        IAnnotationModel iAnnotationModel = model = docProvider != null ? docProvider.getAnnotationModel((Object)input) : null;
        if (model != null) {
            sb.append("== Annotations (showing up to ").append(200).append(") ==\n");
            Iterator it = model.getAnnotationIterator();
            int idx = 0;
            while (it.hasNext() && idx < 200) {
                void ann;
                Object obj = it.next();
                Object e = obj;
                if (!(e instanceof Annotation)) {
                    ++idx;
                    continue;
                }
                Annotation cfr_ignored_0 = (Annotation)e;
                Annotation cfr_ignored_1 = (Annotation)e;
                String type = this.safeAnnotationType((Annotation)ann);
                annotationTypes.merge(type, 1, Integer::sum);
                Position pos = model.getPosition((Annotation)ann);
                int offset = pos != null ? pos.offset : -1;
                int length = pos != null ? pos.length : -1;
                int line = doc != null && offset >= 0 ? this.safeLineOfOffset(doc, offset) : -1;
                String text = Objects.toString(ann.getText(), "");
                String markerType = null;
                void var30_39 = ann;
                if (var30_39 instanceof MarkerAnnotation) {
                    void markerAnn;
                    MarkerAnnotation cfr_ignored_2 = (MarkerAnnotation)var30_39;
                    MarkerAnnotation cfr_ignored_3 = (MarkerAnnotation)var30_39;
                    IMarker marker = markerAnn.getMarker();
                    markerType = marker != null ? this.safeMarkerType(marker) : null;
                }
                String row = String.format("ann[%d]: type=%s, line=%d, offset=%d, len=%d, markerType=%s, text=%s", idx, type, line, offset, length, markerType != null ? markerType : "-", LogSanitizer.truncate((String)text, (int)240));
                sb.append(row).append("\n");
                if (!(text.isBlank() && markerType == null || annotationSamples.size() >= 10)) {
                    annotationSamples.add(row);
                }
                ++idx;
            }
            annotationCount = idx;
            sb.append("\n");
        } else {
            sb.append("Annotations skipped: annotation model not available for this editor input.\n\n");
        }
        sb.append("== Summary ==\n");
        sb.append("File: ").append(fileLabel).append("\n");
        sb.append("Markers shown: ").append(markerCount).append("\n");
        sb.append("Annotations shown: ").append(annotationCount).append("\n\n");
        if (!markerSamples.isEmpty()) {
            sb.append("Marker samples:\n");
            for (String s : markerSamples) {
                sb.append("  ").append(s).append("\n");
            }
            sb.append("\n");
        }
        if (!annotationSamples.isEmpty()) {
            sb.append("Annotation samples:\n");
            for (String s : annotationSamples) {
                sb.append("  ").append(s).append("\n");
            }
            sb.append("\n");
        }
        sb.append("Marker type histogram:\n").append(this.formatHistogram(markerTypes)).append("\n");
        sb.append("Annotation type histogram:\n").append(this.formatHistogram(annotationTypes)).append("\n");
        return new DumpResult(fileLabel, markerCount, annotationCount, markerTypes, annotationTypes, sb.toString());
    }

    /*
     * WARNING - void declaration
     */
    private IFile resolveFile(IEditorInput input) {
        IEditorInput iEditorInput = input;
        if (iEditorInput instanceof FileEditorInput) {
            void fileInput;
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            FileEditorInput cfr_ignored_0 = (FileEditorInput)iEditorInput;
            return fileInput.getFile();
        }
        Object adapted = input.getAdapter(IFile.class);
        return adapted instanceof IFile ? (IFile)adapted : null;
    }

    private int safeLineOfOffset(IDocument doc, int offset) {
        try {
            return doc.getLineOfOffset(offset) + 1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private String safeMarkerType(IMarker marker) {
        try {
            return marker.getType();
        }
        catch (CoreException coreException) {
            return "unknown-marker-type";
        }
    }

    private String safeAnnotationType(Annotation ann) {
        try {
            return ann.getType();
        }
        catch (Exception exception) {
            return ann.getClass().getName();
        }
    }

    private String formatSeverity(int sev) {
        return switch (sev) {
            case 2 -> "ERROR";
            case 1 -> "WARNING";
            case 0 -> "INFO";
            default -> String.valueOf(sev);
        };
    }

    private String formatTopMap(Map<String, Integer> map) {
        if (map.isEmpty()) {
            return "  (\u043d\u0435\u0442)\n";
        }
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(10L).map(e -> "  " + (String)e.getKey() + " = " + String.valueOf(e.getValue())).collect(Collectors.joining("\n")) + "\n";
    }

    private String formatHistogram(Map<String, Integer> map) {
        if (map.isEmpty()) {
            return "(\u043d\u0435\u0442)\n";
        }
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).map(e -> (String)e.getKey() + " = " + String.valueOf(e.getValue())).collect(Collectors.joining("\n")) + "\n";
    }

    private record DumpResult(String fileLabel, int markerCount, int annotationCount, Map<String, Integer> markerTypes, Map<String, Integer> annotationTypes, String fullLog) {
    }
}

