/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.handlers;

import com.example.vibe.core.logging.VibeLogger;
import com.example.vibe.core.settings.PromptCatalog;
import com.example.vibe.core.settings.PromptTemplateService;
import com.example.vibe.ui.views.ChatView;
import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class AddCodeHandler
extends AbstractHandler {
    private static final VibeLogger.CategoryLogger LOG = VibeLogger.forClass(AddCodeHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ChatView chatView;
        String prompt;
        block16: {
            LOG.info("execute: \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a AddCode \u0432\u044b\u0437\u0432\u0430\u043d");
            IWorkbenchWindow window = null;
            if (event != null) {
                window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
                LOG.debug("execute: \u043e\u043a\u043d\u043e \u0438\u0437 \u0441\u043e\u0431\u044b\u0442\u0438\u044f=%s", new Object[]{window != null ? "\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e" : "null"});
            }
            if (window == null) {
                window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                LOG.debug("execute: \u043e\u043a\u043d\u043e \u0438\u0437 PlatformUI=%s", new Object[]{window != null ? "\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e" : "null"});
            }
            if (window == null) {
                LOG.error("execute: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043e\u043a\u043d\u043e workbench, \u0432\u044b\u0445\u043e\u0434");
                return null;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                LOG.error("execute: \u0430\u043a\u0442\u0438\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 = null, \u0432\u044b\u0445\u043e\u0434");
                return null;
            }
            IEditorPart editor = page.getActiveEditor();
            LOG.debug("execute: \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440=%s", new Object[]{editor != null ? editor.getClass().getName() : "null"});
            if (editor == null) {
                LOG.warn("execute: \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440 = null, \u0432\u044b\u0445\u043e\u0434");
                return null;
            }
            ISelectionProvider selectionProvider = editor.getSite().getSelectionProvider();
            if (selectionProvider == null) {
                LOG.warn("execute: selectionProvider = null, \u0432\u044b\u0445\u043e\u0434");
                return null;
            }
            ISelection selection = selectionProvider.getSelection();
            LOG.debug("execute: selection=%s", new Object[]{selection != null ? selection.getClass().getName() : "null"});
            if (!(selection instanceof ITextSelection)) {
                LOG.warn("execute: selection \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f ITextSelection, \u0432\u044b\u0445\u043e\u0434");
                return null;
            }
            ITextSelection textSelection = (ITextSelection)selection;
            LOG.debug("execute: offset=%d, length=%d", new Object[]{textSelection.getOffset(), textSelection.getLength()});
            String context = "";
            ITextEditor textEditor = null;
            if (editor instanceof ITextEditor) {
                textEditor = (ITextEditor)editor;
            } else if (editor instanceof IAdaptable) {
                textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
            }
            if (textEditor != null) {
                context = this.getSurroundingContext(textEditor, textSelection.getOffset());
            }
            LOG.debug("execute: \u043a\u043e\u043d\u0442\u0435\u043a\u0441\u0442 \u0434\u043b\u0438\u043d\u043e\u0439 %d \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432", new Object[]{context.length()});
            LOG.debug("execute: \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0434\u0438\u0430\u043b\u043e\u0433\u0430 \u0432\u0432\u043e\u0434\u0430...");
            InputDialog dialog = new InputDialog(window.getShell(), "Add Code", "Describe the code you want to add:", "", null);
            if (dialog.open() != 0) {
                LOG.debug("execute: \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043e\u0442\u043c\u0435\u043d\u0438\u043b \u0434\u0438\u0430\u043b\u043e\u0433");
                return null;
            }
            String description = dialog.getValue();
            LOG.debug("execute: \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0442 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f: '%s'", new Object[]{description});
            if (description == null || description.trim().isEmpty()) {
                LOG.warn("execute: \u043f\u0443\u0441\u0442\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435, \u0432\u044b\u0445\u043e\u0434");
                return null;
            }
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("context", context);
            variables.put("request", description);
            String preferenceKey = "prompt.template.addCode";
            prompt = PromptTemplateService.getInstance().applyTemplate(preferenceKey, PromptCatalog.getDefaultTemplate((String)preferenceKey), variables, PromptCatalog.getRequiredPlaceholders((String)preferenceKey));
            try {
                LOG.debug("execute: \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 ChatView...");
                chatView = (ChatView)page.showView("com.example.vibe.ui.views.ChatView");
                if (chatView != null) break block16;
                LOG.error("execute: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c ChatView (null)");
                return null;
            }
            catch (PartInitException e) {
                LOG.error("execute: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u0438 ChatView: %s", new Object[]{e.getMessage()});
                throw new ExecutionException("Failed to open chat view", (Throwable)e);
            }
        }
        LOG.info("execute: \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0432 ChatView (\u0434\u043b\u0438\u043d\u0430=%d)", new Object[]{prompt.length()});
        chatView.sendMessage(prompt);
        LOG.debug("execute: \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e");
        return null;
    }

    private String getSurroundingContext(ITextEditor editor, int offset) {
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        if (document == null) {
            LOG.warn("getSurroundingContext: document = null");
            return "";
        }
        try {
            int line = document.getLineOfOffset(offset);
            int startLine = Math.max(0, line - 5);
            int endLine = Math.min(document.getNumberOfLines() - 1, line + 5);
            int startOffset = document.getLineOffset(startLine);
            int endOffset = document.getLineOffset(endLine) + document.getLineLength(endLine);
            return document.get(startOffset, endOffset - startOffset);
        }
        catch (BadLocationException e) {
            LOG.warn("getSurroundingContext: BadLocationException: %s", new Object[]{e.getMessage()});
            return "";
        }
    }
}

