/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.diff;

import com.example.vibe.ui.diff.ProposedChange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ProposedChangeSet {
    private final String sessionId;
    private final List<ProposedChange> changes;
    private final List<ChangeSetListener> listeners;

    public ProposedChangeSet(String sessionId) {
        this.sessionId = sessionId;
        this.changes = new ArrayList<ProposedChange>();
        this.listeners = new CopyOnWriteArrayList<ChangeSetListener>();
    }

    public void addChange(ProposedChange change) {
        this.changes.add(change);
        this.fireChangeAdded(change);
    }

    public List<ProposedChange> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    public List<ProposedChange> getChangesByStatus(ProposedChange.ChangeStatus status) {
        return this.changes.stream().filter(c -> c.getStatus() == status).collect(Collectors.toList());
    }

    public List<ProposedChange> getPendingChanges() {
        return this.getChangesByStatus(ProposedChange.ChangeStatus.PENDING);
    }

    public List<ProposedChange> getAcceptedChanges() {
        return this.getChangesByStatus(ProposedChange.ChangeStatus.ACCEPTED);
    }

    public Optional<ProposedChange> findByPath(String filePath) {
        return this.changes.stream().filter(c -> c.getFilePath().equals(filePath)).findFirst();
    }

    public Optional<ProposedChange> findByToolCallId(String toolCallId) {
        return this.changes.stream().filter(c -> toolCallId.equals(c.getToolCallId())).findFirst();
    }

    public void acceptAll() {
        for (ProposedChange change : this.changes) {
            if (!change.isPending()) continue;
            change.accept();
            this.fireChangeStatusChanged(change);
        }
    }

    public void rejectAll() {
        for (ProposedChange change : this.changes) {
            if (!change.isPending()) continue;
            change.reject();
            this.fireChangeStatusChanged(change);
        }
    }

    public void clear() {
        ArrayList<ProposedChange> removed = new ArrayList<ProposedChange>(this.changes);
        this.changes.clear();
        this.fireChangesCleared(removed);
    }

    public int size() {
        return this.changes.size();
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public int getPendingCount() {
        return (int)this.changes.stream().filter(ProposedChange::isPending).count();
    }

    public int getAcceptedCount() {
        return (int)this.changes.stream().filter(ProposedChange::isAccepted).count();
    }

    public int getRejectedCount() {
        return (int)this.changes.stream().filter(ProposedChange::isRejected).count();
    }

    public boolean isFullyReviewed() {
        return this.getPendingCount() == 0;
    }

    public boolean hasAcceptedChanges() {
        return this.getAcceptedCount() > 0;
    }

    public boolean hasActualChanges() {
        for (ProposedChange change : this.changes) {
            String before = change.getBeforeContent();
            String after = change.getAfterContent();
            if (before == null || after == null) {
                return true;
            }
            if (before.equals(after)) continue;
            return true;
        }
        return false;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void addListener(ChangeSetListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ChangeSetListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChangeAdded(ProposedChange change) {
        this.forEachListener(l -> l.onChangeAdded(this, change));
    }

    private void fireChangeStatusChanged(ProposedChange change) {
        this.forEachListener(l -> l.onChangeStatusChanged(this, change));
    }

    private void fireChangesCleared(List<ProposedChange> removed) {
        this.forEachListener(l -> l.onChangesCleared(this, removed));
    }

    private void forEachListener(Consumer<ChangeSetListener> action) {
        for (ChangeSetListener listener : this.listeners) {
            try {
                action.accept(listener);
            }
            catch (Exception exception) {}
        }
    }

    public static interface ChangeSetListener {
        default public void onChangeAdded(ProposedChangeSet set, ProposedChange change) {
        }

        default public void onChangeStatusChanged(ProposedChangeSet set, ProposedChange change) {
        }

        default public void onChangesCleared(ProposedChangeSet set, List<ProposedChange> removed) {
        }
    }
}

