/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.diff;

import java.util.Objects;

public class ProposedChange {
    private final String filePath;
    private final String beforeContent;
    private final String afterContent;
    private final ChangeKind kind;
    private final String toolCallId;
    private ChangeStatus status;
    private String description;

    public ProposedChange(String filePath, String beforeContent, String afterContent, ChangeKind kind, String toolCallId) {
        this.filePath = Objects.requireNonNull(filePath, "filePath must not be null");
        this.beforeContent = beforeContent;
        this.afterContent = afterContent;
        this.kind = Objects.requireNonNull(kind, "kind must not be null");
        this.toolCallId = toolCallId;
        this.status = ChangeStatus.PENDING;
    }

    public static ProposedChange create(String filePath, String content, String toolCallId) {
        return new ProposedChange(filePath, null, content, ChangeKind.CREATE, toolCallId);
    }

    public static ProposedChange modify(String filePath, String beforeContent, String afterContent, String toolCallId) {
        return new ProposedChange(filePath, beforeContent, afterContent, ChangeKind.MODIFY, toolCallId);
    }

    public static ProposedChange replace(String filePath, String beforeContent, String afterContent, String toolCallId) {
        return new ProposedChange(filePath, beforeContent, afterContent, ChangeKind.REPLACE, toolCallId);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getBeforeContent() {
        return this.beforeContent;
    }

    public String getAfterContent() {
        return this.afterContent;
    }

    public ChangeKind getKind() {
        return this.kind;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    public ChangeStatus getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public void setStatus(ChangeStatus status) {
        this.status = Objects.requireNonNull(status);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void accept() {
        this.status = ChangeStatus.ACCEPTED;
    }

    public void reject() {
        this.status = ChangeStatus.REJECTED;
    }

    public void markApplied() {
        this.status = ChangeStatus.APPLIED;
    }

    public void markFailed() {
        this.status = ChangeStatus.FAILED;
    }

    public boolean isPending() {
        return this.status == ChangeStatus.PENDING;
    }

    public boolean isAccepted() {
        return this.status == ChangeStatus.ACCEPTED;
    }

    public boolean isRejected() {
        return this.status == ChangeStatus.REJECTED;
    }

    public String getFileName() {
        int lastSep = Math.max(this.filePath.lastIndexOf(47), this.filePath.lastIndexOf(92));
        return lastSep >= 0 ? this.filePath.substring(lastSep + 1) : this.filePath;
    }

    public String getSummary() {
        return switch (this.kind) {
            case ChangeKind.CREATE -> "\u0421\u043e\u0437\u0434\u0430\u0442\u044c: " + this.getFileName();
            case ChangeKind.MODIFY -> "\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c: " + this.getFileName();
            case ChangeKind.REPLACE -> "\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c: " + this.getFileName();
            case ChangeKind.DELETE -> "\u0423\u0434\u0430\u043b\u0438\u0442\u044c: " + this.getFileName();
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public int getLinesDelta() {
        int beforeLines = this.beforeContent != null ? this.beforeContent.split("\n").length : 0;
        int afterLines = this.afterContent != null ? this.afterContent.split("\n").length : 0;
        return afterLines - beforeLines;
    }

    public String toString() {
        return String.format("ProposedChange[%s, %s, %s]", new Object[]{this.kind, this.filePath, this.status});
    }

    public static enum ChangeKind {
        CREATE,
        MODIFY,
        REPLACE,
        DELETE;

    }

    public static enum ChangeStatus {
        PENDING,
        ACCEPTED,
        REJECTED,
        APPLIED,
        FAILED;

    }
}

