/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.dialogs;

import com.example.vibe.core.backend.BackendConfig;
import com.example.vibe.core.backend.BackendService;
import com.example.vibe.core.backend.RegistrationResult;
import com.example.vibe.core.backend.SignupStartResult;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RegistrationDialog
extends TitleAreaDialog {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[A-Za-z0-9._%+\\-]+@[A-Za-z0-9.\\-]+\\.[A-Za-z]{2,}$");
    private static final int MIN_NAME_LENGTH = 2;
    private static final int MIN_PASSWORD_LENGTH = 8;
    private Step currentStep = Step.REQUEST_CODE;
    private Text emailText;
    private Text nameText;
    private Text passwordText;
    private Text verificationCodeText;
    private Composite codeContainer;
    private StackLayout codeLayout;
    private Composite codeHiddenComposite;
    private Composite codeVisibleComposite;
    private Button actionButton;
    private Button resendButton;
    private int resendCountdownSeconds;
    private RegistrationResult registrationResult;

    public RegistrationDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f");
        shell.setMinimumSize(520, 380);
    }

    public void create() {
        super.create();
        this.setTitle("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0432 AI-\u0441\u0435\u0440\u0432\u0438\u0441\u0435");
        this.setMessage("\u0428\u0430\u0433 1 \u0438\u0437 2. \u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u044c\u0442\u0435 \u043a\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u043d\u0430 email.");
        this.validateInput();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        Label emailLabel = new Label(container, 0);
        emailLabel.setText("Email:");
        this.emailText = new Text(container, 2048);
        this.emailText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.emailText.addModifyListener(e -> this.validateInput());
        Label nameLabel = new Label(container, 0);
        nameLabel.setText("\u0418\u043c\u044f:");
        this.nameText = new Text(container, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameText.addModifyListener(e -> this.validateInput());
        Label passwordLabel = new Label(container, 0);
        passwordLabel.setText("\u041f\u0430\u0440\u043e\u043b\u044c:");
        this.passwordText = new Text(container, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.passwordText.addModifyListener(e -> this.validateInput());
        Label serverLabel = new Label(container, 0);
        serverLabel.setText("Auth API:");
        Label serverValue = new Label(container, 0);
        serverValue.setText(BackendConfig.AUTH_BASE_URL);
        serverValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.codeContainer = new Composite(container, 0);
        this.codeLayout = new StackLayout();
        this.codeContainer.setLayout((Layout)this.codeLayout);
        this.codeContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.codeHiddenComposite = new Composite(this.codeContainer, 0);
        this.codeHiddenComposite.setLayout((Layout)new GridLayout(1, false));
        this.codeVisibleComposite = new Composite(this.codeContainer, 0);
        GridLayout codeVisibleLayout = new GridLayout(2, false);
        codeVisibleLayout.marginWidth = 0;
        codeVisibleLayout.marginHeight = 0;
        this.codeVisibleComposite.setLayout((Layout)codeVisibleLayout);
        Label codeLabel = new Label(this.codeVisibleComposite, 0);
        codeLabel.setText("\u041a\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f:");
        this.verificationCodeText = new Text(this.codeVisibleComposite, 2048);
        this.verificationCodeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.verificationCodeText.addModifyListener(e -> this.validateInput());
        Composite resendRow = new Composite(this.codeVisibleComposite, 0);
        GridLayout resendLayout = new GridLayout(1, false);
        resendLayout.marginWidth = 0;
        resendLayout.marginHeight = 0;
        resendRow.setLayout((Layout)resendLayout);
        resendRow.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.resendButton = new Button(resendRow, 8);
        this.resendButton.setText("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u0434 \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e");
        this.resendButton.setEnabled(false);
        this.resendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegistrationDialog.this.requestCode();
            }
        });
        this.codeLayout.topControl = this.codeHiddenComposite;
        this.codeContainer.layout();
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.actionButton = this.createButton(parent, 0, "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u0434", true);
        this.actionButton.setEnabled(false);
        this.createButton(parent, 1, "\u041e\u0442\u043c\u0435\u043d\u0430", false);
    }

    protected void okPressed() {
        if (this.currentStep == Step.REQUEST_CODE) {
            this.requestCode();
            return;
        }
        this.confirmSignup();
    }

    private void requestCode() {
        this.setWorkingState(true, "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043a\u043e\u0434\u0430...");
        BackendService.getInstance().signupStart(this.getEmail(), this.getName()).thenAccept(result -> {
            Display display = this.getDisplaySafe();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(() -> this.handleSignupStartResult((SignupStartResult)result));
            }
        });
    }

    private void handleSignupStartResult(SignupStartResult result) {
        if (this.isDialogDisposed()) {
            return;
        }
        this.setWorkingState(false, "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u0434");
        if (result != null && result.isSuccess()) {
            this.currentStep = Step.CONFIRM_CODE;
            this.actionButton.setText("\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044e");
            this.codeLayout.topControl = this.codeVisibleComposite;
            this.codeContainer.layout(true, true);
            this.setErrorMessage(null);
            this.setMessage("\u0428\u0430\u0433 2 \u0438\u0437 2. \u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u0434 \u0438\u0437 \u043f\u0438\u0441\u044c\u043c\u0430 \u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u0435 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044e.");
            this.startResendCountdown((int)result.getResendAvailableInSeconds());
            this.validateInput();
            return;
        }
        this.setErrorMessage(this.formatError(result != null ? result.getErrorCode() : null, result != null ? result.getError() : "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u0434"));
    }

    private void confirmSignup() {
        this.setWorkingState(true, "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435...");
        BackendService.getInstance().signupConfirm(this.getEmail(), this.getName(), this.getPassword(), this.getVerificationCode()).thenAccept(result -> {
            Display display = this.getDisplaySafe();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(() -> this.handleConfirmResult((RegistrationResult)result));
            }
        });
    }

    private void handleConfirmResult(RegistrationResult result) {
        if (this.isDialogDisposed()) {
            return;
        }
        this.setWorkingState(false, "\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044e");
        if (result != null && result.isSuccess()) {
            this.registrationResult = result;
            this.setReturnCode(0);
            this.close();
            return;
        }
        this.setErrorMessage(this.formatError(result != null ? result.getErrorCode() : null, result != null ? result.getError() : "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438"));
    }

    private void setWorkingState(boolean working, String actionText) {
        if (this.actionButton != null && !this.actionButton.isDisposed()) {
            this.actionButton.setEnabled(!working);
            this.actionButton.setText(actionText);
        }
        if (this.emailText != null && !this.emailText.isDisposed()) {
            this.emailText.setEnabled(!working && this.currentStep == Step.REQUEST_CODE);
        }
        if (this.nameText != null && !this.nameText.isDisposed()) {
            this.nameText.setEnabled(!working && this.currentStep == Step.REQUEST_CODE);
        }
        if (this.passwordText != null && !this.passwordText.isDisposed()) {
            this.passwordText.setEnabled(!working && this.currentStep == Step.REQUEST_CODE);
        }
        if (this.verificationCodeText != null && !this.verificationCodeText.isDisposed()) {
            this.verificationCodeText.setEnabled(!working);
        }
        if (this.resendButton != null && !this.resendButton.isDisposed() && working) {
            this.resendButton.setEnabled(false);
        }
    }

    private void validateInput() {
        if (this.actionButton == null || this.actionButton.isDisposed()) {
            return;
        }
        String email = this.getEmail();
        String name = this.getName();
        String password = this.getPassword();
        if (email.isEmpty()) {
            this.setErrorMessage("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 email");
            this.actionButton.setEnabled(false);
            return;
        }
        if (!EMAIL_PATTERN.matcher(email).matches()) {
            this.setErrorMessage("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 email");
            this.actionButton.setEnabled(false);
            return;
        }
        if (name.isEmpty()) {
            this.setErrorMessage("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0438\u043c\u044f");
            this.actionButton.setEnabled(false);
            return;
        }
        if (name.length() < 2) {
            this.setErrorMessage("\u0418\u043c\u044f \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043c\u0438\u043d\u0438\u043c\u0443\u043c 2 \u0441\u0438\u043c\u0432\u043e\u043b\u0430");
            this.actionButton.setEnabled(false);
            return;
        }
        if (password.length() < 8) {
            this.setErrorMessage("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043c\u0438\u043d\u0438\u043c\u0443\u043c 8 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            this.actionButton.setEnabled(false);
            return;
        }
        if (this.currentStep == Step.CONFIRM_CODE && this.getVerificationCode().isEmpty()) {
            this.setErrorMessage("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u0438\u0437 \u043f\u0438\u0441\u044c\u043c\u0430");
            this.actionButton.setEnabled(false);
            return;
        }
        this.setErrorMessage(null);
        this.actionButton.setEnabled(true);
    }

    private void startResendCountdown(int seconds) {
        this.resendCountdownSeconds = Math.max(0, seconds);
        this.updateResendButton();
        this.scheduleNextResendTick();
    }

    private void scheduleNextResendTick() {
        if (this.resendCountdownSeconds <= 0) {
            return;
        }
        Display display = this.getDisplaySafe();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.timerExec(1000, () -> {
            if (this.isDialogDisposed()) {
                return;
            }
            if (this.resendCountdownSeconds > 0) {
                --this.resendCountdownSeconds;
                this.updateResendButton();
                this.scheduleNextResendTick();
            }
        });
    }

    private void updateResendButton() {
        if (this.resendButton == null || this.resendButton.isDisposed()) {
            return;
        }
        if (this.resendCountdownSeconds > 0) {
            this.resendButton.setEnabled(false);
            this.resendButton.setText("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u0434 \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e (" + this.resendCountdownSeconds + " c)");
        } else {
            this.resendButton.setEnabled(true);
            this.resendButton.setText("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u0434 \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e");
        }
    }

    private String formatError(String errorCode, String fallback) {
        if ("verification_required".equals(errorCode)) {
            return "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u0438\u0437 \u043f\u0438\u0441\u044c\u043c\u0430";
        }
        if ("verification_not_started".equals(errorCode)) {
            return "\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u0435 \u043a\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f";
        }
        if ("verification_invalid_code".equals(errorCode)) {
            return "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043a\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f";
        }
        if ("verification_expired".equals(errorCode)) {
            return "\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043a\u043e\u0434\u0430 \u0438\u0441\u0442\u0451\u043a. \u0417\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u0435 \u043d\u043e\u0432\u044b\u0439 \u043a\u043e\u0434.";
        }
        if ("verification_too_many_attempts".equals(errorCode) || "rate_limited".equals(errorCode)) {
            return "\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u043f\u043e\u043f\u044b\u0442\u043e\u043a. \u041f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435 \u0438 \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0441\u043d\u043e\u0432\u0430.";
        }
        if ("already_registered".equals(errorCode)) {
            return "\u042d\u0442\u043e\u0442 email \u0443\u0436\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d";
        }
        if ("service_unavailable".equals(errorCode)) {
            return "\u0421\u0435\u0440\u0432\u0438\u0441 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d";
        }
        return fallback != null && !fallback.isEmpty() ? fallback : "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438";
    }

    private String getEmail() {
        return this.emailText != null ? this.emailText.getText().trim() : "";
    }

    private String getName() {
        return this.nameText != null ? this.nameText.getText().trim() : "";
    }

    private String getPassword() {
        return this.passwordText != null ? this.passwordText.getText() : "";
    }

    private String getVerificationCode() {
        return this.verificationCodeText != null ? this.verificationCodeText.getText().trim() : "";
    }

    private boolean isDialogDisposed() {
        return this.getShell() == null || this.getShell().isDisposed();
    }

    private Display getDisplaySafe() {
        Shell shell = this.getShell();
        return shell != null ? shell.getDisplay() : Display.getDefault();
    }

    public RegistrationResult getRegistrationResult() {
        return this.registrationResult;
    }

    private static enum Step {
        REQUEST_CODE,
        CONFIRM_CODE;

    }
}

