/*
 * Decompiled with CFR 0.152.
 */
package com.example.vibe.ui.dialogs;

import com.example.vibe.core.backend.BackendConfig;
import com.example.vibe.core.backend.BackendService;
import com.example.vibe.core.backend.RegistrationResult;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginDialog
extends TitleAreaDialog {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[A-Za-z0-9._%+\\-]+@[A-Za-z0-9.\\-]+\\.[A-Za-z]{2,}$");
    private static final int MIN_PASSWORD_LENGTH = 8;
    private Text emailText;
    private Text passwordText;
    private Button loginButton;
    private RegistrationResult loginResult;

    public LoginDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("\u0412\u0445\u043e\u0434");
        shell.setMinimumSize(480, 280);
    }

    public void create() {
        super.create();
        this.setTitle("\u0412\u0445\u043e\u0434 \u0432 AI-\u0441\u0435\u0440\u0432\u0438\u0441");
        this.setMessage("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 email \u0438 \u043f\u0430\u0440\u043e\u043b\u044c \u0434\u043b\u044f \u0432\u0445\u043e\u0434\u0430.");
        this.validateInput();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        Label emailLabel = new Label(container, 0);
        emailLabel.setText("Email:");
        this.emailText = new Text(container, 2048);
        this.emailText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.emailText.addModifyListener(e -> this.validateInput());
        Label passwordLabel = new Label(container, 0);
        passwordLabel.setText("\u041f\u0430\u0440\u043e\u043b\u044c:");
        this.passwordText = new Text(container, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.passwordText.addModifyListener(e -> this.validateInput());
        Label serverLabel = new Label(container, 0);
        serverLabel.setText("Auth API:");
        Label serverValue = new Label(container, 0);
        serverValue.setText(BackendConfig.AUTH_BASE_URL);
        serverValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.loginButton = this.createButton(parent, 0, "\u0412\u043e\u0439\u0442\u0438", true);
        this.loginButton.setEnabled(false);
        this.createButton(parent, 1, "\u041e\u0442\u043c\u0435\u043d\u0430", false);
    }

    protected void okPressed() {
        this.setWorkingState(true);
        BackendService.getInstance().login(this.getEmail(), this.getPassword()).thenAccept(result -> {
            Display display;
            Display display2 = display = this.getShell() != null ? this.getShell().getDisplay() : Display.getDefault();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(() -> this.handleLoginResult((RegistrationResult)result));
            }
        });
    }

    private void handleLoginResult(RegistrationResult result) {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return;
        }
        this.setWorkingState(false);
        if (result != null && result.isSuccess()) {
            this.loginResult = result;
            this.setReturnCode(0);
            this.close();
            return;
        }
        this.setErrorMessage(this.formatError(result != null ? result.getErrorCode() : null, result != null ? result.getError() : "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0445\u043e\u0434\u0430"));
    }

    private void setWorkingState(boolean working) {
        if (this.loginButton != null && !this.loginButton.isDisposed()) {
            this.loginButton.setEnabled(!working);
            this.loginButton.setText(working ? "\u0412\u0445\u043e\u0434..." : "\u0412\u043e\u0439\u0442\u0438");
        }
        if (this.emailText != null && !this.emailText.isDisposed()) {
            this.emailText.setEnabled(!working);
        }
        if (this.passwordText != null && !this.passwordText.isDisposed()) {
            this.passwordText.setEnabled(!working);
        }
    }

    private void validateInput() {
        if (this.loginButton == null || this.loginButton.isDisposed()) {
            return;
        }
        if (this.getEmail().isEmpty()) {
            this.setErrorMessage("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 email");
            this.loginButton.setEnabled(false);
            return;
        }
        if (!EMAIL_PATTERN.matcher(this.getEmail()).matches()) {
            this.setErrorMessage("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 email");
            this.loginButton.setEnabled(false);
            return;
        }
        if (this.getPassword().length() < 8) {
            this.setErrorMessage("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043c\u0438\u043d\u0438\u043c\u0443\u043c 8 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            this.loginButton.setEnabled(false);
            return;
        }
        this.setErrorMessage(null);
        this.loginButton.setEnabled(true);
    }

    private String formatError(String errorCode, String fallback) {
        if ("invalid_credentials".equals(errorCode)) {
            return "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 email \u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c";
        }
        if ("rate_limited".equals(errorCode)) {
            return "\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u0432\u0445\u043e\u0434\u0430. \u041f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435 \u0438 \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0441\u043d\u043e\u0432\u0430.";
        }
        if ("service_unavailable".equals(errorCode)) {
            return "\u0421\u0435\u0440\u0432\u0438\u0441 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d";
        }
        return fallback != null && !fallback.isEmpty() ? fallback : "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0445\u043e\u0434\u0430";
    }

    private String getEmail() {
        return this.emailText != null ? this.emailText.getText().trim() : "";
    }

    private String getPassword() {
        return this.passwordText != null ? this.passwordText.getText() : "";
    }

    public RegistrationResult getLoginResult() {
        return this.loginResult;
    }
}

